/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.sv;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "centralafrikansk tid",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskvanormaltid",
               "MST",
               "Moskvasommartid",
               "MST",
               "Moskvatid",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japan, normaltid",
               "JST",
               "Japan, sommartid",
               "JDT",
               "japansk tid",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "pakistansk normaltid",
               "PST",
               "pakistansk sommartid",
               "PST",
               "pakistansk tid",
               "PT",
            };
        final String[] Taipei = new String[] {
               "Taipeinormaltid",
               "TST",
               "Taipeisommartid",
               "TDT",
               "Taipeitid",
               "TT",
            };
        final String[] Hovd = new String[] {
               "Hovdnormaltid",
               "HST",
               "Hovdsommartid",
               "HST",
               "Hovdtid",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magadannormaltid",
               "MST",
               "Magadansommartid",
               "MST",
               "Magadantid",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "v\u00e4stcentralaustralisk normaltid",
               "ACWST",
               "v\u00e4stcentralaustralisk sommartid",
               "ACWDT",
               "v\u00e4stcentralaustralisk tid",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Centraleuropa, normaltid",
               "CET",
               "Centraleuropa, sommartid",
               "CEST",
               "centraleuropeisk tid",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinnormaltid",
               "SST",
               "Sachalinsommartid",
               "SST",
               "Sachalintid",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "paraguayansk normaltid",
               "PST",
               "paraguayansk sommartid",
               "PST",
               "paraguayansk tid",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "malaysisk tid",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern, normaltid",
               "EST",
               "Eastern, sommartid",
               "EDT",
               "\u00f6stnordamerikansk tid",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howenormaltid",
               "LHST",
               "Lord Howesommartid",
               "LHDT",
               "Lord Howetid",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "nyzeel\u00e4ndsk normaltid",
               "NZST",
               "nyzeel\u00e4ndsk sommartid",
               "NZDT",
               "nyzeel\u00e4ndsk tid",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Brittiska Indiska ocean\u00f6arnas tid",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsknormaltid",
               "YST",
               "Jakutsksommartid",
               "YST",
               "Jakutsktid",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "Mauritiustid",
               "MST",
               "Mauritiussommartid",
               "MST",
               "Mauritiustid",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00f6stafrikansk tid",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u00f6sttimorisk tid",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "Salomon\u00f6arnas tid",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "Kosraetid",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall\u00f6arnas tid",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00d6steuropa, normaltid",
               "EET",
               "\u00d6steuropa, sommartid",
               "EEST",
               "\u00f6steuropeisk tid",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland, normaltid",
               "NST",
               "Newfoundland, sommartid",
               "NDT",
               "Newfoundlandtid",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "afghansk tid",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongnormaltid",
               "HKST",
               "Hongkongsommartid",
               "HKST",
               "Hongkongtid",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "v\u00e4stargentinsk normaltid",
               "WAST",
               "v\u00e4stargentinsk sommartid",
               "WAST",
               "v\u00e4stargentinsk tid",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Atlantic, normaltid",
               "AST",
               "Atlantic, sommartid",
               "ADT",
               "nordamerikansk atlanttid",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponapetid",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Bolivia = new String[] {
               "boliviansk tid",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre och Miquelonnormalid",
               "PMST",
               "Pierre och Miquelonsommartid",
               "PMDT",
               "Pierre och Miquelontid",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "indokinesisk tid",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgnormaltid",
               "YST",
               "Jekaterinburgsommartid",
               "YST",
               "Jekaterinburgtid",
               "YT",
            };
        final String[] Maldives = new String[] {
               "Maldivernatid",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "Tahititid",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "Israel, normaltid",
               "IST",
               "Israel, sommartid",
               "IDT",
               "israelisk tid",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "centralindonesisk tid",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "Wallis- och Futuna\u00f6arnas tid",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "sydafrikansk tid",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowatid",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "Line\u00f6arnas tid",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Uzbekistan = new String[] {
               "uzbekisk normaltid",
               "UST",
               "uzbekisk sommartid",
               "UST",
               "uzbekisk tid",
               "UT",
            };
        final String[] Omsk = new String[] {
               "Omsknormaltid",
               "OST",
               "Omsksommartid",
               "OST",
               "Omsktid",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "Seychellernatid",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "uruguayansk normaltid",
               "UST",
               "uruguayansk sommartid",
               "UST",
               "uruguayansk tid",
               "UT",
            };
        final String[] Nepal = new String[] {
               "nepalesisk tid",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-normaltid",
               "UBST",
               "Ulaanbaatar-sommartid",
               "UBST",
               "Ulaanbaatar-tid",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Central, normaltid",
               "CST",
               "Central, sommartid",
               "CDT",
               "centralnordamerikansk tid",
               "CT",
            };
        final String[] Truk = new String[] {
               "Truktid",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "Niuetid",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "Waketid",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "falklands\u00f6arnas normaltid",
               "FIST",
               "falklands\u00f6arnas sommartid",
               "FIST",
               "falklands\u00f6arnas tid",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatunormaltid",
               "VST",
               "Vanuatusommartid",
               "VST",
               "Vanuatutid",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsknormaltid",
               "NST",
               "Novosibirsksommartid",
               "NST",
               "Novosibirsktid",
               "NT",
            };
        final String[] Singapore = new String[] {
               "Singaporetid",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "azorisk normaltid",
               "AST",
               "azorisk sommartid",
               "AST",
               "azorisk tid",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "bhutansk tid",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "Surinamtid",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Nauru = new String[] {
               "Naurutid",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsknormaltid",
               "KST",
               "Krasnojarsksommartid",
               "KST",
               "Krasnojarsktid",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "v\u00e4st kazakstansk tid",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "burmesisk tid",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "Jul\u00f6ns tid",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazonasnormaltid",
               "AST",
               "Amazonassommartid",
               "AST",
               "amazonastid",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00f6st kazakstansk tid",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "Fijinormaltid",
               "FST",
               "Fijisommartid",
               "FST",
               "Fijitid",
               "FT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9uniontid",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "Keeling\u00f6arnas tid",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "Chathamnormaltid",
               "CST",
               "Chathamsommartid",
               "CDT",
               "Chathamtid",
               "CT",
            };
        final String[] Vostok = new String[] {
               "Vostoktid",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u00f6stargentinsk normaltid",
               "AST",
               "\u00f6stargentinsk sommartid",
               "AST",
               "\u00f6stargentinsk tid",
               "AT",
            };
        final String[] Gambier = new String[] {
               "Gambiertid",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalutid",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "Gal\u00e1pagostid",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Macquarietid",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "venezuelansk tid",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Honolulunormaltid",
               "HAST",
               "Honolulusommartid",
               "HADT",
               "Honolulutid",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "centralaustralisk normaltid",
               "ACST",
               "centralaustralisk sommartid",
               "ACDT",
               "centralaustralisk tid",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Pacific, normaltid",
               "PST",
               "Pacific, sommartid",
               "PDT",
               "v\u00e4stnordamerikansk tid",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Enderburytid",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmensk normaltid",
               "TST",
               "turkmensk sommartid",
               "TST",
               "turkmensk tid",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "v\u00e4steuropeisk normaltid",
               "WET",
               "v\u00e4steuropeisk sommartid",
               "WEST",
               "v\u00e4steuropeisk tid",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verdenormaltid",
               "CVST",
               "Kap Verdesommartid",
               "CVST",
               "Kap Verdetid",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk\u00f6ns tid",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "Guyanatid",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairntid",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rotheratid",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Samoa = new String[] {
               "samoansk tid",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palautid",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdzjansk normaltid",
               "AST",
               "azerbajdzjansk sommartid",
               "AST",
               "azerbajdzjansk tid",
               "AT",
            };
        final String[] Mawson = new String[] {
               "Mawsontid",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davistid",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "kubansk normaltid",
               "CST",
               "kubansk sommartid",
               "CDT",
               "kubansk tid",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "v\u00e4stafrikansk normaltid",
               "WAST",
               "v\u00e4stafrikansk sommartid",
               "WAST",
               "v\u00e4stafrikansk tid",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwichtid",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "filippinsk normaltid",
               "PST",
               "filippinsk sommartid",
               "PST",
               "filippinsk tid",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Franska Sydterritoriernas tid",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "sydgeorgisk tid",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "Nya Kaledoniennormaltid",
               "NCST",
               "Nya Kaledoniensommartid",
               "NCST",
               "Nya Kaledonientid",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "Volgogradnormaltid",
               "VST",
               "Volgogradsommartid",
               "VST",
               "Volgogradtid",
               "VT",
            };
        final String[] Brunei = new String[] {
               "Bruneitid",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "iransk normaltid",
               "IST",
               "iransk sommartid",
               "IDT",
               "iransk tid",
               "IT",
            };
        final String[] Easter = new String[] {
               "P\u00e5sk\u00f6ns normaltid",
               "EIST",
               "P\u00e5sk\u00f6ns sommartid",
               "EIST",
               "P\u00e5sk\u00f6ns tid",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont d\u2019Urville-tid",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjikistantid",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tonga = new String[] {
               "Tonganormaltid",
               "TST",
               "Tongasommmartid",
               "TST",
               "Tongatid",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "bangladeshisk normaltid",
               "BST",
               "bangladeshisk sommartid",
               "BST",
               "bangladeshisk tid",
               "BT",
            };
        final String[] Peru = new String[] {
               "peruansk normalid",
               "PST",
               "peruansk sommartid",
               "PST",
               "peruansk tid",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "v\u00e4stgr\u00f6nl\u00e4ndsk normaltid",
               "WGST",
               "v\u00e4stgr\u00f6nl\u00e4ndsk sommartid",
               "WGST",
               "v\u00e4stgr\u00f6nl\u00e4ndsk tid",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "ecuadoriansk tid",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u00f6stgr\u00f6nl\u00e4ndsk normaltid",
               "EGST",
               "\u00f6stgr\u00f6nl\u00e4ndsk sommartid",
               "EGST",
               "\u00f6stgr\u00f6nl\u00e4ndsk tid",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Persiska vikentid",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00f6stindonesisk tid",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "koreansk normaltid",
               "KST",
               "koreansk sommartid",
               "KDT",
               "koreansk tid",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "v\u00e4staustralisk normaltid",
               "AWST",
               "v\u00e4staustralisk sommartid",
               "AWDT",
               "v\u00e4staustralisk tid",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizisk tid",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "v\u00e4stindonesisk tid",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00f6staustralisk normaltid",
               "AEST",
               "\u00f6staustralisk sommartid",
               "AEDT",
               "\u00f6staustralisk tid",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Franska Guyanatid",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "colombiansk normaltid",
               "CST",
               "colombiansk sommartid",
               "CST",
               "colombiansk tid",
               "CT",
            };
        final String[] Chile = new String[] {
               "chilensk normaltid",
               "CST",
               "chilensk sommartid",
               "CST",
               "chilensk tid",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Kiribatitid",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "Mountain, normaltid",
               "MST",
               "Mountain, sommartid",
               "MDT",
               "Klippiga Bergentid",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesastid",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "saudiarabisk normaltid",
               "AST",
               "saudiarabisk sommartid",
               "ADT",
               "saudiarabisk tid",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska, normaltid",
               "AKST",
               "Alaska, sommartid",
               "AKDT",
               "alaskatid",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoknormaltid",
               "VST",
               "Vladivostoksommartid",
               "VST",
               "Vladivostoktid",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "Chamorrotid",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsknormaltid",
               "IST",
               "Irkutsksommartid",
               "IST",
               "Irkutsktid",
               "IT",
            };
        final String[] Georgia = new String[] {
               "georgisk normaltid",
               "GST",
               "georgisk sommartid",
               "GST",
               "georgisk tid",
               "GT",
            };
        final String[] Tokelau = new String[] {
               "Tokelautid",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nya Guineas tid",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhanormaltid",
               "FNST",
               "Fernando de Noronhasommartid",
               "FNST",
               "Fernando de Noronhatid",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Tjojbalsannormaltid",
               "CST",
               "Tjojbalsansommartid",
               "CST",
               "Tjojbalsantid",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Brasilianormaltid",
               "BST",
               "Brasiliasommartid",
               "BST",
               "brasiliansk tid",
               "BT",
            };
        final String[] China = new String[] {
               "Kina, normaltid",
               "CST",
               "Kina, sommartid",
               "CDT",
               "kinesisk tid",
               "CT",
            };
        final String[] Armenia = new String[] {
               "armenisk normaltid",
               "AST",
               "armenisk somartid",
               "AST",
               "armenisk tid",
               "AT",
            };
        final String[] India = new String[] {
               "indisk tid",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cook\u00f6arnas normaltid",
               "CIST",
               "Cook\u00f6arnas sommartid",
               "CIHST",
               "Cook\u00f6arnas tid",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
