' *****************************************************************************
' t@C:       AccessDB.vb
' o[WF      Ver.1.0.0.0
' :
'
' Copyright(c) 2005 KEYENCE CORPORATION. All rights reserved.
' *****************************************************************************
Option Explicit On 
Imports System.Data.OleDb
Imports btnaviReqHandler

Class AccessDB
    ' f[^x[XpIuWFNg
    Private cnt As OleDbConnection

    'WW[
    Public Shared WaitTime As Short
    Public Shared IsWaitTime As Boolean

    Private ReadOnly Property m_strIniFileName() As String
        Get
            Return Application.StartupPath & "\DataBase.ini"
        End Get
    End Property

    Private m_strSchemaName As String

#Region "NEIE[eBeB"

    Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" ( _
              ByVal lpApplicationName As String, _
              ByVal lpKeyName As String, _
              ByVal lpDefault As String, _
              ByVal lpReturnedString As String, _
              ByVal nSize As Integer, _
              ByVal lpFileName As String) As Integer

    Public Sub InitDB()
        ' f[^x[X̐ݒs

        Dim strBuffListener As String = New String(" "c, 1024)
        Dim strBuffUserID As String = New String(" "c, 1024)
        Dim strBuffPassword As String = New String(" "c, 1024)
        Dim strBuffSchemaName As String = New String(" "c, 1024)
        Dim strBuffInitialC As String = New String(" "c, 1024)
        Dim strListenerName As String
        Dim strUserID As String
        Dim strPassword As String
        Dim strInitialC As String
        GetPrivateProfileString("DATABASE SETTING", "ListenerName", "", strBuffListener, strBuffListener.Length, m_strIniFileName)
        strListenerName = strBuffListener.Substring(0, strBuffListener.IndexOf(vbNullChar))
        GetPrivateProfileString("DATABASE SETTING", "UserID", "", strBuffUserID, strBuffUserID.Length, m_strIniFileName)
        strUserID = strBuffUserID.Substring(0, strBuffUserID.IndexOf(vbNullChar))
        GetPrivateProfileString("DATABASE SETTING", "Password", "", strBuffPassword, strBuffPassword.Length, m_strIniFileName)
        strPassword = strBuffPassword.Substring(0, strBuffPassword.IndexOf(vbNullChar))
        GetPrivateProfileString("DATABASE SETTING", "SchemaName", "", strBuffSchemaName, strBuffSchemaName.Length, m_strIniFileName)
        m_strSchemaName = strBuffSchemaName.Substring(0, strBuffSchemaName.IndexOf(vbNullChar))
        GetPrivateProfileString("DATABASE SETTING", "InitialC", "", strBuffInitialC, strBuffInitialC.Length, m_strIniFileName)
        strInitialC = strBuffInitialC.Substring(0, strBuffInitialC.IndexOf(vbNullChar))

        'Dim MdbSource As String = "Provider=Microsoft.Jet.OLEDB.4.0;" & "Data Source=" & GetDBPath() & "\BTNaviBaseApp.mdb;"
        'Dim dbConnectString As String = "Provider=OraOLEDB.Oracle;" & "Data Source=" & strListenerName & ";User Id=" & strUserID & ";Password=" & strPassword & ";"
        Dim dbConnectString As String = "Provider=SQLOLEDB;" & "Data Source=" & strListenerName & ";Initial Catalog=" & strInitialC & ";User Id=" & strUserID & ";Password=" & strPassword & ";"

        cnt = New OleDbConnection
        cnt.ConnectionString = dbConnectString
        'cnt.ConnectionString = MdbSource

        Try
            cnt.Open()
        Catch ex As Exception
            MsgBox("f[^x[XJ܂ł")
            MsgBox(ex.ToString())
            End
            'ADOXgāAVKMDBt@C쐬ꍇB
            'Dim catTest As New ADOX.Catalog
            'catTest.Create(MdbSource)
            'cnt.Open()
        End Try
    End Sub

    Public Sub ExitDB()
        If cnt.State = ConnectionState.Open Then
            cnt.Close()
        End If
    End Sub

    Public Function Exec_Sql(ByRef SqlData As String) As Boolean
        Try
            If cnt.State = ConnectionState.Closed Then cnt.Open()
            Dim cmd As New OleDbCommand(SqlData, cnt)
            If IsWaitTime = True And System.Threading.Thread.CurrentThread.IsBackground Then
                System.Threading.Thread.Sleep(WaitTime)
            End If
            cmd.ExecuteNonQuery()
            Exec_Sql = True
        Catch ex As Exception
            RemoteAccess.ErrorLog("[SQL ERROR] '" & SqlData & "' -> " & ex.Message)
            Exec_Sql = False
        End Try
    End Function

    Public Function GetSqlResult(ByRef SqlData As String, ByVal TableName As String) As DataTable
        Try
            Dim ret As New DataTable
            If cnt.State = ConnectionState.Closed Then cnt.Open()
            Dim oOleAdap As New OleDbDataAdapter(SqlData, cnt)
            If IsWaitTime = True And System.Threading.Thread.CurrentThread.IsBackground Then
                System.Threading.Thread.Sleep(WaitTime)
            End If

            oOleAdap.Fill(ret)
            ret.TableName = TableName
            GetSqlResult = ret
        Catch ex As Exception
            GetSqlResult = Nothing
        End Try
    End Function

    ' DELETER}h̍쐬
    Private Function CreateDeleteCommand(ByVal dt As DataTable, ByVal AddTablename As Boolean) As OleDbCommand
        Dim cmd As New OleDbCommand
        Dim SqlStr2 As String
        Dim i As Integer

        cmd.CommandText = "DELETE FROM " & dt.TableName & " WHERE "

        i = 1
        SqlStr2 = ""
        For Each col As DataColumn In dt.Columns
            If AddTablename = True Then
                SqlStr2 = SqlStr2 & " ( " & dt.TableName & "." & col.ColumnName & " = ? ) AND "
            Else
                SqlStr2 = SqlStr2 & " ( " & col.ColumnName & " = ? ) AND "
            End If

            Dim param As New OleDbParameter
            param.ParameterName = "@p" & i
            param.SourceColumn = col.ColumnName
            If col.DataType Is System.Type.GetType("System.String") Then
                param.OleDbType = OleDbType.VarChar
            Else
                param.OleDbType = OleDbType.Integer
            End If
            param.SourceVersion = DataRowVersion.Original
            cmd.Parameters.Add(param)
        Next

        ' Ōɕt(AND)j
        cmd.CommandText = cmd.CommandText & Left(SqlStr2, Len(SqlStr2) - 5)
        cmd.Connection = cnt

        CreateDeleteCommand = cmd
    End Function

    ' INSERTR}h̍쐬
    Private Function CreateInsertCommand(ByVal dt As DataTable) As OleDbCommand
        Dim cmd As New OleDbCommand
        Dim SqlStr As String
        Dim i As Integer

        cmd.CommandText = "INSERT INTO " & dt.TableName & " VALUES ("

        i = 1
        SqlStr = ""
        For Each col As DataColumn In dt.Columns
            SqlStr = SqlStr & " ?, "
            Dim param As New OleDbParameter
            param.ParameterName = "@p" & i
            param.SourceColumn = col.ColumnName
            If col.DataType Is System.Type.GetType("System.String") Then
                param.OleDbType = OleDbType.VarChar
            Else
                param.OleDbType = OleDbType.Integer
            End If
            param.SourceVersion = DataRowVersion.Original
            cmd.Parameters.Add(param)
        Next

        ' ŌɕtJ}j
        cmd.CommandText = cmd.CommandText & Left(SqlStr, Len(SqlStr) - 2) & ")"
        cmd.Connection = cnt

        CreateInsertCommand = cmd
    End Function

    ' UPDATER}h̍쐬
    Private Function CreateUpdateCommand(ByVal dt As DataTable, ByVal AddTablename As Boolean) As OleDbCommand
        Dim cmd As New OleDbCommand
        Dim SqlStr As String
        Dim i As Integer

        cmd.CommandText = "UPDATE " & dt.TableName & " SET "
        i = 1
        SqlStr = ""
        For Each col As DataColumn In dt.Columns
            If AddTablename = True Then
                SqlStr = SqlStr & dt.TableName & "." & col.ColumnName & " = ?, "
            Else
                SqlStr = SqlStr & col.ColumnName & " = ?, "
            End If

            Dim param As New OleDbParameter
            param.ParameterName = "@p" & i
            param.SourceColumn = col.ColumnName
            If col.DataType Is System.Type.GetType("System.String") Then
                param.OleDbType = OleDbType.VarChar
            Else
                param.OleDbType = OleDbType.Integer
            End If
            param.SourceVersion = DataRowVersion.Current
            cmd.Parameters.Add(param)
        Next

        ' ŌɕtJ}j
        cmd.CommandText = cmd.CommandText & Left(SqlStr, Len(SqlStr) - 2) & " WHERE "

        SqlStr = ""
        i = 1
        For Each col As DataColumn In dt.Columns
            If AddTablename = True Then
                SqlStr = SqlStr & " ( " & dt.TableName & "." & col.ColumnName & " = ? ) AND "
            Else
                SqlStr = SqlStr & " ( " & col.ColumnName & " = ? ) AND "
            End If

            Dim param As New OleDbParameter
            param.ParameterName = "@p" & i
            param.SourceColumn = col.ColumnName
            If col.DataType Is System.Type.GetType("System.String") Then
                param.OleDbType = OleDbType.VarChar
            Else
                param.OleDbType = OleDbType.Integer
            End If
            param.SourceVersion = DataRowVersion.Original
            cmd.Parameters.Add(param)
        Next

        ' Ōɕt(AND)j
        cmd.CommandText = cmd.CommandText & Left(SqlStr, Len(SqlStr) - 5)
        cmd.Connection = cnt

        CreateUpdateCommand = cmd
    End Function

    Private Function CreateFieldTable(ByRef FieldNames() As String, ByRef Types() As Type, ByRef tablename As String) As Short
        Dim i As Integer
        Dim SqlStr As String = String.Empty

        Try
            SqlStr = "SELECT * FROM " & tablename & ";"
            If cnt.State = ConnectionState.Closed Then cnt.Open()
            Dim cmd As New OleDbCommand(SqlStr, cnt)
            Using dr As OleDbDataReader = cmd.ExecuteReader(CommandBehavior.SchemaOnly)

                ReDim FieldNames(dr.FieldCount)
                ReDim Types(dr.FieldCount)

                For i = 0 To dr.FieldCount - 1
                    FieldNames(i) = dr.GetName(i)
                    Types(i) = dr.GetFieldType(i)
                Next

                CreateFieldTable = dr.FieldCount
                dr.Close()
            End Using
        Catch ex As Exception
            CreateFieldTable = -1
        End Try

    End Function

    Public Function GetDBPath() As String
        'LɂƁAst@CꏊɂMDBɃANZX        
        GetDBPath = Application.StartupPath
        'LɂƁAJgfBNgɂMDBɃANZX
        'GetDBPath = "."
    End Function

    Public Function CreateTable(ByRef tablename As String, ByRef NewRecords As BTDBRecords2) As Boolean

        Dim MaxIndex As Short
        Dim Result As Boolean
        Dim MakeTableSql As String
        Dim MakeTableSql2 As String
        Dim i As Short

        ' ̓tB[h΃e[u쐬͍sȂ
        If NewRecords.Count < 1 Then
            CreateTable = False
            Exit Function
        End If

        ' e[uāAꖼe[u݂Ă΁A쐬Ȃ
        If SearchTable(tablename) Then
            CreateTable = False
            Exit Function
        End If

        ' NewRecordsŎw肳Ăő̗ԂT
        MaxIndex = -1
        For i = 0 To NewRecords.Count - 1
            If NewRecords(i).Index > MaxIndex Then
                MaxIndex = NewRecords(i).Index
            End If
        Next

        ' e[u̐VK쐬
        MakeTableSql = "CREATE TABLE " & tablename & "("
        Dim StrI As String
        For i = 0 To MaxIndex
            StrI = CStr(i + 1)
            MakeTableSql = MakeTableSql & "field" & StrI & " Varchar,"
        Next i

        MakeTableSql2 = Left(MakeTableSql, Len(MakeTableSql) - 1)
        MakeTableSql2 = MakeTableSql2 & ")"

        Result = Exec_Sql(MakeTableSql2)
        If Result = False Then
            CreateTable = False
            Exit Function
        End If

        CreateTable = True

    End Function

#End Region

#Region "e[uXg"
    Private Shared tableNames() As String

    Public Function GetTableName(ByVal position As Short) As Object
        SyncLock tableNames
            GetTableName = tableNames(position)
        End SyncLock
    End Function

    Public Function GetTableCount() As Integer
        If tableNames Is Nothing Then
            GetTableCount = 0
            Exit Function
        End If

        SyncLock tableNames
            GetTableCount = tableNames.Length - 1
        End SyncLock
    End Function

    Public Sub UpdateTableName()
        Dim i As Integer
        Dim schemaTable As DataTable

        schemaTable = cnt.GetOleDbSchemaTable(OleDbSchemaGuid.Tables, New Object() {Nothing, m_strSchemaName, Nothing, "TABLE"})

        If tableNames Is Nothing Then
            tableNames = New String() {""}
        End If

        SyncLock tableNames
            ReDim tableNames(schemaTable.Rows.Count)
            For i = 0 To schemaTable.Rows.Count - 1
                tableNames(i) = CStr(schemaTable.Rows(i).ItemArray(2))
            Next
        End SyncLock
    End Sub

    Public Function SearchTable(ByRef tablename As String) As Boolean
        SearchTable = False

        SyncLock tableNames
            For Each name As String In tableNames
                If name = tablename Then
                    SearchTable = True
                    Exit For
                End If
            Next
        End SyncLock

    End Function

#End Region

#Region "SQL쐬"

    ' INSERTsSQL쐬
    Public Function MakeSql_Insert(ByRef tablename As String, ByRef NewRecords As BTDBRecords2) As String
        Dim MaxIndex As Short
        Dim InsertData() As String
        Dim SqlStr As String
        Dim i As Short

        ' Mf[^
        ReDim InsertData(0)

        ' INSERTẻ
        ' InsertData()SETf[^i[
        If NewRecords.Count < 1 Then
            MakeSql_Insert = ""
        End If

        MaxIndex = -1
        For i = 0 To NewRecords.Count - 1
            If NewRecords(i).Index > MaxIndex Then
                ReDim Preserve InsertData(NewRecords(i).Index)
                MaxIndex = NewRecords(i).Index
            End If
            InsertData(NewRecords(i).Index) = NewRecords(i).Value
        Next

        ' INSERT̍쐬
        SqlStr = "INSERT INTO " & tablename & " VALUES ("""
        For i = 0 To MaxIndex
            SqlStr = SqlStr & InsertData(i) & ""","""
        Next i

        ' ŌɕtJ}j
        MakeSql_Insert = Left(SqlStr, Len(SqlStr) - 2) & ")"
    End Function

    ' SELECTsSQL쐬
    Public Function MakeSql_Select(ByRef tablename As String, ByRef KeyRecords As BTDBRecords2, Optional ByRef NewRecords As BTDBRecords2 = Nothing, Optional ByVal newtablename As String = "", Optional ByVal AddTablename As Boolean = True) As String
        Dim SqlStr As String
        Dim FieldNames() As String
        Dim Types() As Type
        Dim FieldCount As Short
        ReDim FieldNames(0)
        ReDim Types(0)

        ' ԂƗ񖼁Ě^̃e[u쐬
        FieldCount = CreateFieldTable(FieldNames, Types, tablename)
        If FieldCount < 0 Then
            MakeSql_Select = ""
            Exit Function
        End If

        ' L[[h̍쐬
        SqlStr = "SELECT "
        If MakeSql_MakeKeyWord(SqlStr, NewRecords, tablename, FieldCount, FieldNames) = False Then
            MakeSql_Select = ""
            Exit Function
        End If

        ' SELECTʂe[uɏoꍇ
        If newtablename <> "" Then
            SqlStr = SqlStr & " INTO " & newtablename
        End If

        ' e[uw
        SqlStr = SqlStr & " FROM " & tablename

        ' e쐬
        If MakeSql_MakeWhere(SqlStr, KeyRecords, tablename, FieldCount, FieldNames, Types, AddTablename) = False Then
            MakeSql_Select = ""
            Exit Function
        End If

        MakeSql_Select = SqlStr
    End Function

    ' SELECTsSQL쐬
    Public Function MakeSql_SelectCount(ByRef tablename As String, ByRef KeyRecords As BTDBRecords2) As String
        Dim SqlStr As String
        Dim FieldNames() As String
        Dim Types() As Type
        Dim FieldCount As Short
        ReDim FieldNames(0)
        ReDim Types(0)

        ' ԂƗ񖼁Ě^̃e[u쐬
        FieldCount = CreateFieldTable(FieldNames, Types, tablename)
        If FieldCount < 0 Then
            MakeSql_SelectCount = ""
            Exit Function
        End If

        ' e[uw
        SqlStr = "SELECT COUNT(*) FROM " & tablename

        ' e쐬
        If MakeSql_MakeWhere(SqlStr, KeyRecords, tablename, FieldCount, FieldNames, Types) = False Then
            MakeSql_SelectCount = ""
            Exit Function
        End If

        MakeSql_SelectCount = SqlStr
    End Function

    Private Function MakeSql_MakeKeyWord(ByRef SqlStr As String, ByRef NewRecords As BTDBRecords2, ByRef tablename As String, ByRef FieldCount As Short, ByRef FieldNames() As String) As Boolean
        Dim i As Integer

        ' w肳ĂȂꍇ̓L[[hƂ
        If NewRecords Is Nothing Then
            SqlStr = SqlStr & "*"
            MakeSql_MakeKeyWord = True
            Exit Function
        End If

        If NewRecords.Count = 0 Then
            SqlStr = SqlStr & "*"
            MakeSql_MakeKeyWord = True
            Exit Function
        End If

        ' NewRecordsŎw肳Ă݂̂L[[hɎw肷
        For i = 0 To NewRecords.Count - 1
            If FieldCount - 1 < NewRecords(i).Index Then
                MakeSql_MakeKeyWord = False
                Exit Function
            End If

            SqlStr = SqlStr & FieldNames(NewRecords(i).Index) & ","
        Next

        ' ŌɕtJ}j
        SqlStr = Left(SqlStr, Len(SqlStr) - 1)
        MakeSql_MakeKeyWord = True

    End Function

    Private Function MakeSql_MakeWhere(ByRef SqlStr As String, ByRef KeyRecords As BTDBRecords2, ByRef tablename As String, ByRef FieldCount As Short, ByRef FieldNames() As String, ByRef Types() As Type, Optional ByVal AddTablename As Boolean = True) As Boolean
        Dim i As Short
        Dim SqlStr2 As String
        Dim sql_operator As String
        Dim sql_value As String

        ' SQL(WHERE)̍쐬
        If KeyRecords.Count > 0 Then
            SqlStr2 = " WHERE "

            ' tB[h̎wɃe[u
            If AddTablename = True Then
                tablename = tablename + "."
            Else
                tablename = ""
            End If

            For i = 0 To KeyRecords.Count - 1

                ' ͈͊Oindexw肳ꂽꍇ̓G[
                If FieldCount - 1 < KeyRecords(i).Index Then
                    MakeSql_MakeWhere = False
                    Exit Function
                End If

                ' NULLĂƂ̑Ή
                If KeyRecords(i).Value = "" Then
                    sql_operator = " is "
                    sql_value = "NULL"
                Else
                    sql_operator = " = "
                    sql_value = KeyRecords(i).Value
                End If

                ' ̃^CvɂSQLς
                If (Types(KeyRecords(i).Index) Is System.Type.GetType("System.String")) And (Len(KeyRecords(i).Value) > 0) Then
                    SqlStr2 = SqlStr2 & tablename & FieldNames(KeyRecords(i).Index) & sql_operator & """" & sql_value & """ And "
                Else
                    SqlStr2 = SqlStr2 & tablename & FieldNames(KeyRecords(i).Index) & sql_operator & sql_value & " AND "
                End If

            Next
            ' Ōɕt(AND)j
            SqlStr = SqlStr & Left(SqlStr2, Len(SqlStr2) - 5)

        End If

        MakeSql_MakeWhere = True
    End Function

#End Region

#Region "DBs"
    Public Function Exec_insert(ByRef SqlStr As String) As Boolean
        Exec_insert = Exec_Sql(SqlStr)
    End Function

    Public Function Exec_select(ByRef SqlStr As String, ByRef NewValues As BTDBRecords2, ByRef ResultValues As BTDBRecords2) As Integer
        Try
            Dim i As Integer
            Dim dt As DataTable = GetSqlResult(SqlStr, "")
            Dim ResponseIndex As Integer

            If dt.Rows.Count = 0 Then
                Exec_select = 0
                Exit Function
            End If

            Dim record As DataRow = dt.Rows(0)
            ResultValues.Count = record.ItemArray.Length

            ' ԂɃR[hZbgɊi[Ă
            For i = 0 To record.ItemArray.Length - 1

                ' StB[hselect̑ΏۂƂȂĂ΁AIndex͏ɂ
                If NewValues.Count = 0 Then
                    ResponseIndex = i
                Else
                    ResponseIndex = NewValues.Item(i).Index
                End If

                If record.ItemArray(i).GetType Is GetType(DBNull) Then
                    ResultValues(i).Index = ResponseIndex
                    ResultValues(i).Value = ""
                Else
                    ResultValues(i).Index = ResponseIndex
                    ResultValues(i).Value = CStr(record.ItemArray(i))
                End If
            Next i

            Exec_select = dt.Rows.Count
        Catch ex As Exception
            Exec_select = -1
        End Try
    End Function

    Public Function Exec_selectcount(ByRef SqlStr As String) As Integer
        Try
            Dim cmd As New OleDbCommand(SqlStr, cnt)
            Exec_selectcount = CInt(cmd.ExecuteScalar())
        Catch ex As Exception
            Exec_selectcount = -1
        End Try
    End Function

    Public Function Exec_selectintofile(ByRef SqlStr As String, ByRef Ip As String, ByRef ResultValues As BTDBRecords2) As Integer
        Dim i As Integer
        Dim Filename As String
        Dim FileFree As Integer
        Dim WriteStr As String

        Filename = CurDir() & "\" & "DL_" & Ip & ".txt"
        FileFree = FreeFile()
        ' SELECT̎s
        Dim dt As DataTable = GetSqlResult(SqlStr, "")

        Try
            Try
                Kill(Filename)
            Catch ex As Exception
            End Try
            FileOpen(FileFree, Filename, OpenMode.Binary, OpenAccess.Write, OpenShare.LockReadWrite)

            For Each record As DataRow In dt.Rows
                ' ԂɃR[hZbgɊi[Ă
                For i = 0 To record.ItemArray.Length - 1
                    If record.ItemArray(i).GetType Is GetType(DBNull) Then
                        WriteStr = ""
                    Else
                        WriteStr = CStr(record.ItemArray(i))
                    End If

                    FilePut(FileFree, WriteStr, LOF(FileFree) + 1)
                    FilePut(FileFree, ",", LOF(FileFree) + 1)
                Next i
                FilePut(FileFree, vbCrLf, LOF(FileFree))
            Next            ' ԂɃR[hZbgɊi[Ă

            Exec_selectintofile = dt.Rows.Count
        Catch ex As Exception
            Exec_selectintofile = -1
        Finally
            FileClose(FileFree)
        End Try
    End Function

    Public Function Exec_delete(ByRef SqlStr As String, ByVal tablename As String) As Integer
        Dim dt As DataTable = GetSqlResult(SqlStr, tablename)
        Dim oOleAdap As New OleDbDataAdapter
        Exec_delete = dt.Rows.Count
        Try
            ' oΏۂ݂΁AJ[\̂郌R[h폜
            If dt.Rows.Count() = 0 Then
                Exec_delete = 0
            Else
                dt.Rows(0).Delete()
                oOleAdap.DeleteCommand = CreateDeleteCommand(dt, True)
                oOleAdap.Update(dt)
                'Exec_delete = oOleAdap.Update(dt)
            End If

        Catch e As Exception
            Try
                oOleAdap.DeleteCommand = CreateDeleteCommand(dt, False)
                oOleAdap.Update(dt)
                'Exec_delete = oOleAdap.Update(dt)
            Catch ee As Exception
                Exec_delete = -1
            End Try
        End Try
    End Function

    Public Function Exec_update(ByRef SqlStr As String, ByRef NewValues As BTDBRecords2, ByVal tablename As String) As Integer
        Dim dt As DataTable = GetSqlResult(SqlStr, tablename)
        Dim oOleAdap As New OleDbDataAdapter
        Dim i As Integer

        Try
            ' oΏۂ݂΁AJ[\̂郌R[h폜
            If dt.Rows.Count() = 0 Then
                Exec_update = 0
            Else
                For i = 0 To NewValues.Count - 1
                    If NewValues(i).Index >= dt.Columns.Count Then
                        Exec_update = 0
                        dt.Reset()
                        Exit Function
                    End If

                    If dt.Columns(NewValues(i).Index).DataType Is System.Type.GetType("System.String") Then
                        ' ^
                        dt.Rows(0).Item(NewValues(i).Index) = NewValues(i).Value
                    Else
                        ' l^Ƃď
                        ' l̍쐬
                        ' =
                        If NewValues(i).Operation = 0 Then
                            dt.Rows(0).Item(NewValues(i).Index) = NewValues(i).Value
                            ' +=
                        ElseIf NewValues(i).Operation = 7 Then
                            dt.Rows(0).Item(NewValues(i).Index) = dt.Rows(0).Item(NewValues(i).Index) + CInt(NewValues(i).Value)
                            ' -=
                        ElseIf NewValues(i).Operation = 9 Then
                            dt.Rows(0).Item(NewValues(i).Index) = dt.Rows(0).Item(NewValues(i).Index) - CInt(NewValues(i).Value)
                        End If
                    End If
                Next
                Try
                    oOleAdap.UpdateCommand = CreateUpdateCommand(dt, True)
                    Exec_update = oOleAdap.Update(dt)
                Catch ee As Exception
                    oOleAdap.UpdateCommand = CreateUpdateCommand(dt, False)
                    Exec_update = oOleAdap.Update(dt)
                End Try
            End If
        Catch e As Exception
            Exec_update = -1
        End Try
    End Function

    Public Function Exec_Extract(ByRef SqlStr As String, ByRef tablename As String, ByRef Ip As String) As Integer
        Dim SqlStr2 As String
        Dim ipStrArr(4) As String
        Dim ipNumArr(4) As Short
        Dim i As Object

        ' Ŏ󂯎SQLWHEREȍ~݂̂𒊏o
        ' ȑOgpwf[^̍폜
        SqlStr2 = "DROP TABLE "
        SqlStr2 = SqlStr2 & tablename
        SqlStr2 = SqlStr2 & "_"
        SqlStr2 = SqlStr2 & Ip
        Exec_Sql(SqlStr2)

        ' o̎s
        If Exec_Sql(SqlStr) = False Then
            Exec_Extract = -1
            Exit Function
        End If

        ' F}X^f[^̏(}X^݂̏svȏꍇ̓RgAEgĂ)
        SqlStr2 = "DELETE FROM "
        SqlStr2 = SqlStr2 & tablename

        ' opSQL璊o𔲂o
        For i = 1 To Len(SqlStr) - 5
            If Mid(SqlStr, i, 5) = "WHERE" Then
                SqlStr2 = SqlStr2 & " " & Right(SqlStr, Len(SqlStr) - i + 1)
            End If
        Next i

        If Exec_Sql(SqlStr2) = False Then
            Exec_Extract = -1
            Exit Function
        End If
        ' F}X^f[^݂̏͂܂łł


        ' wf[^̌擾
        SqlStr2 = "SELECT COUNT(*) FROM "
        SqlStr2 = SqlStr2 & tablename
        SqlStr2 = SqlStr2 & "_"
        SqlStr2 = SqlStr2 & Ip

        ' oԂ
        Exec_Extract = Exec_selectcount(SqlStr2)
    End Function

    Public Function Exec_DropExtract(ByRef Ip As String) As Integer
        Dim SqlStr As String
        Dim i As Short

        UpdateTableName()
        For i = 0 To GetTableCount() - 1
            If Right(GetTableName(i), 12) = Ip Then

                ' Fwf[^}X^f[^ɕ(}X^݂̏svȏꍇ̓RgAEgĂ)
                SqlStr = "INSERT INTO "
                SqlStr = SqlStr & Left(GetTableName(i), Len(GetTableName(i)) - 13)
                SqlStr = SqlStr & " SELECT * FROM "
                SqlStr = SqlStr + GetTableName(i)

                If Exec_Sql(SqlStr) = False Then
                    Exec_DropExtract = -1
                    Exit Function
                End If
                ' Fwf[^͂̕܂łł

                ' wf[^̍폜
                SqlStr = "DROP TABLE "
                SqlStr = SqlStr + GetTableName(i)

                If Exec_Sql(SqlStr) = False Then
                    Exec_DropExtract = -1
                    Exit Function
                End If
            End If
        Next i

        Exec_DropExtract = i

    End Function

    Public Sub Update(ByVal dt As DataTable)

        If IsNothing(dt) Then
            Exit Sub
        End If

        Dim oOleAdap As New OleDbDataAdapter("SELECT * FROM " & dt.TableName, cnt)
        Try
            'e[uɎL[Kݒ肳Ă̂ł΁AL1sŏ[ł
            'Dim cb As New OleDb.OleDbCommandBuilder(oOleAdap)

            'eR}ho^܂
            oOleAdap.DeleteCommand = CreateDeleteCommand(dt, True)
            oOleAdap.UpdateCommand = CreateUpdateCommand(dt, True)
            oOleAdap.InsertCommand = CreateInsertCommand(dt)
            oOleAdap.Update(dt)
        Catch ex As Exception
            Try
                oOleAdap.DeleteCommand = CreateDeleteCommand(dt, False)
                oOleAdap.UpdateCommand = CreateUpdateCommand(dt, False)
                oOleAdap.InsertCommand = CreateInsertCommand(dt)
                oOleAdap.Update(dt)
            Catch ee As Exception
                MsgBox("XVs" & vbCrLf & ex.ToString)
            End Try
        End Try
    End Sub

#End Region

End Class
