Imports btnaviReqHandler
Imports System.Threading

Public Class ThreadControl
    Private mainForm_ As MainForm
    Private reqQueue_ As ArrayList
    Private thread_ As Thread
    Private waitObj_ As AutoResetEvent
    Private runFlg_ As Boolean

    Public Sub New(ByRef mainFm As MainForm)
        mainForm_ = mainFm
        reqQueue_ = New ArrayList
        thread_ = New Thread(New ThreadStart(AddressOf Me.ThreadMain))
        waitObj_ = New AutoResetEvent(False)
        runFlg_ = True
        thread_.IsBackground = True
        thread_.Start()
    End Sub

    Public Sub Quit()
        runFlg_ = False
        waitObj_.Set()
        thread_.Join()
    End Sub

    <CLSCompliant(False)> _
    Public Sub AddRequest(ByVal ip As String, ByVal seq As UInt32, ByRef handy As BTHandy2)
        Dim req As New Request(ip, seq, handy, mainForm_)
        Dim syncQueue_ As ArrayList = ArrayList.Synchronized(reqQueue_)
        syncQueue_.Add(req)
        waitObj_.Set()
    End Sub

    <CLSCompliant(False)> _
    Public Sub AddResult(ByVal ip As String, ByVal seq As UInt32, ByVal result As String)
        'KvɉăJX^}CYĂ
    End Sub

    <CLSCompliant(False)> _
    Public Sub Cancel(ByVal ip As String, ByVal seq As UInt32)
        Dim req As Request
        SyncLock reqQueue_.SyncRoot
            For Each req In reqQueue_
                If req.Ip = ip And req.SeqNo.Equals(seq) Then
                    reqQueue_.Remove(seq)
                    Exit For
                End If
            Next
        End SyncLock
    End Sub


    Private Sub ThreadMain()
        Dim req As Request
        While runFlg_
            If reqQueue_.Count > 0 Then

                SyncLock reqQueue_.SyncRoot
                    Try
                        req = reqQueue_(0)
                        reqQueue_.RemoveAt(0)
                    Catch
                        Continue While
                    End Try
                End SyncLock

                mainForm_.UpdateStatusDlg(req.Ip, True)
                req.DoAction()
                mainForm_.UpdateStatusDlg(req.Ip, False)
            End If

            waitObj_.WaitOne(10000, False)
        End While
    End Sub
End Class


