package cls.com.ils.biz.component
{
	import cls.com.ils.biz.ctrl.SyncCtrl;
	import cls.com.ils.biz.model.SharedDataModel;
	import cls.com.ils.biz.utility.logging.AppLoggingTool;
	import cls.com.ils.common.component.IlsTextInput;
	import cls.com.ils.common.ctrl.ISharedSearch;
	
	import flash.events.Event;
	import flash.events.FocusEvent;
	
	import mx.events.ValidationResultEvent;

	public class TsAbstructTextInput extends IlsTextInput implements ISharedSearch
	{
		//変更フラグ
		private var _isModify:Boolean;

		[Bindable]
		public var dataModel:SharedDataModel = new SharedDataModel;

		private var _dataCtrl:SyncCtrl;
		
		private var _resultEvent:ValidationResultEvent;
		private var _results:Array = [];
		
		public function TsAbstructTextInput()
		{
			super();
			addEventListener(Event.CHANGE,onChangeHandler);
			addEventListener(FocusEvent.FOCUS_IN,onFocusInHandler);
		}

		public function get isModify():Boolean
		{
			return _isModify;
		}
		
		public function set isModify(value:Boolean):void
		{
			_isModify = value;
		}
		
		public function get dataCtrl():SyncCtrl
		{
			return _dataCtrl;
		}
		
		public function set dataCtrl(value:SyncCtrl):void
		{
			_dataCtrl = value;
		}

// レスポンスへの対応：共通エラー
		/**
		 * レスポンスでタイムアウトレスポンス取得時エラー
		 * <p>処理でレスポンス（タイムアウト）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getTimeOutResponse(cd:String, message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2}",this.name,"getTimeOutResponse",cd);
		}

		/**
		 * レスポンスでジョブNo不正エラー
		 * <p>処理でレスポンス（不正ジョブによる発行）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getJobErrResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getJobErrResponse",cd,message);
		}

		/**
		 * システム・エラー(予期せぬエラー)レスポンス取得メソッド
		 * <p>レスポンス（システム・エラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getSystemErrResponse(cd:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSystemErrResponse",cd);
		}

// レスポンスへの対応：検索処理時レスポンス処理
				
		/**
		 * 検索処理時OKレスポンス取得メソッド
		 * <p>検索処理でレスポンス（OK）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getSrchOkResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchOkResponse",cd,message);
			// なにもしない
			// システム全体として更新メッセージを表示する場合、ここに記述する。
			// 個別にメッセージを表示する場合、派生クラスで定義する。
			if(isTranslation){
				//翻訳結果を表示
				translationTarget.text = dataModel.resXml.data.item.name;
				transRet = true;				
			}						
		}
		
		/**
		 * 検索処理時OK(メッセージ付き)レスポンス取得メソッド
		 * <p>検索処理でレスポンス（OK(メッセージ付き)）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getSrchOkMsgResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchOkMsgResponse",cd,message);
		}
		
		/**
		 * 検索処理時警告レスポンス取得メソッド
		 * <p>検索処理でレスポンス（警告）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getSrchAlertResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchAlertResponse",cd,message);
		}
		
		/**
		 * 検索処理時検索結果なしレスポンス取得メソッド
		 * <p>検索処理でレスポンス（データなし）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getSrchNoDataResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchNoDataResponse",cd,message);
		}
		

		/**
		 * 検索処理時検索結果項目エラー(文字桁、存在チェックなど１項目レベル
		 * のエラーが発生した場合の)レスポンス取得メソッド
		 * <p>検索処理でレスポンス（項目レベルエラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getSrchItemErrResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchItemErrResponse",cd,message);
			if(isTranslation){
				translationTarget.text = "";
			}						
		}
		
		/**
		 * 検索処理時検索結果業務エラーレスポンス取得メソッド
		 * <p>検索処理でレスポンス（業務エラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 */		          
		public function getSrchAppErrResponse(cd:String,message:String,kbn:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchAppErrResponse",cd,message);
		}
		
// 共通イベントメソッド定義（型を定義します）。
		/**
		 * 共通初期化処理用抽象メソッド
		 * 中身は各画面でこのメソッドをOverrideして
		 * 動作を定義して下さい。
		 * 
		 */		
		public function onCreationComplete():void{}

		/**
		 * ログオフ処理
		 * ログオフ昨日は親画面のログオフメソッドを起動してから、
		 * 自分自身を閉じる。
		 */	
		public function logoff():void{}
		
		/**
		 * ビジー状態にする 
		 * @param state true:ビジー false:非ビジー
		 * 
		 */		
		public function setBusyCursor(state:Boolean):void{}

		override public function readDataSet():Boolean
		{
			if(isModify){
				isModify = false;	//値が変更された場合に1度だけチェックする
				if(this.text == ""){
					translationTarget.text = "";
					transRet = true;
				}else{
					//翻訳処理						
					transRet = false;
					_dataCtrl = new SyncCtrl(String(translationLookUp));
					_dataCtrl.target = this;
					dataModel.initParam();
					dataModel.addParam("0"); //翻訳パラメータ
					dataModel.addParam(text);
					_dataCtrl.searchCtrl(dataModel)
				}
			}			
			return transRet;
		}

//		override public function validationResultHandler(event:ValidationResultEvent):void
//		{
//			if(event.type == ValidationResultEvent.VALID){
//				isModify = false;
//			}else{
////				isModify = true;
//			}
//			super.validationResultHandler(event);
//		}
		
		private function onChangeHandler(event:Event):void
		{
			_isModify = true;
		}
		
	    private function onFocusInHandler(event:FocusEvent):void
	    {
			_isModify = false;
	    }
		
	}
}