package cls.com.ils.biz.ctrl
{
	import cls.com.ils.biz.model.SharedDataModel;
	import cls.com.ils.biz.model.enum.ResponseKbn;
	import cls.com.ils.biz.utility.logging.AppLoggingTool;
	import cls.com.ils.biz.utility.net.SyncRequest;
	
	public class SyncCtrl
	{
		
// プロパティ領域		

		/**
		 * 呼出した画面の参照 
		 */		
		protected var _target:Object;

		/**
		 *　公開プログラムID 
		 * ここに格納されているMagic公開プログラムIDを
		 * 利用して、サーバーサイドプログラムを実行します。
		 */		
		protected var _prgramId:String;
		
		/**
		 * データモデル 
		 */		
		protected var _model:SharedDataModel;

		/**
		 * Ajax 
		 */
		protected var _service:SyncRequest;
		
		/**
		 * ＯＫレスポン時実行関数
		 */
		protected var _okFnction:Function;
		
// コンストラクタ領域

		/**
		 * コンストラクタ 
		 * @param prgramId 公開プログラムID
		 * 
		 */		
		public function SyncCtrl(prgramId:String)
		{
			// 公開プログラムIDの取得
			_prgramId = prgramId;

			// Ajaxの生成
			_service = new SyncRequest();

		}

		public function set target(value:Object):void{
			_target = value;
		}
		
		public function get target():Object{
			return _target;			
		}
			
// パブリックメソッド
		/**
		 * 検索処理 
		 * @param object データモデル
		 * 
		 */		
		public function searchCtrl(model:Object):void{
			
			// データモデルを設定する
			setDataModel(model);
			// データの送信準備
			setSendInfo();			
			// データの送信処理
			send();
		}

		/**
		 * サーバーサイドへ追加パラメータを利用する場合、
		 * 継承クラスでこのメソッドをオーバーライドして実装して下さい。
		 * 実装は、_service.addParam を利用して下さい。
		 * 
		 */		
		protected function addSpecialParam():void{
			/* implement method */			
		}

// レスポンス受信イベント
		/**
		 * HttpReuquest成功時実行メソッド 
		 * 取得時挙動を変更する場合、このメソッドをオーバーライドして
		 * 実装します。
		 * ※SharedRegist,SharedRun,SharedSearch,ComboboxCtrlは
		 * このメソッドをオーバーライドして実装している
		 * @param event イベント情報
		 * 
		 */				
		protected function httpResult(response:XML):void {
			
			// JOBNOを設定する
			setJobNo(String(response.kekka.jobno));
			
			// レスポンス区分にあわして画面を制御する
			switch(String(response.kekka.kbn)){
				case ResponseKbn.OK:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(response);
					// 正常
					getOkResponse(new XML(response.kekka));
					break;
				case ResponseKbn.OK_ALERT:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(response);
					// 正常（メッセージ付き）
					break;
				case ResponseKbn.OK_ALERT:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(response);
					// 警告
					break;
				case ResponseKbn.ERR_COM_JOB:
					// ジョブＮｏエラーは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない
				
					// 不正ジョブNo
					getErrJobResponse(new XML(response.kekka));
					break;
				case ResponseKbn.ERR_COM_TIMEOUT:
					// タイムアウトは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない

					// タイムアウト
					getErrTimeoutResponse(new XML(response.kekka));
					break;
				case ResponseKbn.ERR_COM_SYSTEM:
					// システムエラーは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない

					// システムエラー
					getErrSsytem();
					break;
				case ResponseKbn.ERR_COM_ITEM:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクするとデータモデルが初期化されてしまうので問題あり
				
					// 項目エラー
					gerErrItem(new XML(response.kekka));
					break;
				case ResponseKbn.ERR_SRCH_NO_DATA:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない。再検索する必要があるため

					// データなし
					getErrNoData(new XML(response.kekka));
					break;
				case ResponseKbn.ERR_REGI_HAITA:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない。

					// 排他エラー
					getErrHaita(new XML(response.kekka));
					break;
				default:
				
					if(String(response.kekka.kbn).substr(0,1) == String(ResponseKbn.ERR_SRCH_NO_DATA).substr(0,1) ){
						// 頭一桁が検索系（Ｓ）の場合、データなし処理を実施する
						getErrNoData(new XML(response.kekka));
					}else{
						// 業務エラー
						// 業務エラー、このあとモデルを利用しない、
						// そのためデータ情報をモデルにリンクさせない。
						// リンクするとデータモデルが初期化されてしまうので問題あり
						
						getErrAppLogic(new XML(response.kekka));
					}
				

					break;
			}
						
		}

		/**
		 * ジョブＮｏ格納用メソッド 
		 * @param jobNo
		 * 
		 */		
		protected function setJobNo(jobNo:String):void{
			// ジョブＮｏへの格納は各機能のsetJobNoで実施する。
			// overrideの利用
		}

		/**
		 * HttpReuquest失敗時実行メソッド 
		 * 失敗時挙動を変更する場合、このメソッドをオーバーライドして
		 * 実装します。
		 * @param event イベント情報
		 * 
		 */				
		protected function httpFault():void {
			
			AppLoggingTool.logger.warn("取得できませんでした。");
			getErrSsytem();
				
		}

// 結果対応メソッド
// リクエスト結果への対応メソッド

		/**
		 * リクエストがOKのときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		protected function getOkResponse(pxml:XML):void{ 
			_target.getSrchOkResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}

		/**
		 * リクエストがOK(msg付き)のときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		protected function getOKMsgResponse(pxml:XML):void{ 
			_target.getSrchOkMsgResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}
		
		/**
		 * リクエストが警告のときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		protected function getAlertResponse(pxml:XML):void{ 
			_target.getSrchAlertResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}		
		
		/**
		 * 項目レベルエラーのときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchItemErrResponseをオーバーライドして定義すること。
 		 * @param pxml
		 * 
		 */		
		protected function gerErrItem(pxml:XML):void{
			_target.getSrchItemErrResponse(pxml.cd,pxml.message);
		}
		
		
		/**
		 * 検索結果なしのときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchNoDataResponseをオーバーライドして定義すること。
  		 * @param pxml
		 * 
		 */
		protected function getErrNoData(pxml:XML):void{
			_target.getSrchNoDataResponse(pxml.cd,pxml.message);	
		}

		/**
		 * 排他発生時エラー 
		 * @param pxml
		 * 
		 */		
		protected function getErrHaita(pxml:XML):void{}
		
		/**
		 * 検索時業務エラー発生のときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchAppErrResponseをオーバーライドして定義すること。
  		 * @param pxml
		 * 
		 */	
		protected function getErrAppLogic(pxml:XML):void{
			_target.getSrchAppErrResponse(pxml.cd,pxml.message,pxml.kbn);	
		}

		/**
		 * NG(ジョブNO)レスポンス
		 * @param pxml
		 * 
		 */		
		protected function getErrJobResponse(pxml:XML):void{
			// todo ジョブNo不正時の共通処理を定義する
			_target.getJobErrResponse(pxml.cd,pxml.message);
		}
		
		/**
		 *タイムアウトレスポンス 
		 * 
		 */		
		protected function getErrTimeoutResponse(pxml:XML):void{
			_target.getTimeOutResponse(pxml.cd,pxml.message);
		}
		
		/**
		 * システムエラー
		 * 
		 */		
		protected function getErrSsytem():void{
			_target.getSystemErrResponse("Z8");
		}

// final protectedメソッド領域
		
		/**
		 * ViewとCtrlの共通データリポジトリとなる
		 * データモデルのリンクを設定します。
		 * @param object データモデル
		 * 
		 */
		final protected  function setDataModel(model:Object):void{
			_model = model as SharedDataModel;
		}
		
		/**
		 * 送信情報の設定用抽象メソッド
		 * パラメータ、公開プログラムID、リクエスト用のオブジェクトの生成などを行う。
		 * 取得成功メソッド、失敗メソッドのアタッチを行う。 
		 * 
		 */
		final protected  function setSendInfo():void{

//			AppLoggingTool.logger.debug("通信設定開始");
			
			// パラメータの追加処理
			setParam();
			
		}

		/**
		 * パラメータ設定用メソッド 
		 * 
		 */	
		protected  function setParam():void{
	
			// 公開プログラム名を指定
			_service.prgname = _prgramId;
			// デフォルト用引数を設定
			if(_model.arg.length != 0){
				for(var roopIndex:int = 0;roopIndex<_model.arg.length;roopIndex++){
					_service.addParam(_model.arg[roopIndex] as String);					
				}
			}
			// 個別パラメータ追加メソッドの呼出し			
			addSpecialParam();		
		}
		
		/**
		 * 送信処理用抽象クラス 
		 * 
		 */			
		final protected function send():void{
			// データ情報をモデルにリンクさせる
			var response:XML;
			
			response = _service.sendRequest();
			
			if(response){
				httpResult(response);
			}else{
				httpFault();
			}
		}

	}
}