package cls.com.ils.biz.ctrl
{
	import cls.com.ils.common.model.MsgMgr;
	import cls.com.ils.biz.model.SharedPlace;
	import cls.com.ils.biz.model.enum.ActionMode;
	import cls.com.ils.biz.model.enum.FlgKbn;
	import cls.com.ils.biz.model.enum.RegiMode;
	import cls.com.ils.biz.model.enum.ResponseKbn;
	import cls.com.ils.biz.utility.logging.AppLoggingTool;
	
	import mx.controls.Alert;
	import mx.events.CloseEvent;
	import mx.rpc.events.ResultEvent;
	
	/**
	 * 共通登録コントローラ 
	 * @author furoi
	 * 
	 */	
	public class TsSharedRegist extends TsSharedCtrl
	{
	
		/**
		 * 確認メッセージ表示コントロール用 
		 */		
		protected var _dispQuestionMsgForAppCtrl:Boolean = true;
		
	
// コンストラクタ
		public function TsSharedRegist(prgramId:String,callScreen:Object)
		{
			//TODO: implement function
			super(prgramId);
			
			_target = callScreen;
			
			// 公開プログラム名を指定
			_service.prgname = _prgramId;
			// デフォルト用引数を設定
			// 更新モードを設定
			if(_target.actionMode == ActionMode.DEL){
				// 取消の場合　処理区分に取消マークを付ける
				_service.addParam(RegiMode.DEL);
			}else if(_target.actionMode == ActionMode.INS || _target.actionMode == ActionMode.COPY){
				// 新規、複写の場合　処理区分に新規マークを付ける
				_service.addParam(RegiMode.INS);
			}else{
				// その他の場合　処理区分に登録マークを付ける
				// 修正の場合、一覧で新規追加と、更新が混じる場合がある
				// そのため、動作区分があいまいなためその他で登録マークを付ける
				_service.addParam(RegiMode.REGI);
			}
			
		}
		
// パブリックメソッド
		/**
		 * 更新処理 
		 * @param model データモデル
		 * 
		 */		
		public function registCtrl(model:Object):void{

			// データモデルを設定する
			setDataModel(model);	

			// 更新確認対象の場合確認メッセージを表示する。
			if(_dispQuestionMsgForAppCtrl == true && SharedPlace.updQuestion == FlgKbn.ON){
				
				var dispMsgCd:String;
				
				switch(_target.actionMode){
					case ActionMode.INS:
						dispMsgCd = "Q002";
						break;
					case ActionMode.DEL:
						dispMsgCd = "Q004";
						break;					
					default:
						dispMsgCd = "Q003";
						break;									
				}
				
				MsgMgr.dispMsgAndCallEvent(dispMsgCd,_target.title,Alert.YES | Alert.NO,runCtrl);

			}else{
				this.runCore();
			}
		}
		
		/**
		 *　選択確認　返答で処理を変更する 
		 * @param event
		 * 
		 */		
		public function runCtrl(event:CloseEvent):void{
			if (event.detail == Alert.NO) {
				//処理しない 
				_target.btnInit(true);	
        	}else{
        		this.runCore();
        	}
		}
		
		/**
		 * 実行実処理 
		 * 
		 */		
		public function runCore():void{
			if (SharedPlace.DEMO_LOGIN == FlgKbn.OFF) {
				// カーソルを設定 
				_target.setBusyCursor(true);
	
				//AppLoggingTool.logger.warn("registCtrl({0})",model.toString());
			
				// データの送信準備
				setSendInfo();
				// データの送信処理
				send();
			}else{
				MsgMgr.dispMsgAndCallEvent("W007",_target.title,Alert.YES,runCtrlDemo);
			}
		}
		
		public function runCtrlDemo(event:CloseEvent):void{
			if (event.detail == Alert.NO) {
				//処理しない 
        	}else{
        		getOkResponse(new XML(""));
        	}
		}
		
		/**
		 * 条件パラメータの追加メソッド 
		 * 
		 */		
		public function addRegiConditionParam(param:String):void{
			_service.addParam(param);
		}
		
		/**
		 * パラメータ設定用メソッド 
		 * 
		 */	
		override protected  function setParam():void{

			// データモデルを設定
			// XMLからkekkaを削除
			delete _model.resXml.kekka;
			// データモデルをパラメータとして設定
			_service.addParam(_model.resXml.data.toXMLString());					
			// 個別パラメータ追加メソッドの呼出し
			addSpecialParam();
		}
		/**
		 * ジョブＮｏを共通領域に設定する 
		 * @param jobNo
		 * 
		 */		
		override protected function setJobNo(jobNo:String):void{
			SharedPlace.jobNo = String(jobNo);
		}


		/**
		 * アプリケーションで確認メッセージの通知を制御する
		 * ※システム設定での設定を無視してメッセージを表示しないときに利用する
		 * 表示する場合は、システム設定の内容によって表示非表示を判断する
		 * 各アプリケーションで専用のメッセージを表示したい場合に利用する 
		 * @param flg True:システム設定の制御通り Flase:常に表示しない
		 * 
		 */
		public function set dispQuestionMsgForAppCtrl(flg:Boolean):void{
			_dispQuestionMsgForAppCtrl = flg;
		}
		

// リクエストへの振り分け処理
// オーバーライドする。
		
		/**
		 * HttpReuquest成功時実行メソッド 
		 * 取得時挙動を変更する場合、このメソッドをオーバーライドして
		 * 実装します。
		 * @param event イベント情報
		 * 
		 */				
		override protected function httpResult(event:ResultEvent):void {
			
			AppLoggingTool.logger.debug("取得成功しました：{0}",String(event.result.kekka.kbn));
			
			// JOBNOを設定する
			setJobNo(String(event.result.kekka.jobno));
			
			// レスポンス区分にあわして画面を制御する
			switch(String(event.result.kekka.kbn)){
				case ResponseKbn.OK:
					_model.resXml = new XML(event.result);
					// 正常
					getOkResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.OK_ALERT:

					// 正常（メッセージ付き）
					getOKMsgResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.OK_ALERT:
					// データ情報をモデルにリンクさせる
					getAlertResponse(new XML(event.result.kekka));
					// 警告
					break;
				case ResponseKbn.ERR_COM_JOB:
					// 不正ジョブNo
					getErrJobResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_COM_TIMEOUT:
					// タイムアウト
					getErrTimeoutResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_COM_SYSTEM:
					// システムエラー
					getErrSsytem();
					break;
				case ResponseKbn.ERR_COM_ITEM:
					// 項目エラー
					gerErrItem(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_SRCH_NO_DATA:
					// データなし
					getErrNoData(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_REGI_HAITA:
					// 排他エラー
					getErrHaita(new XML(event.result.kekka));
					break;
				default:
				
					if(String(event.result.kekka.kbn).substr(0,1) == String(ResponseKbn.ERR_SRCH_NO_DATA).substr(0,1) ){
						// 頭一桁が検索系（Ｓ）の場合、データなし処理を実施する
						getErrNoData(new XML(event.result.kekka));
					}else{
						// 業務エラー
						getErrAppLogic(new XML(event.result.kekka));	
					}
				
					break;
			}
						
		}

// リクエスト結果への対応メソッド

		/**
		 * リクエストがOKのときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		override protected function getOkResponse(pxml:XML):void{ 
			_target.getRegiOkResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}
		
		/**
		 * リクエストがOK(msg付き)のときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		override protected function getOKMsgResponse(pxml:XML):void{ 
			_target.getRegiOkMsgResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}
		
		/**
		 * リクエストが警告のときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		override protected function getAlertResponse(pxml:XML):void{ 
			_target.getRegiAlertResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}
		
		/**
		 * 項目レベルエラーのときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchItemErrResponseをオーバーライドして定義すること。
 		 * @param pxml
		 * 
		 */		
		override protected function gerErrItem(pxml:XML):void{
			_target.getRegiItemErrResponse(pxml.cd,pxml.message);
		}
		
		/**
		 * 排他エラーのときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetRegiHaitaResponseをオーバーライドして定義すること。
		 * @param pxml
		 * 
		 */		
		override protected function getErrHaita(pxml:XML):void{
			_target.getRegiHaitaResponse(pxml.cd,pxml.message);
		}
		
		/**
		 * 更新時業務エラー発生のときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetRegiAppErrResponseをオーバーライドして定義すること。
  		 * @param pxml
		 * 
		 */	
		override protected function getErrAppLogic(pxml:XML):void{
			_target.getRegiAppErrResponse(pxml.cd,pxml.message,pxml.kbn);				
		}
		
	}
}