package cls.com.ils.biz.model
{
	/**
	 * eShift用共通データモデルです。
	 * カスタマイズしてデータモデルを作成する場合、このクラスを
	 * 継承して作成して下さい。 
	 * @author furoi
	 * 
	 */	
	public class SharedDataModel
	{
		
        /**
         *　結果格納用のデータモデル 
         */		
        [Bindable]
        public var resXml:XML;
		
        /**
         *　パラメータ用データモデル
         */				
		[Bindable]
        public var arg:Array;
		
		/**
		 * 検索用パラメータの追加
		 * @param param 
		 * 
		 */		
		public function addParam(param:String):void{
			
			if(arg == null){
				this.arg = new Array();
			}
			
			arg[arg.length] = param;
		}
		
		/**
		 * 検索用パラメータの初期化 
		 * 
		 */		
		public function initParam():void{
			arg = null;

			//同一モデルを使用し、再検索を行った際に、前回値と値が変更されていない場合、
			//設定項目に値がバインドされない為に追加
			resXml = null;
		}
		
		/**
		 *コンストラクタ 
		 * 
		 */		
		public function SharedDataModel()
		{
			this.arg = new Array();
			//TODO: implement function
			
		}
	}
}