package cls.com.ils.common.component
{
	import flash.events.Event;
	import flash.events.FocusEvent;
	import flash.events.MouseEvent;
	
	import mx.controls.DateField;
	import mx.events.ValidationResultEvent;
	import mx.validators.Validator;

	public class IlsDateField extends DateField implements IIlsControl
	{

		//変更フラグ
		private var _isModify:Boolean;
		private var _validator:Validator;

		public function IlsDateField()
		{
			//TODO: implement function
			super();
            addEventListener(FocusEvent.KEY_FOCUS_CHANGE, keyFocusChangeHandler);
            addEventListener(FocusEvent.MOUSE_FOCUS_CHANGE, mouseFocusChangeHandler);
            addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);

			addEventListener(Event.CHANGE,onChangeHandler);
			addEventListener(FocusEvent.FOCUS_IN,onFocusInHandler);
		}
		
		/**
		 *  項目を初期化する
		 * 
		 */		
		public function clearMe():void
		{
			this.text = "";
			this.errorString = "";
		}
		
		/**
		 *  コントロールを入力不可にする
		 * @param isLock　True:ロックする、False:ロック解除
		 * 
		 */		
		public function lock(isLock:Boolean):void
		{
			this.enabled = !isLock;
		}

//		public function get isModify():Boolean
//		{
//			return _isModify;
//		}
//		
//		public function set isModify(value:Boolean):void
//		{
//			_isModify = value;
//		}

	    private function keyFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }

	    private function mouseFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }

	    private function mouseDownHandler(event:MouseEvent):void
	    {
			event.stopPropagation();    	
	    }

		private function onChangeHandler(event:Event):void
		{
			_isModify = true;
		}
		
	    private function onFocusInHandler(event:FocusEvent):void
	    {
			_isModify = false;
	    }

		public function get validator():Validator
		{
			return _validator;
		}
		
		public function set validator(value:Validator):void
		{
			_validator = value;
		}
		
	}
}