package cls.com.ils.common.ctrl
{
	/**
	 * SharedCtrl 利用クラス用インタフェース 
	 * @author furoi
	 * 
	 */	
	public interface ISharedCtrl
	{
		
		/**
		 *  タイムアウト時処理用抽象メソッド
		 * @param cd　メッセエージコード
		 * 
		 */		
		function getTimeOutResponse(cd : String, message : String) : void;
		
		/**
		 * ジョブNoエラーレスポンス用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getJobErrResponse(cd : String, message : String) : void;
		
		/**
		 * システムエラー時用抽象メソッド 
		 * @param cd
		 * 
		 */		
		function getSystemErrResponse(cd : String) : void;
		
// 共通イベント用メソッド
		
		/**
		 * 画面初期化処理用抽象メソッド
		 * 
		 */		
		function onCreationComplete():void;
		
		/**
		 * ログオフ処理用抽象メソッド 
		 * 
		 */		
		function logoff():void;
		
		function setBusyCursor(state:Boolean):void;
	}
}