package cls.com.ils.common.ctrl
{
	/**
	 * 実行コントロール利用クラス用インタフェース 
	 * @author furoi
	 * 
	 */	
	public interface ISharedRun extends ISharedCtrl
	{
		/**
		 * 実行結果OK用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */	
		function getRunOkResponse(cd:String, message:String):void;
		
		/**
		 * 実行結果OK（MSG付き）用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRunOkMsgResponse(cd:String, message:String):void;
		
		/**
		 * 実行結果OK（警告MSG付き）用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRunAlertResponse(cd:String, message:String):void;
				
		/**
		 * 実行時項目レベル（単純）エラー用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRunItemErrResponse(cd:String, message:String):void;
		
		/**
		 * 実行業務エラー処理用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRunAppErrResponse(cd:String, message:String, kbn : String):void;
	}
}