package cls.com.ils.common.ctrl
{
	/**
	 * 検索コントロール利用クラス用インタフェース 
	 * @author furoi
	 * 
	 */	
	public interface ISharedSearch extends ISharedCtrl
	{
		
		/**
		 * 検索結果OK用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */	
		function getSrchOkResponse(cd:String, message:String):void;
		
		/**
		 * 検索結果OK（MSG付き）用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getSrchOkMsgResponse(cd:String, message:String):void;
		
		/**
		 * 検索結果OK（警告MSG付き）用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getSrchAlertResponse(cd:String, message:String):void;
		
		/**
		 * 検索結果が取得できなかったとき用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */	
		function getSrchNoDataResponse(cd:String, message:String):void;
		
		/**
		 * 検索時項目レベル（単純）エラー用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */		
		function getSrchItemErrResponse(cd:String, message:String):void;
		
		/**
		 * 検索業務エラー処理用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getSrchAppErrResponse(cd:String, message:String, kbn : String):void;
		
	}
}