package cls.com.ils.common.utility
{
	public class DateUtil
	{
    	public static const MODE_ADD:String = "+";
        public static const MODE_MINUS:String = "-";
        
        public static function dateAdd(
                                mode:String, 
                                srcDate:Date,
                                years:Number = 0, 
                                months:Number = 0, 
                                days:Number = 0, 
                                hours:Number = 0, 
                                minutes:Number = 0,
                                seconds:Number = 0,
                                milliSeconds:Number = 0):Date
        {
            var sign:int = 1;
            if(mode == MODE_MINUS){
                sign = -1;
            }

            var ret:Date = new Date();
            ret.time = srcDate.time;
            
            ret.fullYear = ret.fullYear + sign*years;
            ret = monthAdd(mode, ret, months);
            
            var d2Time:Number =
                    days*24*60*60*1000 +
                    hours*60*60*1000 +
                    minutes*60*1000 +
                    seconds*1000 +
                    milliSeconds;
            
            ret.time = ret.time + sign*d2Time;
            return ret;
        }
        
        public static function monthAdd(mode:String, srcDate:Date, months:Number):Date
        {
            var ret:Date = new Date();
            ret.time = srcDate.time;
            
            if(months == 0){
                return ret;
            }
            
            var srcYears:Number = srcDate.fullYear;
            var years:uint = Math.floor(Math.abs(months)/12);
            var mod:Number = Math.abs(months)%12;
            var currentMonth:Number = srcDate.month;
            var newMonth:Number = 0;
            
            switch(mode){
                case MODE_ADD:
                    newMonth = currentMonth + mod;
                    if(newMonth > 11){
                        years++;
                        newMonth = newMonth - 12;
                    }
                    ret.setFullYear(srcYears + years, newMonth);
                    break;

                case MODE_MINUS:
                    newMonth = currentMonth - mod;
                    if(newMonth < 0){
                        years++;
                        newMonth = 12 - Math.abs(newMonth);
                    }
                    ret.setFullYear(srcYears - years, newMonth);
                    break;
            }
            
            return ret;
        }
        
        public static function dateDiff(baseDate:Date, targetDate:Date):Object
        {
            var ret:Object = new Object();
            var value:Date = new Date();
            var sign:int = 1;
            if(baseDate.time > targetDate.time){
                sign = -1;
                value.time = baseDate.time - targetDate.time;
            }else{
                value.time = targetDate.time - baseDate.time;
            }
            
            
            ret.year = sign*(value.getUTCFullYear() - 1970);
            ret.month = sign*(value.getUTCMonth());
            ret.date = sign*(value.getUTCDate() - 1);

            ret.hours = sign*(value.getUTCHours());
            ret.minutes = sign*(value.getUTCMinutes());
            ret.seconds = sign*(value.getUTCSeconds());
            ret.milliseconds = sign*(value.getUTCMilliseconds());
            
            return ret;
        }
	}
}