package cls.com.ils.common.utility.logging
{
	import mx.logging.ILogger;
	import mx.logging.Log;
	import mx.logging.LogEventLevel;
	import mx.logging.targets.TraceTarget;
	
	/**
	 * ILSロギングツール
	 * ログ操作を行う.シングルトンパターンにて実現するため、
	 * ILoggerをstaticオブジェクトで生成している。
	 * 利用する場合、システムの共通初期化処理で、
	 * ログ出力設定を行うこと。ログ出力設定は、setOutputInitialize
	 * にて実施する。出力は、ILoggerクラスのログ出力メソッドを継承して利用する。
	 */
	public class IlsLoggingTool
	{
		
		/**
		 * ログオブジェクトこのクラスはこのオブジェクトに
		 * 対する操作を行いログの吐き出し処理を行う。 
		 */		
		public static var logger:ILogger;
				 
		/**
		 * 出力設定処理
		 * @param dispDate True:日付をログに出力する
		 * @param dispTime True:時間をログに出力する
		 * @param dispLevel True:出力レベルをログに出力する
		 * @param dispcategory True:カテゴリをログに出力する
		 * @param level 出力レベルの指定（LogEventLevelクラスで定義された定数を指定）
		 * @param categoryName カテゴリの名前
		 * 
		 */		
		public static function setOutputInitialize(
								dispDate:Boolean
							,	dispTime:Boolean
							,	dispLevel:Boolean
							,	dispcategory:Boolean
							,	level:int
							,	categoryName:String
		):void{
						
			var logTarget:TraceTarget = new TraceTarget();
			logTarget.includeDate = dispTime;
			logTarget.includeLevel = dispTime;
			logTarget.includeTime = dispLevel;
			logTarget.includeCategory = dispcategory;
			logTarget.level = level;
			
			Log.addTarget(logTarget);
			logger = Log.getLogger(categoryName);
				
		}
								
	}
}