package cls.com.ils.common.utility.net
{
	import cls.com.ils.common.utility.logging.IlsLoggingTool;
	
	import flash.net.URLVariables;
	
	import mx.rpc.http.HTTPService;

	/**
	 * Magicインターネットサービス（IIS - MRB)との
	 * 連携処理 
	 * 利用方法
	 * ①コンストラクタで生成する
	 * ②必要なパラメータを追加する addParam
	 * ③イベントリスナーの追加を呼出し元にて実施する
	 * ④sendEshitRequestで送信する
	 * @author furoi
	 * 
	 */	
	public class MagicHttpService extends HTTPService
	{
		
		// argument 区切り文字列
		private var paramSepString:String;
		private var paramSepStringAfter:String;
		// 引数
		private var urlVar:URLVariables;

		// パラメータ文字列
		private var argString:String;
		
		/**
		 * コンストラクタ
		 * ※Magic専用の設定を行います。
		 * ※各アプリケーションの設定は、アプリケーション用のHttpServiceにて設定します。
		 */		
		public function MagicHttpService()
		{
			super();
		
			// URL変数クラスの生成
			urlVar = new URLVariables();
			
			// パラメータを一つずつ指定してのリクエストで利用する
			paramSepString = "-A";
			paramSepStringAfter = ",";
		
			// 引数文字列保管用文字列の初期化	
			argString = "";

		}
		
		/**
		 * Magicアプリケーション名を指定する
		 * @param appname アプリケーション名
		 * 
		 */
		protected function set appname(appname:String):void{
			// APPNAMEは動的プロパティ
			urlVar.APPNAME = appname;
		}
		
		/**
		 * Magicの公開プログラム名を指定する 
		 * @param prgname 公開プログラム名
		 * 
		 */
		public function set prgname(prgname:String):void{
			// PRGNAMEは動的プロパティ
			urlVar.PRGNAME = prgname;	
		}
	
		/**
		 *パラメータの追加処理(XML形式での送信用) 
		 * @param param パラメータ
		 * 
		 */			
		public function addXmlParam(xmlString:String):void{
			argString = xmlString;	
		}
		
		/**
		 * パラメータの追加処理
		 * @param param パラメータ
		 * 
		 */		
		public function addParam(param:String):void{
			var pattern:RegExp = /,/g;  
			if(param){
				param = param.replace(pattern,"@@@");
			}else{
				param = "";
			}
			
			if(argString.length == 0){
				// 一つ目のパラメータ用
				argString = argString + paramSepString + param;	
			}else{
				// 一つ目のパラメータでない場合、カンマで区切る
				argString = argString + paramSepStringAfter + paramSepString + param;
			}
		}
		
		/**
		 * リクエスト送信メソッド 
		 * 
		 */		
		public function sendRequest():void{
			
			// パラメータ文字列へArgumentパラメータを追加 
			// ARGUMENTSは動的プロパティ
			 urlVar.ARGUMENTS = argString;
			
			IlsLoggingTool.logger.debug("url:{0}",this.url);
			IlsLoggingTool.logger.debug("param:{0}",argString);

			// リクエスト発行
			this.send(urlVar);

		}
				
	}
}