package commonLibrary.sharedValidators
{
	import cls.com.ils.common.model.MsgMgr;
	
	import mx.validators.EmailValidator;
	import mx.validators.ValidationResult;

	public class EmailValidator extends mx.validators.EmailValidator
	{
		
		public var checkMobileAdress:Boolean = false;
		
		private var mobile_ary:Array = [
				"docomo.ne.jp"
			,	"ezweb.ne.jp"
			,	"softbank.ne.jp"
			,	"vodafone.ne.jp"
			,	"pdx.ne.jp"
			];
		
		/**
		 *  Constructor.
		 */
		public function EmailValidator()
		{
			super();
			// 初期化処理
			initErrMsg();
		}
		
		// エラーメッセージの為の初期処理
		private function initErrMsg():void {
			//値が欠損し、required プロパティが true の場合
			requiredFieldError = MsgMgr.getMsg("W006");		
		}
			
		override protected function doValidation(value:Object):Array{
			var results:Array = super.doValidation(value);
			
			var val:String = value ? String(value) : "";
			
			if (results.length > 0 || ((val.length == 0) && !required)){
				return results;
			}else{
				var emailStr:String = String(value);
				var ampPos:int = emailStr.indexOf("@");
				var domain:String = emailStr.substring(ampPos + 1);
				var loopIndex:int;
				
				if(checkMobileAdress == true){
					for(loopIndex=0;loopIndex < mobile_ary.length;loopIndex ++){
						if(domain.indexOf(String(mobile_ary[loopIndex])) != -1){
							results.push(new ValidationResult(true,null,"",MsgMgr.getMsg("W004")));
							return results;
						}else{
						}
					}
				}
				
			}
			    
			return results;
			
		}
		
		
		
	}
}