package commonLibrary.sharedValidators
{
	import cls.com.ils.common.model.MsgMgr;
	
	import mx.events.ValidationResultEvent;
	import mx.utils.StringUtil;
	import mx.validators.NumberValidator;
	import mx.validators.ValidationResult;

	public class NumberValidator extends mx.validators.NumberValidator
	{
		public function NumberValidator()
		{
			super();
			// 初期化処理
			initErrMsg();
		}
		
		// エラーメッセージの為の初期処理
		private function initErrMsg():void {
			//値が欠損し、required プロパティが true の場合
			requiredFieldError = MsgMgr.getMsg("W006");		
		}

	    //----------------------------------
	    //  field
	    //----------------------------------    
	    
	    /**
	     *  @private
	     *  Storage for the property property.
	     */
	    private var _field:String;
	    
	    [Inspectable(category="General")]
	
	    /**
	     *  
	     *  @default null
	     */
	    public function get field():String
	    {
	        return _field;
	    }
	
	    /**
	     *  @private
	     */
	    public function set field(value:String):void
	    {
	        _field = value;
	    }

	    //----------------------------------
	    //  isTranslation
	    //----------------------------------    
	    
	    /**
	     *  @private
	     *  Storage for the property property.
	     */
	    private var _isTranslation:Boolean;
	    
	    [Inspectable(category="General")]
	
	    /**
	     *  
	     *  @default false
	     */
	    public function get isTranslation():Boolean
	    {
	        return _isTranslation;
	    }
	
	    /**
	     *  @private
	     */
	    public function set isTranslation(value:Boolean):void
	    {
	        _isTranslation = value;
	    }

		//--------------------------------------------------------------------------
		//
		//  Properties: Errors
		//
		//--------------------------------------------------------------------------
	
		//----------------------------------
		//  transError
		//----------------------------------
	
		/**
		 *  @private
		 *  Storage for the translationError property.
		 */
		private var _transError:String;
	
	    /**
		 *  @private
		 */
		private var transErrorOverride:String;
		
	    [Inspectable(category="Errors", defaultValue="null")]
	
		/** 
		 *  翻訳ができない場合のエラーメッセージ
		 *
		 *  @default ""
		 */
		public function get transError():String 
		{
			return _transError;
		}
	
		/*
		 *  @private
		 */
		public function set transError(value:String):void
	    {
	        transErrorOverride = value;

			_transError = value != null ?
							value :MsgMgr.getMsg("W008");
	    }

		public static function validateTrans(validator:commonLibrary.sharedValidators.NumberValidator,
											  value:Object,
											  baseField:String = null):Array
		{
			var results:Array = [];

			if (validator.source["isTranslation"])
			{
				if (!validator.source.readDataSet() && !validator.source["isEofOK"])
				{
					results.push(new ValidationResult(
						true, baseField, "invalidChar",
						StringUtil.substitute(validator.transError,"")));
					return results;
				}
			}
		
			return results;
		}

		//--------------------------------------------------------------------------
		//
		//  Overridden methods
		//
		//--------------------------------------------------------------------------
	
	    /**
		 *  @private    
	     */
		override protected function resourcesChanged():void
		{
			super.resourcesChanged();
	
			transError = transErrorOverride;
		}
		
		override protected function handleResults(errorResults:Array):ValidationResultEvent
		{
	        var resultEvent:ValidationResultEvent;
	        
	        resultEvent = super.handleResults(errorResults);
	        if (_field){
		        resultEvent.field = _field;
	        }
	        
			return resultEvent;
		}

		override protected function doValidation(value:Object):Array
		{
			var results:Array = super.doValidation(value);

			// Return if there are errors
			// or if the required property is set to <code>false</code> and length is 0.
			var val:String = value ? String(value) : "";
			if (results.length > 0 || ((val.length == 0) && !required))
			{
				if(this.source.hasOwnProperty("isTranslation"))
				{
					if (this.source["isTranslation"])
					{
						this.source["translationTarget"].text = "";
					}
				}				
				return results;
			}else{
				if(this.source.hasOwnProperty("isTranslation"))
				{
				    return validateTrans(this, value, null);
				}
//		        if (_isTranslation)
//		        {
//				    return validateTrans(this, value, null);
//		        }
				return results;
		    }
		}
		
	}
}