package commonLibrary.sharedValidators
{
	import mx.validators.Validator;
	import mx.validators.ValidationResult;

	public class RequiredValidator extends Validator
	{
		private var results:Array;
		
		public function RequiredValidator()
		{
			super();
		}

		override protected function doValidation(value:Object):Array {
			var field1:String = value.field1;
			var field2:String = value.field2;

			// Clear results Array.
			results = [];
			// Call base class doValidation().		
			results = super.doValidation(value);

			// Return if there are errors.
			if (results.length > 0)
				return results;
			// Check first name field.
			if ((field1 == "" || field1 == null) && (field2 == "" || field2 == null)){
				results.push(new ValidationResult(true,
				"", "requiredField", "どちらか一方が必須です。"));
				return results;
			}
			return results;
		}
	}
}