/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import java.util.Enumeration;
import java.util.Hashtable;

public class PropertyMapBuilder {
    private Hashtable map;
    private PropertyId[] keys;

    public PropertyMapBuilder() {
        this.map = new Hashtable();
    }

    public PropertyMapBuilder(PropertyMap propertyMap) {
        if (propertyMap instanceof PropertyMapImpl) {
            PropertyMapImpl propertyMapImpl = (PropertyMapImpl)propertyMap;
            this.map = propertyMapImpl.map;
            this.keys = propertyMapImpl.keys;
        } else {
            this.map = new Hashtable();
            int n = 0;
            int n2 = propertyMap.size();
            while (n < n2) {
                PropertyId propertyId = propertyMap.getKey(n);
                this.put(propertyId, propertyMap.get(propertyId));
                ++n;
            }
        }
    }

    private void lock() {
        if (this.keys != null) {
            return;
        }
        this.keys = new PropertyId[this.map.size()];
        int n = 0;
        Enumeration enumeration = this.map.keys();
        while (enumeration.hasMoreElements()) {
            this.keys[n++] = (PropertyId)enumeration.nextElement();
        }
    }

    private void copyIfLocked() {
        if (this.keys == null) {
            return;
        }
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < this.keys.length) {
            hashtable.put(this.keys[n], this.map.get(this.keys[n]));
            ++n;
        }
        this.map = hashtable;
        this.keys = null;
    }

    public PropertyMap toPropertyMap() {
        this.lock();
        return new PropertyMapImpl(this.map, this.keys);
    }

    public Object put(PropertyId propertyId, Object object) {
        this.copyIfLocked();
        if (object == null) {
            return this.map.remove(propertyId);
        }
        if (!propertyId.getValueClass().isInstance(object)) {
            throw new ClassCastException();
        }
        return this.map.put(propertyId, object);
    }

    public Object get(PropertyId propertyId) {
        return this.map.get(propertyId);
    }

    public boolean contains(PropertyId propertyId) {
        return this.map.get(propertyId) != null;
    }

    private static class PropertyMapImpl
    implements PropertyMap {
        private final Hashtable map;
        private final PropertyId[] keys;

        private PropertyMapImpl(Hashtable hashtable, PropertyId[] propertyIdArray) {
            this.map = hashtable;
            this.keys = propertyIdArray;
        }

        public Object get(PropertyId propertyId) {
            return this.map.get(propertyId);
        }

        public int size() {
            return this.keys.length;
        }

        public boolean contains(PropertyId propertyId) {
            return this.map.get(propertyId) != null;
        }

        public PropertyId getKey(int n) {
            return this.keys[n];
        }
    }
}

