package cls.com.ils.biz.component{
    import mx.collections.ArrayCollection;
    import mx.containers.Canvas;    
    
    public class Chart extends Canvas{
        private var _dataProvider:XMLList;
        
        public function Chart(obj:Object){
            _dataProvider = obj as XMLList;
        }
        
        
        public function draw(longMax:Number,dataMax:Number,colBody:uint, colAxis:uint):void{
            var radian:Number = 2*Math.PI/_dataProvider..length();
            var rStart:Number = _dataProvider[0].value * longMax / dataMax;
            
            //塗りの描画を開始。0.5は、アルファ値
            graphics.beginFill(colBody,0.5);
            //xy0位置から開始。
            graphics.moveTo(0, 0);
            
            for (var i:int=0; i<_dataProvider.length(); i++){
                var nLong:Number = _dataProvider[i].value * longMax/dataMax;
                var theta:Number = i*radian;
                //外枠をlineToで描画する。
                graphics.lineTo(nLong*Math.cos(theta), nLong*Math.sin(theta));
               
               //中軸を描画する。書いたのを、こっちで角度を付ける。 
               var axis:ChartAxis = new ChartAxis(longMax,colAxis);
               axis.rotation = theta*180/Math.PI;
               addChild(axis);
            }
            //ラインの最後の座標
            graphics.lineTo(rStart*Math.cos(0), rStart*Math.sin(0));
            //塗りの描画を修了。
            graphics.endFill();
            
            //外枠とメモリ（5分割：内枠）を描画。
            var axisOutline:Number = longMax/5;  
            for (var k:int=0; k<= 5; k++){
            	drawOutline(axisOutline	* k,colAxis);
            }	
        }
        
		//外枠とメモリ（5分割：内枠）を描画を実行。
        private function drawOutline(longMax:Number, color:uint):void{
            var radian:Number = 2*Math.PI/_dataProvider..length();
            graphics.lineStyle(0,color);
            graphics.moveTo(longMax*Math.cos(0), longMax*Math.sin(0));
            for (var i:int=0; i<_dataProvider..length(); i++){
                var theta:Number = i*radian;
                            
                graphics.lineTo(longMax*Math.cos(theta), longMax*Math.sin(theta));
    
            }
            //ラインの最後の座標
            graphics.lineTo(longMax*Math.cos(0), longMax*Math.sin(0));
            
            
        }
    }
}