package cls.com.ils.biz.component
{
	import flash.events.Event;
	import flash.net.*;
	
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.collections.XMLListCollection;
	import mx.containers.Panel;
	import mx.events.*;
	
	public class GcTextGetPanel extends Panel
	{
		
		protected var _okFnction:Function;	

		private var _itemList:Array;
		public function get itemList():Array{
			return _itemList;
		}
		
		private var _namelist:Array;
		public function get namelist():Array{
			return _namelist;
		}
		
		private var _categorylist:Array;
		public function get categorylist():Array{
			return _categorylist;
		}			
		
		/**
		 *　取込むXMLのファイル名 
		 */		
		private var _xmlFileName:String;
		
		public function set xmlFileName(fileName:String):void{
			_xmlFileName = fileName;
		}
		public function get xmlFileName():String{
			return _xmlFileName;
		}

		/**
		 *　取込むデータ内容 
		 */	
		public var _xmlData:XML;

		public function set xmlData(prmXmlData:XML):void{
			_xmlData = prmXmlData;
		}
		public function get xmlData():XML{
			return _xmlData;
		}
				 		

		/**
		 *　グラフタイプ 
		 */	
		private var _graphType:String;
		public function set graphType(prmType:String):void{
			_graphType = prmType;
		}
		public function get graphType():String{
			return _graphType;
		}		


		/**
		 *　グラフフォーム 
		 */	
		private var _graphForm:String;
		public function set graphForm(value:String):void{
			_graphForm = value;
		}
		public function get graphForm():String{
			return _graphForm;
		}	
		
		/**
		 *　取込むXMLのファイル名 
		 */			
		public function getXMLFile(fnc:Function):void{
			
			//取込後実行する関数をセット
			_okFnction = fnc;

	        //外部設定ファイルの読込
	        var loader:URLLoader = new URLLoader();
			loader.addEventListener("complete", xmlLoaded);
			
	        var request:URLRequest = new URLRequest(this.xmlFileName);
	        try {
	            loader.load(request);
	        } catch (error:Error) {
	            trace("Unable to load requested document.");
	        }		
		}
		
		//XMLデータの取込
		private function xmlLoaded(event:Event):void
		{
            var loader:URLLoader = URLLoader(event.target);				
		    _xmlData = XML(loader.data);
			if(_okFnction != null){	
				// 指定された関数を実行する
				_okFnction.call();
			}

		}
		
		//名前のリスト作成
		public function createNameList(prmValue:XMLList):void{
			var namelistName:Array = new Array();
			var counter:int = 0;
			
			_namelist = new Array();
			_itemList = new Array();
			
            for each(var property:XML in prmValue.name) {
                // Create an Array of unique categorys.
                if (namelistName[property] != property){
                    namelistName[property] = property;
                    _namelist[counter] = property;
                    
                    _itemList.push(property.@code);
                    counter = counter + 1; 
                }
            }            
			
		}
		
        //カテゴリリスト作成
		public function createCategoryList(prmValue:XMLList):void{
			var categorylistName:Array = new Array();
			var counter:int = 0;
			
			_categorylist = new Array();
			
            for each(var property:XML in prmValue.category) {
                // Create an Array of unique categorys.
                if (categorylistName[property] != property){
                    categorylistName[property] = property;
                    categorylist[counter] = property;
                
                	counter = counter + 1; 
                }
            }            
		}
		
		public function sortSeq(prmXml:XMLList):XMLList{
			
			var prmXmlCollection:XMLListCollection = new XMLListCollection();
			
			prmXmlCollection.source = XMLList(prmXml);
			prmXmlCollection.sort = new Sort();
				
			var sortKey1:SortField;
			var sortKey2:SortField;
			var sortKey3:SortField;
			var sortKey4:SortField;
				
			sortKey1 = new SortField("category", false);
			sortKey2 = new SortField("group", false);
			sortKey3 = new SortField("seq", false);
			sortKey4 = new SortField("name", false);
				
			//ソートの実行
			prmXmlCollection.sort.fields = [sortKey1,sortKey2,sortKey3,sortKey4];
			prmXmlCollection.refresh();
			
			return XMLList(prmXmlCollection);
		}
		
			
		
	}	
}
