package cls.com.ils.biz.component
{
	import bizLibrary.sharedComponent.ZoomButton;
	
	import cls.com.ils.biz.model.SharedPlace;
	import cls.com.ils.biz.model.enum.ActionMode;
	import cls.com.ils.biz.model.enum.FlgKbn;
	import cls.com.ils.biz.utility.logging.AppLoggingTool;
	import cls.com.ils.common.component.IlsDataGrid;
	import cls.com.ils.common.component.IlsPanel;
	import cls.com.ils.common.ctrl.ISharedRegist;
	import cls.com.ils.common.ctrl.ISharedRun;
	import cls.com.ils.common.ctrl.ISharedSearch;
	import cls.com.ils.common.model.MsgMgr;
	
	import commonLibrary.sharedComponent.TsAdvancedDataGrid;
	
	import flash.events.MouseEvent;
	import flash.utils.getQualifiedClassName;
	
	import mx.controls.Alert;
	import mx.core.UIComponent;
	import mx.events.CloseEvent;
	import mx.events.ListEvent;
	import mx.managers.CursorManager;
	import mx.managers.PopUpManager;
	
	/**
	 * 田中センイ共通パネル
	 * <p>田中センイの全ての画面はこのクラスを継承して作成されています。
	 * レスポンスに対する共通の動作をこのクラスで定義しています。
	 * レスポンスに対する動作を個別に変更する場合、レスポンスの区分
	 * に対応するメソッドをoverrideして、定義して下さい。画面に部品を
	 * 追加する場合、このクラスを継承しているEshiftPanelに処理を追加して
	 * 下さい。</p>
	 * 
	 * @author furoi
	 * 
	 */	
	public class TsAbstructPanel extends IlsPanel 
										implements ISharedRegist,ISharedSearch,ISharedRun
	{
		
		/**
		 * 動作モード 
		 * <p>
		 * 画面起動に起動元画面で動作モードを設定して下さい。
		 * 動作モードは、com.ils.biz.enum.ActionModeの定数を利用して
		 * 設定して下さい。
		 * </p>
		 */		
		public var actionMode:String;
				
		/**
		 * 子画面
		 */		
		private var _childWin:TsAbstructPanel;
		
		/**
		 * 子画面のGetterプロパティ
		 * @return 子画面を返す
		 * 
		 */				
		public function get childWin():TsAbstructPanel{
			return _childWin;
		}

		/**
		 * ビジーモードの設定プロパティ
		 * @param busyFlg false:ビジー設定 true:ビジー設定解除
		 * 
		 */		
		public function set busyMode(busyFlg:Boolean):void{
			_busyMode = busyFlg;
			if(_busyMode == true){
				this.setBusyCursor(false);
			}else{
				this.setBusyCursor(true);	
			}
		}
		
		/**
		 * ビジーモードのGetterプロパティ
		 * @return 現在のビジーモードを返す
		 * 
		 */				
		public function get busyMode():Boolean{
			return _busyMode;
		}
		
		public var btnZoom:UIComponent;

		/**
		 * ズームのコントロールのロックを制御。
		 * 
		 */		
		public function set zoomEnabled(value:Boolean):void{
			if (btnZoom){
				if(btnZoom is ZoomButton){
	            	ZoomButton(btnZoom).lock(!value);
				}
			}
		}

		public function zoom(value:Object):void{
			if (btnZoom){
				if(btnZoom is ZoomButton){
					ZoomButton(btnZoom).relatedObject = value;
	            	btnZoom.dispatchEvent(new MouseEvent(MouseEvent.CLICK));
				}
			}
		}
		
// コンストラクタ		
		/**
		 * パネルの初期設定 
		 * 
		 */		
		public function TsAbstructPanel(){

			//AppLoggingTool.logger.debug("{0}.{1}通過:{2}",this.name,"TsAbstructPanel");
						
			super();
			// レイアウト指定
			layout = "absolute";

			
		} 

// 共通画面イベント


		/**
		 * 初期化後処理 
		 * 
		 */		
		public function runInitAfterProc():void{
			this.openStats = false;			
		}

		/**
		 * 画面閉じる処理 
		 * eShift は画面を閉じるとき親画面を常に初期化する
		 */		
		public function close():void{			
		
			parentDisplay.enabled = true;
			parentDisplay.onCreationComplete();
			
//			parentDisplay.setFocusSrchObj();

			callLater(closeMe);

		}
		
		/**
		 * remove処理 
		 * close処理が終わってから自分自身の削除処理を実施する
		 */		
		private function closeMe():void{
			
			parentDisplay.focusManager.activate();
			this.focusManager.deactivate();
			PopUpManager.removePopUp(this);			
//			parentApplication.viewStack.removeChild(this);
		} 
		
		
		/**
		 * ログオフ処理
		 * ログオフ昨日は親画面のログオフメソッドを起動してから、
		 * 自分自身を閉じる。
		 */	
		public function logoff():void{
			parentDisplay.logoff();
			PopUpManager.removePopUp(this);
		}

		/**
		 * 排他エラー処理 
		 * ・eShiftはメニューで条件をしているので、検索処理でデータを取得できない
		 * 場合、常に排他エラー
		 *
		 * @param e
		 * 
		 */		
		public function runInit(e:CloseEvent):void{
			this.onCreationComplete();
		}
		
		/**
		 * クローズ処理（イベント用）
		 * @param e
		 * 
		 */		
		public function eventClose(e:CloseEvent):void{
			this.close();
		}
		
		/**
		 * ビジー状態にする 
		 * @param state true:ビジー false:非ビジー
		 * 
		 */		
		public function setBusyCursor(state:Boolean):void{
			
			if(state == true){
				var cursorId:int = CursorManager.currentCursorID;
				//親画面でenableをtrueにしていた場合に変更が可能なため常にfalseに設定
				this.enabled = false;
				if(cursorId != 0){
					// 既にbusy状態なのでなにもしない
				}else{
//					this.enabled = false;
//					this.focusManager.deactivate();
					CursorManager.setBusyCursor();												
				}
			}else{
				if(_busyMode == false){
					// もしビジーモードがtrueの場合、
					// setBusyCursorでtrueにされても
					// 無視する。
					// ビジーモードへの設定のみで
					// 解除できるものとする
				}else{
					this.enabled = true;
//					this.focusManager.activate();
					CursorManager.removeBusyCursor();									
				}
				
			}
		}
		
		/**
		 * エラー画面表示処理 
		 * 
		 */		
		public function dispErrScreen(errMsg:String):void{
			// エラー画面に遷移するエラーが複数回発生した場合、
			// 1回目で画面遷移を実施済みなので
			// 残りのエラーはスルーするようにする。
			if(this.errState == false){
				this.errState = true;
				// エラー画面の表示
				var win:BV1080020;
				win = BV1080020(PopUpManager.createPopUp(this,BV1080020,true));
				win.parentDisplay = this;
				win.errMsg = errMsg;
				PopUpManager.centerPopUp(win);

				this.focusManager.deactivate();
				win.focusManager.activate();
				
				this.close();
								
			}
		}

// レスポンスへの対応：共通エラー
		/**
		 * レスポンスでタイムアウトレスポンス取得時エラー
		 * <p>処理でレスポンス（タイムアウト）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getTimeOutResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2}",this.name,"getTimeOutResponse",cd);
//			MsgMgr.dispMsgAndCallEvent(cd,this.title,Alert.OK,eventClose);

			// カーソルを設定 
			this.setBusyCursor(false);
			
			// エラー画面の表示
			dispErrScreen(message);
			
		}
					
		/**
		 * レスポンスでジョブNo不正エラー
		 * <p>処理でレスポンス（不正ジョブによる発行）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getJobErrResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getJobErrResponse",cd,message);
//			MsgMgr.dispServerMsg(cd,message,this.title);

			// カーソルを設定 
			this.setBusyCursor(false);

			// エラー画面の表示
			dispErrScreen(message);

			
		}

		/**
		 * システム・エラー(予期せぬエラー)レスポンス取得メソッド
		 * <p>レスポンス（システム・エラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getSystemErrResponse(cd:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSystemErrResponse",cd);
			
			//MsgMgr.dispMsgAndCallEvent(cd,this.title,Alert.OK,eventClose);

			// カーソルを設定 
			this.setBusyCursor(false);
			
			// エラー画面の表示
			dispErrScreen("システムがビジーになりました。しばらく立ってから再度実施して下さい。");

		}

		/**
		 * 検索後セットフォーカス処理 
		 * 
		 */		
		public function setFocusSrchObj():void{
			
			// 検索後フォーカス設定オブジェクトが指定されている場合、
			// フォーカスを合わせる処理を行う。
			if(srchFcsObject!=null){
			
				// 検索後フォーカス合わせを行うオブジェクトが指定されている場合
				
				srchFcsObject.setFocus();
				// チェックボックス、ラジオボタンなどフォーカスを合わせるだけじゃ
				// フォーカス状態にならないコントロール用にdrawFocusを実行する
				srchFcsObject.drawFocus( true );
				
				// デバッグし易いように、文字列にクラス名を格納する
				var className:String = flash.utils.getQualifiedClassName(srchFcsObject);
				// パッケージ（mxの場合フォルダ)まで取得できる。そのためDataGridという名前
				// があるクラスの場合、rowCount,selectedIndexを利用できると決めうち
				// にしている
				if(srchFcsObject is IlsDataGrid){
					var grid:IlsDataGrid = srchFcsObject as IlsDataGrid;
					if(grid.rowCount != 0){
						if(grid.lastSelectedIndex < 0){
							// 1行目を選択する
							grid.selectedIndex = 0;
						}else{
							grid.selectedIndex = grid.lastSelectedIndex;
							grid.scrollToIndex(grid.lastSelectedIndex);
						}
						//選択してからchangeイベントがあれば、changeイベントを生成する。
						//コードから選択するとchangeイベントが発生しないため
						if(grid.hasEventListener(ListEvent.CHANGE) == true){
							grid.dispatchEvent(new ListEvent(ListEvent.CHANGE));	
						}
					}
				}
				if(srchFcsObject is TsAdvancedDataGrid){
					var aGrid:TsAdvancedDataGrid = srchFcsObject as TsAdvancedDataGrid;
					if(aGrid.rowCount != 0){
//						if(aGrid.lastSelectedIndex < 0){
							// 1行目を選択する
							aGrid.selectedIndex = 0;
//						}else{
//							aGrid.selectedIndex = aGrid.lastSelectedIndex;
//						}
						//選択してからchangeイベントがあれば、changeイベントを生成する。
						//コードから選択するとchangeイベントが発生しないため
						if(aGrid.hasEventListener(ListEvent.CHANGE) == true){
							aGrid.dispatchEvent(new ListEvent(ListEvent.CHANGE));	
						}
					}
				}
//				if(className.indexOf("DataGrid",0)>0){
//					var grid:IlsDataGrid = srchFcsObject as IlsDataGrid;
//					if(grid.rowCount != 0){
//						if(grid.lastSelectedIndex < 0){
//							// 1行目を選択する
//							grid.selectedIndex = 0;
//						}else{
//							grid.selectedIndex = grid.lastSelectedIndex;
//						}
//						//選択してからchangeイベントがあれば、changeイベントを生成する。
//						//コードから選択するとchangeイベントが発生しないため
//						if(grid.hasEventListener(ListEvent.CHANGE) == true){
//							grid.dispatchEvent(new ListEvent(ListEvent.CHANGE));	
//						}
//					}
//				}
			}
//↓↓検索後のフォーカス設定ができなくなる為、削除する
			// フォーカスマネージャーをONにする。
			// onにしなくてもおそらく大丈夫だが、次行で、親画面のフォーカス
			// マネージャーを無効にしたときにどこのフォーカスマネージャーが有効
			// になっているかわからない状態を避けるために実施する
			this.focusManager.activate();
			// 親画面にフォーカスが残らないようにフォーカスマネージャーを無効にする
			parentDisplay.focusManager.deactivate();
//↑↑検索後のフォーカス設定ができなくなる為、削除する
			
			// フォーカス設定後に、子画面起動状態を解除する
			this.runInitAfterProc()
			
		}

// レスポンスへの対応：検索処理時レスポンス処理
				
		/**
		 * 検索処理時OKレスポンス取得メソッド
		 * <p>検索処理でレスポンス（OK）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getSrchOkResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchOkResponse",cd,message);
			// なにもしない
			// システム全体として更新メッセージを表示する場合、ここに記述する。
			// 個別にメッセージを表示する場合、派生クラスで定義する。


			// カーソルを設定 
			this.setBusyCursor(false);
		
			callLater(setFocusSrchObj);

		}
		
		/**
		 * 検索処理時OK(メッセージ付き)レスポンス取得メソッド
		 * <p>検索処理でレスポンス（OK(メッセージ付き)）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getSrchOkMsgResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchOkMsgResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);

			// カーソルを設定 
			this.setBusyCursor(false);

			callLater(setFocusSrchObj);

		}
		
		/**
		 * 検索処理時警告レスポンス取得メソッド
		 * <p>検索処理でレスポンス（警告）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getSrchAlertResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchAlertResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);
    
			// カーソルを設定 
			this.setBusyCursor(false);
	
			callLater(setFocusSrchObj);

		}
		
		/**
		 * 検索処理時検索結果なしレスポンス取得メソッド
		 * <p>検索処理でレスポンス（データなし）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getSrchNoDataResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchNoDataResponse",cd,message);
//			MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,eventClose);
			MsgMgr.dispServerMsg(cd,message,this.title);

			// カーソルを設定 
			this.setBusyCursor(false);

			callLater(setFocusSrchObj);

		}
		
		/**
		 * 検索処理時検索結果項目エラー(文字桁、存在チェックなど１項目レベル
		 * のエラーが発生した場合の)レスポンス取得メソッド
		 * <p>検索処理でレスポンス（項目レベルエラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getSrchItemErrResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchItemErrResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);

			// カーソルを設定 
			this.setBusyCursor(false);

			callLater(setFocusSrchObj);

		}
		
		/**
		 * 検索処理時検索結果業務エラーレスポンス取得メソッド
		 * <p>検索処理でレスポンス（業務エラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 */		          
		public function getSrchAppErrResponse(cd:String,message:String,kbn:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchAppErrResponse",cd,message);
//			MsgMgr.dispServerMsg(cd,message,this.title);			
    		MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,this.focusSrchProc,this);

			// カーソルを設定 
			this.setBusyCursor(false);

//			callLater(setFocusSrchObj);

		}

		/**
		 * メッセージを通知した場合にcloseeventが必要なので、
		 * focusSrchProcメソッドのアダプタを作成する
		 * @param e イベント
		 * 
		 */
		public function focusSrchProc(e:CloseEvent):void{
			// 検索後セットフォーカス処理 
			this.setFocusSrchObj();			
		}
		
// レスポンスへの対応：登録処理時レスポンス処理


		/**
		 * 登録処理時OKレスポンス取得メソッド
		 * <p>登録処理でレスポンス（OK）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */
		public function getRegiOkResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRegiOkResponse",cd,message);

			// システム全体として更新メッセージを表示する場合、ここに記述する。
			// 個別にメッセージを表示する場合、派生クラスで定義する。
			// 完了メッセージの通知設定に合わせてメッセージを表示する
			if(SharedPlace.updinfo == FlgKbn.ON){
				// カーソルを設定 
				this.setBusyCursor(false);	

				var msgCd:String;
				if(this.actionMode == ActionMode.DEL){
					// 削除用通知メッセージを定義する
					msgCd = "I006";
				}else if(this.actionMode == ActionMode.INS){
					// 新規追加用通知メッセージを定義する
					msgCd = "I006";
				}else{
					// 更新用通知メッセージ、モードなし用通知メッセージ
					msgCd = "I006";
				}

				MsgMgr.dispMsgAndCallEvent(msgCd,this.title,Alert.OK ,regiProcAfterProc);	
			}else{
				this.regiProcAfterProcCore();	
			}
			
		}

		/**
		 * メッセージを通知した場合にcloseeventが必要なので、
		 * regiProcAfterProcCoreメソッドのアダプタを作成する
		 * @param e イベント
		 * 
		 */
		public function regiProcAfterProc(e:CloseEvent):void{
			// カーソルを設定 
			this.setBusyCursor(true);			

			this.regiProcAfterProcCore();
		}

		/**
		 * 成功時に行う処理の実態
		 * 
		 */
		public function regiProcAfterProcCore():void{
	
			if(this.actionMode == ActionMode.INS){
				// 新規モードの場合、画面を閉じないで初期化する
				//MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,runInit);
				this.onCreationComplete();
			}else{
				close();
			}
			// カーソルを設定 
			this.setBusyCursor(false);			
		}

		
		/**
		 * 登録処理時OK(メッセージ付き)レスポンス取得メソッド
		 * <p>登録処理でレスポンス（OK(メッセージ付き)）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getRegiOkMsgResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRegiOkMsgResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);
			if(this.actionMode == ActionMode.INS){
				// 新規モードの場合、画面を閉じないで初期化する
				MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,runInit);
			}else{
				MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,eventClose);
			}

			// カーソルを設定 
			this.setBusyCursor(false);

		}
		
		/**
		 * 登録処理時警告レスポンス取得メソッド
		 * <p>登録処理でレスポンス（警告）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getRegiAlertResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRegiAlertResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);
			if(this.actionMode == ActionMode.INS){
				// 新規モードの場合、画面を閉じないで初期化する
				MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,runInit);
			}else{
				MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,eventClose);
			}

			// カーソルを設定 
			this.setBusyCursor(false);

		}
		
		/**
		 * 登録処理時検索結果項目エラー(文字桁、存在チェックなど１項目レベル
		 * のエラーが発生した場合の)レスポンス取得メソッド
		 * <p>登録処理でレスポンス（項目レベルエラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getRegiItemErrResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRegiItemErrResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);

			// カーソルを設定 
			this.setBusyCursor(false);

		}

		/**
		 * 排他エラーレスポンス取得メソッド
		 * <p>登録処理でレスポンス（排他エラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getRegiHaitaResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRegiHaitaResponse",cd,message);

			if(this.actionMode == ActionMode.INS || this.actionMode == ActionMode.NONE){
				// 新規モード,モードなしの場合、画面を閉じないで初期化する
				MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,runInit);
			}else{
				MsgMgr.dispServerMsgAndCallEvent(cd,message,this.title,Alert.OK,eventClose);
			}

			// カーソルを設定 
			this.setBusyCursor(false);

		}

		/**
		 * 登録処理時検索結果業務エラーレスポンス取得メソッド
		 * <p>登録処理でレスポンス（業務エラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 */		
		public function getRegiAppErrResponse(cd:String,message:String,kbn:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRegiAppErrResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);			
			// カーソルを設定 
			this.setBusyCursor(false);
			btnInit(true);

		}
		
// レスポンスへの対応：実行処理時レスポンス処理
				
		/**
		 * 実行処理時OKレスポンス取得メソッド
		 * <p>実行処理でレスポンス（OK）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getRunOkResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRunOkResponse",cd,message);
			// なにもしない
			// システム全体として更新メッセージを表示する場合、ここに記述する。
			// 個別にメッセージを表示する場合、派生クラスで定義する。

			// カーソルを設定 
			this.setBusyCursor(false);
			
		}
		
		/**
		 * 実行処理時OK(メッセージ付き)レスポンス取得メソッド
		 * <p>実行処理でレスポンス（OK(メッセージ付き)）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getRunOkMsgResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRunOkMsgResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);

			// カーソルを設定 
			this.setBusyCursor(false);


		}
		
		/**
		 * 実行処理時警告レスポンス取得メソッド
		 * <p>実行処理でレスポンス（警告）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */		
		public function getRunAlertResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRunAlertResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);

			// カーソルを設定 
			this.setBusyCursor(false);


		}
		
		
		/**
		 * 実行処理時検索結果項目エラー(文字桁、存在チェックなど１項目レベル
		 * のエラーが発生した場合の)レスポンス取得メソッド
		 * <p>実行処理でレスポンス（項目レベルエラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 * 
		 */	
		public function getRunItemErrResponse(cd:String,message:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getSrchItemErrResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);
			// カーソルを設定 
			this.setBusyCursor(false);
		}
		
		/**
		 * 実行処理時検索結果業務エラーレスポンス取得メソッド
		 * <p>実行処理でレスポンス（業務エラー）が帰ってきたときに
		 * 実行されるメソッド。動作を個別画面で変更する場合、
		 * overrideして動作を定義して下さい。</p>
		 * @param cd メッセージコード
		 * @param message メッセージ内容
		 */		          
		public function getRunAppErrResponse(cd:String,message:String,kbn:String):void{
			AppLoggingTool.logger.debug("{0}.{1}通過:{2},{3}",this.name,"getRunAppErrResponse",cd,message);
			MsgMgr.dispServerMsg(cd,message,this.title);			
			// カーソルを設定 
			this.setBusyCursor(false);
		}
		
// 共通イベントメソッド定義（型を定義します）。

		/**
		 * 共通初期化処理用抽象メソッド
		 * 中身は各画面でこのメソッドをOverrideして
		 * 動作を定義して下さい。
		 * 
		 */		
		public function onCreationComplete():void{}

		/**
		 * 共通ボタン初期化処理用抽象メソッド
		 * 中身は各画面でこのメソッドをOverrideして
		 * 動作を定義して下さい。
		 * 
		 */		
		public function btnInit(value:Boolean):void{}


// 子画面起動メソッド
	
		/**
		 * 
		 * 新規登録モードで子画面を起動する
		 * @param cls 子画面のクラス名 
		 * @param params 0 - n個：代入した値を生成した子画面のparentParamsで利用できます。
		 * 
		 */
		public function dispInsChildWindowDparam(cls:Class,...params):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.INS;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}
		}

		/**
		 * 修正モードで子画面を起動する
		 * @param cls 子画面のクラス名
		 * @param params 0 - n個：代入した値を生成した子画面のparentParamsで利用できます。 
		 */		
		public function dispUpdChildWindowDparam(cls:Class,...params):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.UPD;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}
		}

		/**
		 * 削除モードで子画面を起動する
		 * @param cls 子画面のクラス名
		 * @param params 0 - n個：代入した値を生成した子画面のparentParamsで利用できます。
		 */		
		public function dispDelChildWindowDparam(cls:Class,...params):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.DEL;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}
		}
		
		/**
		 * モードなしで子画面を起動する
		 * @param cls 子画面のクラス名
		 * @param params 0 - n個：代入した値を生成した子画面のparentParamsで利用できます。
		 */		
		public function dispChildWindowDparam(cls:Class,...params):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.NONE;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}
		}
		
		/**
		 * 
		 * 新規登録モードで子画面を起動する
		 * @param cls 子画面のクラス名 
		 * @param params 配列型。
		 * 
		 */
		public function dispInsChildWindow(cls:Class,params:Array):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.INS;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}
		}

		/**
		 * 修正モードで子画面を起動する
		 * @param cls 子画面のクラス名
		 * @param params 配列型。 
		 */		
		public function dispUpdChildWindow(cls:Class,params:Array):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.UPD;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}

			
		}

		/**
		 * 削除モードで子画面を起動する
		 * @param cls 子画面のクラス名
		 * @param params 配列型。
		 */		
		public function dispDelChildWindow(cls:Class,params:Array):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.DEL;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}
		}
		
		/**
		 * 
		 * 複写モードで子画面を起動する
		 * @param cls 子画面のクラス名 
		 * @param params 配列型。
		 * 
		 */
		public function dispCopyChildWindow(cls:Class,params:Array):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.COPY;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}
		}

		/**
		 * モードなしで子画面を起動する
		 * @param cls 子画面のクラス名
		 * @param params 配列型。
		 */		
		public function dispChildWindow(cls:Class,params:Array):void{
			if(openStats == false){
				_childWin = TsAbstructPanel(PopUpManager.createPopUp(this,cls,true));
								
				_childWin.focusManager.activate();
				this.focusManager.deactivate();
				_childWin.actionMode = ActionMode.NONE;
				_childWin.parentParams = params;
				_childWin.parentDisplay = this;
				PopUpManager.centerPopUp(_childWin);
				openStats = true;
			}

		}

	}
}