package cls.com.ils.biz.ctrl
{
	
	import cls.com.ils.biz.model.SharedDataModel;
	import cls.com.ils.biz.model.enum.ResponseKbn;
	import cls.com.ils.biz.utility.logging.AppLoggingTool;
	import cls.com.ils.biz.utility.net.HttpRequest;
	
	import mx.managers.CursorManager;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	/**
	 * Eshift用コントローラ 
	 * @author furoi
	 * 
	 */	
	public class TsSharedCtrl
	{
		
// プロパティ領域		

		/**
		 * 呼出した画面の参照 
		 */		
		protected var _target:Object;

		/**
		 *　公開プログラムID 
		 * ここに格納されているMagic公開プログラムIDを
		 * 利用して、サーバーサイドプログラムを実行します。
		 */		
		protected var _prgramId:String;
		
		/**
		 * データモデル 
		 */		
		protected var _model:SharedDataModel;

		/**
		 * HttpRequestService 
		 */
		protected var _service:HttpRequest;
		
		/**
		 * ＯＫレスポン時実行関数
		 */
		protected var _okFnction:Function;
		
// コンストラクタ領域
				
		/**
		 * コンストラクタ 
		 * @param prgramId 公開プログラムID
		 * 
		 */		
		public function TsSharedCtrl(prgramId:String)
		{
			// 公開プログラムIDの取得
			_prgramId = prgramId;

			//OS既定の文字コードを使用するように設定を変更
//			System.useCodePage = false;

			// HttpServiceの生成
			_service = new HttpRequest();
			
		}
		
// publicメソッド領域
				
		/**
		 * ＯＫレスポンス時実行関数定義 
		 * @param fnc 関数オブジェクト
		 * 
		 */		
		public function setOkFunction(fnc:Function):void{
			_okFnction = fnc;
		}

// override用メソッド領域
		
		/**
		 * 個別に継承した検索用コントローラにイベントリスナー
		 * を追加する場合、継承クラスにこのメソッドをオーバーライドして実装します。
		 * 実装は、super._service オブジェクトにイベントをアタッチしてください。 
		 */		
		protected function addSpecialEventListener():void{
			/* implement method */
		}
		
		/**
		 * サーバーサイドへ追加パラメータを利用する場合、
		 * 継承クラスでこのメソッドをオーバーライドして実装して下さい。
		 * 実装は、_service.addParam を利用して下さい。
		 * 
		 */		
		protected function addSpecialParam():void{
			/* implement method */			
		}

// レスポンス受信イベント
		/**
		 * HttpReuquest成功時実行メソッド 
		 * 取得時挙動を変更する場合、このメソッドをオーバーライドして
		 * 実装します。
		 * ※SharedRegist,SharedRun,SharedSearch,ComboboxCtrlは
		 * このメソッドをオーバーライドして実装している
		 * @param event イベント情報
		 * 
		 */				
		protected function httpResult(event:ResultEvent):void {
			
			AppLoggingTool.logger.debug("取得成功しました：{0}",String(event.result.kekka.kbn));

			// JOBNOを設定する
			setJobNo(String(event.result.kekka.jobno));
			
			// レスポンス区分にあわして画面を制御する
			switch(String(event.result.kekka.kbn)){
				case ResponseKbn.OK:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(event.result);
					// 正常
					getOkResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.OK_ALERT:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(event.result);
					// 正常（メッセージ付き）
					break;
				case ResponseKbn.OK_ALERT:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(event.result);
					// 警告
					break;
				case ResponseKbn.ERR_COM_JOB:
					// ジョブＮｏエラーは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない
				
					// 不正ジョブNo
					getErrJobResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_COM_TIMEOUT:
					// タイムアウトは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない

					// タイムアウト
					getErrTimeoutResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_COM_SYSTEM:
					// システムエラーは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない

					// システムエラー
					getErrSsytem();
					break;
				case ResponseKbn.ERR_COM_ITEM:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクするとデータモデルが初期化されてしまうので問題あり
				
					// 項目エラー
					gerErrItem(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_SRCH_NO_DATA:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない。再検索する必要があるため

					// データなし
					getErrNoData(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_REGI_HAITA:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない。

					// 排他エラー
					getErrHaita(new XML(event.result.kekka));
					break;
				default:
				
					if(String(event.result.kekka.kbn).substr(0,1) == String(ResponseKbn.ERR_SRCH_NO_DATA).substr(0,1) ){
						// 頭一桁が検索系（Ｓ）の場合、データなし処理を実施する
						getErrNoData(new XML(event.result.kekka));
					}else{
						// 業務エラー
						// 業務エラー、このあとモデルを利用しない、
						// そのためデータ情報をモデルにリンクさせない。
						// リンクするとデータモデルが初期化されてしまうので問題あり
						
						getErrAppLogic(new XML(event.result.kekka));
					}
				

					break;
			}
						
		}

		/**
		 * ジョブＮｏ格納用メソッド 
		 * @param jobNo
		 * 
		 */		
		protected function setJobNo(jobNo:String):void{
			// ジョブＮｏへの格納は各機能のsetJobNoで実施する。
			// overrideの利用
		}

		/**
		 * HttpReuquest失敗時実行メソッド 
		 * 失敗時挙動を変更する場合、このメソッドをオーバーライドして
		 * 実装します。
		 * @param event イベント情報
		 * 
		 */				
		protected function httpFault(event:FaultEvent):void {
			
//			_target.enabled = true;
			CursorManager.removeBusyCursor();
				
			AppLoggingTool.logger.warn("取得できませんでした。");
			var faultstring:String = event.fault.faultString;
			getErrSsytem();
			//getErrTimeoutResponse();
		}

// 結果対応メソッド

		/**
		 * 業務エラーレスポンス処理用抽象メソッド
		 * @param pxml
		 * 
		 */
		protected function getErrAppLogic(pxml:XML):void{}

		/**
		 * OKレスポンス処理用抽象メソッド 
		 * @param pxml
  		 * 
		 */
		protected function getOkResponse(pxml:XML):void{}
		
		/**
		 *OK(メッセージ付き）レスポンス処理抽象メソッド 
		 * @param pxml
		 * 
		 */		
		protected function getOKMsgResponse(pxml:XML):void{}
		
		/**
		 *警告レスポンス処理抽象メソッド
		 * @param pxml
		 * 
		 */		
		protected function getAlertResponse(pxml:XML):void{}
		
		/**
		 * NG(ジョブNO)レスポンス
		 * @param pxml
		 * 
		 */		
		protected function getErrJobResponse(pxml:XML):void{
			// todo ジョブNo不正時の共通処理を定義する
			_target.getJobErrResponse(pxml.cd,pxml.message);
		}
		
		/**
		 *タイムアウトレスポンス 
		 * 
		 */		
		protected function getErrTimeoutResponse(pxml:XML):void{
			_target.getTimeOutResponse(pxml.cd,pxml.message);
		}
		
		/**
		 * システムエラー
		 * 
		 */		
		protected function getErrSsytem():void{
			_target.getSystemErrResponse("Z8");
		}
		
		/**
		 * アイテム取得エラー（抽象クラス） 
		 * 
		 */		
		protected function gerErrItem(pxml:XML):void{}
		
		
		/**
		 * 取得データ０時エラー 
		 * @param pxml
		 * 
		 */		
		protected function getErrNoData(pxml:XML):void{}
		
		/**
		 * 排他発生時エラー 
		 * @param pxml
		 * 
		 */		
		protected function getErrHaita(pxml:XML):void{}
		
// final protectedメソッド領域
		
		/**
		 * ViewとCtrlの共通データリポジトリとなる
		 * データモデルのリンクを設定します。
		 * @param object データモデル
		 * 
		 */
		final protected  function setDataModel(model:Object):void{
			_model = model as SharedDataModel;
		}
		
		/**
		 * 送信情報の設定用抽象メソッド
		 * パラメータ、公開プログラムID、リクエスト用のオブジェクトの生成などを行う。
		 * 取得成功メソッド、失敗メソッドのアタッチを行う。 
		 * 
		 */
		final protected  function setSendInfo():void{

			AppLoggingTool.logger.debug("通信設定開始");
			
			// パラメータの追加処理
			setParam();
			
			// イベントリスナーの追加メソッド
			setEvent();
			
		}
		
		/**
		 * イベントリスナーの設定メソッド
		 * @return 
		 * 
		 */		
		final protected  function setEvent():void{

			// レスポンス正常受信イベントのアタッチ			
			_service.addEventListener("result", httpResult);
			// レスポンス受信失敗イベントのアタッチ
			_service.addEventListener("fault", httpFault);
			// 個別イベントリスナー追加メソッドの呼出し			
			addSpecialEventListener();		
		}
		
		/**
		 * パラメータ設定用メソッド 
		 * 
		 */	
		protected  function setParam():void{
	
			// 公開プログラム名を指定
			_service.prgname = _prgramId;
			// デフォルト用引数を設定
			if(_model.arg.length != 0){
				for(var roopIndex:int = 0;roopIndex<_model.arg.length;roopIndex++){
					_service.addParam(_model.arg[roopIndex] as String);					
				}
			}
			// 個別パラメータ追加メソッドの呼出し			
			addSpecialParam();		
		}
		
		/**
		 * 送信処理用抽象クラス 
		 * 
		 */			
		final protected function send():void{
			_service.sendRequest();			
		}

	}
}