package cls.com.ils.biz.ctrl
{
	import cls.com.ils.biz.model.SharedPlace;
	import cls.com.ils.biz.model.enum.ResponseKbn;
	import cls.com.ils.biz.utility.logging.AppLoggingTool;
	
	import mx.rpc.events.ResultEvent;
	
	/**
	 * 検索処理用の抽象コントローラ
	 * <p> 各アプリケーションで継承した抽象クラスを作成し利用します。</p> 
	 * @author furoi
	 * 
	 */	
	public class TsSharedSearch extends TsSharedCtrl
	{


// コンストラクタ
		/**
		 * コンストラクタ 
		 * @param prgramId magic公開プログラムID
		 * 
		 */		
		public function TsSharedSearch(prgramId:String,callScreen:Object)
		{
			//TODO: implement function
			super(prgramId);
			
			_target = callScreen;

		}

// パブリックメソッド
		/**
		 * 検索処理 
		 * @param object データモデル
		 * 
		 */		
		public function searchCtrl(model:Object):void{
			
			// カーソルを設定 
			_target.setBusyCursor(true);
			
			// データモデルを設定する
			setDataModel(model);
			// データの送信準備
			setSendInfo();			
			// データの送信処理
			send();
		}
		
		/**
		 * パラメータ設定用メソッド 
		 * 
		 */	
		override protected  function setParam():void{
	
			// 公開プログラム名を指定
			_service.prgname = _prgramId;
			// デフォルト用引数を設定
			if(_model.arg != null){
				if(_model.arg.length != 0){
					for(var roopIndex:int = 0;roopIndex<_model.arg.length;roopIndex++){
						_service.addParam(_model.arg[roopIndex] as String);
					}
				}
			}
			// 個別パラメータ追加メソッドの呼出し			
			addSpecialParam();		
		}
		
		/**
		 * ジョブＮｏを共通領域に設定する 
		 * @param jobNo
		 * 
		 */		
		override protected function setJobNo(jobNo:String):void{
			SharedPlace.jobNo = String(jobNo);
		}
				

// リクエストへの振り分け処理
// オーバーライドする。
		/**
		 * HttpReuquest成功時実行メソッド 
		 * 取得時挙動を変更する場合、このメソッドをオーバーライドして
		 * 実装します。
		 * @param event イベント情報
		 * 
		 */				
		override protected function httpResult(event:ResultEvent):void {
			
			AppLoggingTool.logger.debug("取得成功しました：{0}",String(event.result.kekka.kbn));

			// JOBNOを設定する
			setJobNo(String(event.result.kekka.jobno));
			
			// レスポンス区分にあわして画面を制御する
			switch(String(event.result.kekka.kbn)){
				case ResponseKbn.OK:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(event.result);
					// 正常
					getOkResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.OK_ALERT:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(event.result);
					// 正常（メッセージ付き）
					break;
				case ResponseKbn.OK_ALERT:
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(event.result);
					// 警告
					break;
				case ResponseKbn.ERR_COM_JOB:
					// ジョブＮｏエラーは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない
				
					// 不正ジョブNo
					getErrJobResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_COM_TIMEOUT:
					// タイムアウトは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない

					// タイムアウト
					getErrTimeoutResponse(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_COM_SYSTEM:
					// システムエラーは、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない

					// システムエラー
					getErrSsytem();
					break;
				case ResponseKbn.ERR_COM_ITEM:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクするとデータモデルが初期化されてしまうので問題あり
				
					// 項目エラー
					gerErrItem(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_SRCH_NO_DATA:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない。再検索する必要があるため
					// データ情報をモデルにリンクさせる
					_model.resXml = new XML(event.result);
					// データなし
					getErrNoData(new XML(event.result.kekka));
					break;
				case ResponseKbn.ERR_REGI_HAITA:
					// 項目エラー、このあとモデルを利用しない、
					// そのためデータ情報をモデルにリンクさせない。
					// リンクしても問題ない。

					// 排他エラー
					getErrHaita(new XML(event.result.kekka));
					break;
				default:
				
					if(String(event.result.kekka.kbn).substr(0,1) == String(ResponseKbn.ERR_SRCH_NO_DATA).substr(0,1) ){
						// 頭一桁が検索系（Ｓ）の場合、データなし処理を実施する
						getErrNoData(new XML(event.result.kekka));
					}else{
						// 業務エラー、このあとモデルを利用しない、
						// そのためデータ情報をモデルにリンクさせない。
						// リンクするとデータモデルが初期化されてしまうので問題あり
						
						getErrAppLogic(new XML(event.result.kekka));
						
					}
				
					break;
			}
						
		}



// リクエスト結果への対応メソッド

		/**
		 * リクエストがOKのときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		override protected function getOkResponse(pxml:XML):void{ 
			
			_target.getSrchOkResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}

		/**
		 * リクエストがOK(msg付き)のときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		override protected function getOKMsgResponse(pxml:XML):void{ 
			_target.getSrchOkMsgResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}
		
		/**
		 * リクエストが警告のときに実行するメソッド。
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchOkResponseをオーバーライドして定義すること。
		 * @param pxml 
		 */
		override protected function getAlertResponse(pxml:XML):void{ 
			_target.getSrchAlertResponse(pxml.cd,pxml.message);
			if(_okFnction == null){	
			}else{
				// 指定された関数も実行する
				_okFnction.call();
			}
		}		
		
		/**
		 * 項目レベルエラーのときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchItemErrResponseをオーバーライドして定義すること。
 		 * @param pxml
		 * 
		 */		
		override protected function gerErrItem(pxml:XML):void{
			_target.getSrchItemErrResponse(pxml.cd,pxml.message);
		}
		
		/**
		 * 検索結果なしのときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchNoDataResponseをオーバーライドして定義すること。
  		 * @param pxml
		 * 
		 */
		override protected function getErrNoData(pxml:XML):void{
			_target.getSrchNoDataResponse(pxml.cd,pxml.message);	
		}
		
		/**
		 * 検索時業務エラー発生のときに実行するメソッド
		 * 個別に定義する画面で、振る舞いを変更したいときは、
		 * EshiftAbstructPanelのgetSrchAppErrResponseをオーバーライドして定義すること。
  		 * @param pxml
		 * 
		 */	
		override protected function getErrAppLogic(pxml:XML):void{
			_target.getSrchAppErrResponse(pxml.cd,pxml.message,pxml.kbn);	
		}
		
	}
}