package cls.com.ils.biz.model
{
	import cls.com.ils.biz.*;
	import cls.com.ils.biz.model.enum.*;
	import cls.com.ils.biz.utility.logging.AppLoggingTool;
	import cls.com.ils.common.model.MsgMgr;
	
	import mx.core.Application;
	import mx.managers.BrowserManager;
	import mx.managers.IBrowserManager;
	import mx.rpc.http.HTTPService;
	import mx.utils.URLUtil;
	
	/**
	 *シェアするオブジェクト・データなどを定義します。 
	 * @author furoi
	 * 
	 */	
	public final class SharedPlace
	{
		
		
// システム設定領域
		/**
		 * アプリケーション名（２文字） 
		 */		
//		public static var APP_MAGIC_NAME:String = "DC";
		public static var APP_MAGIC_NAME:String = "BV";

		public static const APP_NAME:String = "BizViewer";


		// 通信設定		
		/**
		 * HttpRequestの発行先 
		 */		
		//public static var NET_URL:String = "http://61.194.10.133/uniscripts/mgrqispi.dll";
		public static var NET_URL:String = "http://localhost/magic101scripts/mgrqispi101.dll";		//MagicV10
		//public static var NET_URL:String = "http://172.16.5.3/uni18Scripts/MGrqispi018.dll";		//uniPaaS V1 Plus
//		public static var NET_URL:String = "http://localhost/uni18Scripts/MGrqispi018.dll";		//uniPaaS V1 Plus
		

		/**
		 * ジョブNO送信時、パラメータ名
		 */		
		public static const REQUEST_PARAM_JOBNO:String = "sid";

		/**
		 * responseのxmlﾌｫｰﾏｯﾄ 
		 */				
		public static const NET_RESULT_FORMAT:String = HTTPService.RESULT_FORMAT_E4X;

		/**
		 * HttpRequestの共通メソッド 
		 */				
		public static const NET_METHOD:String = "POST";
		
		/**
		 * プロキシの利用有無
		 */				
		public static const NET_USE_PROXY:Boolean = false;

		/**
		 * 開発モード true:開発 false:本番(ログイン画面をだすかどうかの違い）
		 */
		public static const DEV_MODE:Boolean = false;
		 

// メモリ＆設定領域
		
		private static var bm:IBrowserManager;

		/**
		 * 自動ログインモード
		 */
		public static var AUTO_LOGIN:String = FlgKbn.OFF;
 
		/**
		 * 技術公開モード
		 */
		public static var KOKAI_LOGIN:String = FlgKbn.OFF;

		/**
		 * デモモード
		 */
		public static var DEMO_LOGIN:String = FlgKbn.OFF;
// メモリ領域
	
		/**
		 * ジョブNo格納場所 
		 */	
		public static var jobNo:String;
		
		/**
		 * ログインユーザー名 
		 */
		 [Bindable]
		public static var userName:String;
		
		/**
		 * ログイン所属テナント名
		 */		
		[Bindable]
		public static var tenantName:String;
		
		/**
		 * 管理者権限 
		 * FlgKbnで値を格納・比較すること
		 */		
		public static var kanriKengen:String;
		
		/**
		 * ログイン状態 
		 * FlgKbnで値を格納・比較すること
		 */		
		public static var loginState:String;
		
		/**
		 * 希望入力登録パターン 
		 * FlgKbnで値を格納・比較すること
		 */		
		public static var tourokuKbn:String;
		
		/**
		 * 公開区分
		 * FlgKbnで値を格納・比較すること
		 */		
		public static var koukaiKbn:String;
		
		/**
		 * 印刷区分
		 * FlgKbnで値を格納・比較すること
		 */		
		public static var printKbn:String;

		/**
		 * 更新確認メッセージ表示区分
		 * FlgKbnで値を格納・比較すること
		 */		
		public static var updQuestion:String = FlgKbn.OFF;

		/**
		 * 更新完了メッセージ表示区分
		 * FlgKbnで値を格納・比較すること
		 */		
		public static var updinfo:String = FlgKbn.OFF;

		/**
		 * ユーザーモデル
		 */
		[Bindable]
		public static var userModel:XML;

		/**
		 * システムモデル 
		 */
		[Bindable]
		public static var systemModel:XML;

		/**
		 * 大分類モデル 
		 */
		[Bindable]
		public static var daiBunruiModel:XML;
		
		/**
		 * シーズンモデル 
		 */
		[Bindable]
		public static var seasonModel:XML;
		
		/**
		 * 配送モデル 
		 */
		[Bindable]
		public static var haisouModel:XML;

		/**
		 * 調整区分モデル 
		 */
		[Bindable]
		public static var cyoseiKbnModel:XML;

		/**
		 * メニューモデル 
		 */
		[Bindable]
		public static var menuModel:XML;

		/**
		 * ユーザグループモデル 
		 */
		[Bindable]
		public static var userGroupModel:XML;
		
		/**
		 * 商品管理区分モデル 
		 */
		[Bindable]
		public static var syoKanriKbnModel:XML;
		
		/**
		 * 単価税区分モデル 
		 */
		[Bindable]
		public static var tanZeiKbnModel:XML;

		/**
		 * 強調表示区分モデル 
		 */
		[Bindable]
		public static var kyocyoKbnModel:XML;

		/**
		 * 販売形態区分モデル 
		 */
		[Bindable]
		public static var hanKeiKbnModel:XML;

		/**
		 * プリンタモデル 
		 */
		[Bindable]
		public static var printerModel:XML;

		//クラス呼び出し用の変数･･･メニューから呼び出すクラスを登録する
//		private var pg1:TS1010010;
//		private var pg2:TS1010020;
//		private var pg3:TS1010030;
//		private var pg4:TS1010040;
//		private var pg5:TS1010050;
//		private var pg6:TS1010060;
//		private var pg7:TS1010070;
//		private var pg8:TS1020010;
//		private var pg9:TS1020020;
//		private var pg10:TS1020030;
//		private var pg11:TS1020040;
//		private var pg12:TS1020050;
//		private var pg13:TS1020060;
//		private var pg14:TS1020070;
//		private var pg15:TS1030010;
//		private var pg16:TS1030020;
//		private var pg17:TS1030030;
//		private var pg18:TS1030040;
//		private var pg19:TS1040010;
//		private var pg20:TS1040020;
//		private var pg21:BZ1010010;
//		private var pg22:BZ1010020;
//		private var pg23:DC1010010;
//		private var pg24:DC1010030;

// メソッド
		
		/**
		 * 初期化処理
		 * ※eShiftアプリケーソン全体の共通初期化処理をまとめます。
		 */		
		public static function init():void
		{
			
            bm = BrowserManager.getInstance();
            bm.init("", APP_NAME);

            /* URLの後に"#"につづけてパラメータを追加する
               例:http://localhost/biz/BizViewer.html#jobNo=000000000 */
            var o:Object = URLUtil.stringToObject(bm.fragment, "&");          
			if(o.jobNo){
	            jobNo = o.jobNo;
				// ログイン状態をＯＮにする
				SharedPlace.loginState = FlgKbn.ON;
				AUTO_LOGIN = FlgKbn.ON;
			}else{
				jobNo = ""
				// ログイン状態をＯＦＦにする
				SharedPlace.loginState = FlgKbn.OFF;
			}

			bm.setTitle(APP_NAME);

			// 画面の起動はメニューで統括する
			// ここでは、モードの設定だけ行う
			if(String(Application.application.parameters.mode) == "0"){
				// swfの外部パラメータmode が 0の場合、開発用
			}else{
				// 以外は指定Server
				//NET_URL = "http://" + String(Application.application.parameters.ip) + "/magic101scripts/mgrqispi101.dll";
				NET_URL = "http://" + String(Application.application.parameters.ip) + "/uni18Scripts/MGrqispi018.dll";		//uniPaaS V1 Plus
			}

			//ログオブジェクトを生成します
			AppLoggingTool.init();

			// メッセージを設定する
			var msgAry:Array = [
				["Z9","サーバーに接続できませんでした。\nしばらく立ってから再度実施して下さい。"]
			,	["Z8","予期せぬエラーが発生しました。\nしばらく立ってから再度実施して下さい。"]
			,	["Z7","ブラウザを閉じることができませんでした。\nブラウザの「×」ボタンで画面を閉じてください。"]
			,	["W001","{%1}の大小関係が不正です。"]
			,	["W002","半角 {0} 文字以下で入力して下さい。"]
			,	["W003","半角 {0} 文字以上で入力して下さい。"]
			,	["W004","管理者は携帯のメールアドレスで登録できません。"]
			,	["W005","{%1}と{%2}の大小関係が不正です。"]
			,	["W006","この項目は必須です。"]
			,	["W007","デモ環境の為、更新することができません。"]
			,	["W008","{0}コードが存在しません。"]
			,	["W009","次の階層はありません。"]
			,	["Q001",""]
			,	["Q002","新規追加してもよろしいですか？"]
			,	["Q003","更新してもよろしいですか？"]
			,	["Q004","削除してもよろしいですか？"]
			,	["Q005","入力を取消します。\nよろしいですか？"]
			,	["Q006","処理を変更します。\nよろしいですか？"]
			,	["Q007","入力は破棄されます。\nよろしいですか？"]
			,	["I001","総合計が前画面の設定内容と違います。"]
			,	["I002","ログインＩＤとパスワードをメールアドレスに送信しました。"]
			,	["I003","パスワードをメールアドレスに送信しました。"]
			,	["I004","eShiftへのご登録ありがとうございます。\n初回パスワードからの変更をお勧めします。\n変更しない場合、「閉じる」ボタンでパスワード変更画面を閉じて下さい。"]
			,	["I005","{%1}と{%2}の内容が違います。"]
			,	["I006","処理が完了しました。"]
			];
			MsgMgr.msgAry = msgAry;

			// 開発中用仮データ
			if(DEV_MODE == true){
				jobNo = "testtesttest";
				userName = "開発担当者";
				tenantName = "株式会社 アイエルエス";
				tourokuKbn = FlgKbn.ON;
				updQuestion = FlgKbn.ON;
			}else if(DEMO_LOGIN == true){
				jobNo = "demo";
				userName = "シフト太郎様";
				tenantName = "○○○○○病院";
			}else{
//				jobNo = "";
				userName = "ゲスト";
				tenantName = "ゲスト";		
				updQuestion = FlgKbn.ON;
			}

		}

	}
}