package cls.com.ils.biz.utility.logging
{
	import cls.com.ils.common.utility.logging.IlsLoggingTool;
	
	import mx.logging.ILogger;
	import mx.logging.LogEventLevel;

	/**
	 * 各アプリケーション用ロギングツール
	 * ログ設定の共通化、
	 * 利用方法
	 * ①利用前にinitメソッドを実行して下さい。
	 * ②必要に応じて、ログを出力して下さい。（loggerプロパティを操作して下さい。
	 * 出力方法はILoggingクラスの出力メソッドと同等です。）
	 * @author furoi
	 */	
	public final class AppLoggingTool extends IlsLoggingTool
	{
	
		/**
		 * ロギングオブジェクトの実態
		 */		
		public static var logger:ILogger;
		
		/**
		 * eShift用ログの出力設定 
		 * ※利用前に必ず呼出してください。
		 */		
		public static function init():void{
						
			// ログ出力設定
			IlsLoggingTool.setOutputInitialize(
				true
			,	true
			,	true
			,	true
			,	LogEventLevel.DEBUG
			,	"ProgramersMsg"
			);
			logger = IlsLoggingTool.logger;
		}
		
	}
}