package cls.com.ils.common.component
{
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import mx.controls.CheckBox;

	public class IlsCheckBox extends CheckBox implements IIlsControl
	{
        private var _value:String;
		
		public function IlsCheckBox()
		{
			super();
            addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownHandler);			
		}
		
	    private function onMouseDownHandler(event:MouseEvent):void
	    {
			event.stopPropagation();    	
	    }

		public function clearMe():void
		{
			this.value="0";	
		}
		
		public function lock(isLock:Boolean):void
		{
			this.enabled = !isLock;
		}
		
		public function set value(value:String):void{
            _value = value;
            selected = (value == "1") ? true : false;
			dispatchEvent(new Event("valueChanged"));                
		}

		[Bindable(event="valueChanged")]
		public function get value():String{				
            return _value;
		}

        override protected function clickHandler(event:MouseEvent):void{
            super.clickHandler(event);
            value = selected ? "1" : "0";                
        }

	}
}