package cls.com.ils.common.component
{
	import flash.events.FocusEvent;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	
	import mx.controls.ComboBox;
	import mx.events.ValidationResultEvent;
	import mx.validators.Validator;

	public class IlsComboBox extends ComboBox implements IIlsControl,ITranslation
	{
		private var _validator:Validator;

		public function IlsComboBox()
		{
			super();
            addEventListener(FocusEvent.KEY_FOCUS_CHANGE, onKeyFocusChangeHandler);
            addEventListener(FocusEvent.MOUSE_FOCUS_CHANGE, mouseFocusChangeHandler);
            addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);			
		}
		
	    private function onKeyFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }

	    private function mouseFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }
	    
	    private function mouseDownHandler(event:MouseEvent):void
	    {
			event.stopPropagation();    	
	    }

		public function get validator():Validator
		{
			return _validator;
		}
		
		public function set validator(value:Validator):void
		{
			_validator = value;
		}

		public function clearMe():void
		{
//			this.text="";	
			this.selectedIndex = 0;
		}
		
		public function lock(isLock:Boolean):void
		{
			this.enabled = !isLock;
		}

		public function get isTranslation():Boolean
		{
			//TODO: implement function
			return false;
		}
		
		public function set isTranslation(value:Boolean):void
		{
			//TODO: implement function
		}
		
		public function get translationTarget():Object
		{
			//TODO: implement function
			return null;
		}
		
		public function set translationTarget(value:Object):void
		{
			//TODO: implement function
		}
		
		public function get translationLookUp():Object
		{
			//TODO: implement function
			return null;
		}
		
		public function set translationLookUp(value:Object):void
		{
			//TODO: implement function
		}
		
		public function get transRet():Boolean
		{
			//TODO: implement function
			return false;
		}
		
		public function set transRet(value:Boolean):void
		{
			//TODO: implement function
		}
		
		public function get isEofOK():Boolean
		{
			//TODO: implement function
			return false;
		}
		
		public function set isEofOK(value:Boolean):void
		{
			//TODO: implement function
		}
		
		public function readDataSet():Boolean
		{
			//TODO: implement function
			return false;
		}
		
	}
}