package cls.com.ils.common.component
{
	import flash.display.InteractiveObject;
	import flash.events.FocusEvent;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	
	import mx.containers.Panel;
	import mx.core.UIComponent;

	public class IlsPanel extends Panel implements IIlsContainer
	{
		/**
		 *　親画面からわたされるパラメータを格納した配列 
		 */		
		public var parentParams:Array;
		
		/**
		 * 親画面操作用に親画面への参照を格納するメソッド 
		 */		
		public var parentDisplay:Object;
		
		/**
		 * エラー状態管理フラグ
		 * エラー画面を複数回出さないように制御する 
		 */		
		protected var errState:Boolean = false;
		
		/**
		 * 検索時にフォーカス設定を行うオブジェクト 
		 */		
		public var srchFcsObject:Object = null;
		
		/**
		 * オープンステータス 
		 */		
		public var openStats:Boolean = false;
		
		/**
		 * ビジーモード
		 *  
		 */		
		protected var _busyMode:Boolean = true;
		
		
		public var boxHead:UIComponent;
		public var boxBody:UIComponent;

// コンストラクタ		
		/**
		 * パネルの初期設定 
		 * 
		 */		
		public function IlsPanel()
		{
			super();
            addEventListener(KeyboardEvent.KEY_DOWN, keyDownChangeHandler);
		}
		
		public function clearCtrl():void
		{
			//TODO: implement function
		}
		
		public function lockCtrl(isLock:Boolean):void
		{
			//TODO: implement function
		}

		/**
		 * ヘッダー上のコントロールを初期化します。
		 * 
		 */		
	    public function clearHead():void{	    	
			if (boxHead){

				if(boxHead is IIlsContainer){
	            	IIlsContainer(boxHead).clearCtrl();
				}
			}
		}
        	        			
		/**
		 * ヘッダー上のコントロールのロックを制御。
		 * 
		 */		
	    public function lockHead(isLock:Boolean):void{	    	
			if (boxHead){
				if(boxHead is IIlsContainer){
	            	IIlsContainer(boxHead).lockCtrl(isLock);
				}
			}
		}

		/**
		 * ボディー上のコントロールを初期化します。
		 * 
		 */		
	    public function clearBody():void{	    	
			if (boxBody){
				if(boxBody is IIlsContainer){
	            	IIlsContainer(boxBody).clearCtrl();
				}
			}
		}

		/**
		 * ボディー上のコントロールのロックを制御。
		 * 
		 */		
	    public function lockBody(isLock:Boolean):void{	    	
			if (boxBody){
				if(boxBody is IIlsContainer){
	            	IIlsContainer(boxBody).lockCtrl(isLock);
				}
			}
		}

		// keyDown event handler.
		private function keyDownChangeHandler(event:KeyboardEvent):void
		{
			if(event.target is IlsButton && !event.shiftKey){
			}else{
                //Enterキーに対するイベントの場合
                if(event.keyCode == Keyboard.ENTER)
                {
                    //イベントの発生元のオブジェクトがInteractiveObjectの場合
                    if(event.target.parent is InteractiveObject)
                    {
                    	var interactiveObject:InteractiveObject;
	                	var focusEvent:FocusEvent = new FocusEvent(FocusEvent.KEY_FOCUS_CHANGE, true, true, null, event.shiftKey, Keyboard.TAB);
						if(event.target is IlsComboBox){
		                    //イベントの発生元のオブジェクトがTsComboBoxの場合
	                        interactiveObject = event.target as InteractiveObject;
						}else{
	                        //イベントの発生元のオブジェクトを取得して、InteractiveObjectにキャスト
	                        interactiveObject = event.target.parent as InteractiveObject;
						}
                        interactiveObject.dispatchEvent(focusEvent);
					}
                }
			}
		}		
		
	}
}