package cls.com.ils.common.component
{
	import flash.events.FocusEvent;
	import flash.events.MouseEvent;
	
	import mx.controls.TextArea;
	import mx.events.ValidationResultEvent;
	import mx.validators.Validator;

	public class IlsTextArea extends TextArea implements IIlsControl
	{
		private var _validator:Validator;

		public function IlsTextArea()
		{
			super();
            addEventListener(FocusEvent.KEY_FOCUS_CHANGE, keyFocusChangeHandler);
            addEventListener(FocusEvent.MOUSE_FOCUS_CHANGE, mouseFocusChangeHandler);
            addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
		}
		
	    private function keyFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator && validator.enabled)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }

	    private function mouseFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator && validator.enabled)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }
	    
	    private function mouseDownHandler(event:MouseEvent):void
	    {
			event.stopPropagation();    	
	    }

		public function get validator():Validator
		{
			return _validator;
		}
		
		public function set validator(value:Validator):void
		{
			_validator = value;
		}

		/**
		 *  項目を初期化する
		 * 
		 */		
		public function clearMe():void
		{
			this.text = "";
			this.errorString = "";
		}
		
		/**
		 *  コントロールを入力不可にする
		 * @param isLock　True:ロックする、False:ロック解除
		 * 
		 */		
		public function lock(isLock:Boolean):void
		{
			this.enabled = !isLock;
		}
		
	}
}