package cls.com.ils.common.component
{
	import flash.events.FocusEvent;
	import flash.events.MouseEvent;
	import flash.system.IME;
	
	import mx.controls.TextInput;
	import mx.events.FlexEvent;
	import mx.events.ValidationResultEvent;
	import mx.validators.Validator;

	public class IlsTextInput extends TextInput implements IIlsControl,ITranslation
	{
		// IMEの拡張プロパティ
		private var _imeModeEx:String;
		//ズーム設定
		private var _isZoom:Boolean;
		//ズーム起動クラス
		private var _zoomObj:Class;
		//翻訳設定
		private var _isTranslation:Boolean;
		//翻訳機能を使用する際の結果を設定するコントロール
		private var _translationTarget:Object;
		//翻訳時使用プログラム名
		private var _translationLookUp:Object;
		//翻訳結果
		private var _transRet:Boolean;
		//翻訳結果のEOFの許可
		private var _isEofOK:Boolean;
		
		private var _validator:Validator;
		
		private var _invalid:Boolean;

		public function IlsTextInput()
		{
			super();
            addEventListener(FocusEvent.KEY_FOCUS_CHANGE, keyFocusChangeHandler);
            addEventListener(FocusEvent.MOUSE_FOCUS_CHANGE, mouseFocusChangeHandler);
            addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
		}
		
	    private function keyFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator && validator.enabled)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }

	    private function mouseFocusChangeHandler(event:FocusEvent):void
	    {
	    	if(validator && validator.enabled)
	    	{
	    		if(validator.validate().type == ValidationResultEvent.INVALID)
	    		{
	            	event.preventDefault();
       			}
	    	}
	    }
	    
	    private function mouseDownHandler(event:MouseEvent):void
	    {
			event.stopPropagation();    	
	    }

		public function get validator():Validator
		{
			return _validator;
		}
		
		public function set validator(value:Validator):void
		{
			_validator = value;
		}

		public function get isZoom():Boolean
		{
			return _isZoom;
		}
		
		public function set isZoom(value:Boolean):void
		{
			_isZoom = value;
		}

		public function get zoomObj():Class
		{
			return _zoomObj;
		}
		
		public function set zoomObj(value:Class):void
		{
			_zoomObj = value;
		}

		public function get isTranslation():Boolean
		{
			return _isTranslation;
		}
		
		public function set isTranslation(value:Boolean):void
		{
			_isTranslation = value;
		}
		
		public function get translationTarget():Object
		{
			return _translationTarget;
		}
		
		public function set translationTarget(value:Object):void
		{
			_translationTarget = value;
		}
		
		public function get translationLookUp():Object
		{
			return _translationLookUp;
		}
		
		public function set translationLookUp(value:Object):void
		{
			_translationLookUp = value;
		}
		
		/**
		 * 翻訳結果取得
		 * 
		 * */
		public function get transRet():Boolean
		{
			return _transRet;
		}
		
		/**
		 * 翻訳結果設定
		 * 
		 * */
		public function set transRet(value:Boolean):void
		{
            _transRet = value;
		}

	    /**
	     *  翻訳結果のEOFの許可
	     * 
	     */
	    public function get isEofOK():Boolean
	    {
			return _isEofOK;
	    }
	    
	    /**
	     *  翻訳結果のEOFの許可
		 * @param value　True:検索結果が無くても成功、False:検索結果が無ければ失敗
		 * 
	     */
	    public function set isEofOK(value:Boolean):void
	    {
            _isEofOK = value;
	    }

	    /**
	     *  検索処理
	     */
	    public function readDataSet():Boolean
	    {
	    	return false;	
	    }

		/**
		 * imeモード設定(IME OFFのために拡張)
		 * value:設定するIME IMEConversionMode or "off"
		 * 
		 * */
		public function set imeModeEx(value:String):void{

			if(value == "off"){
				this.addEventListener(FocusEvent.FOCUS_IN,onFocusIn);
				this.addEventListener(FocusEvent.FOCUS_OUT,onFocusOut);
//				this.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
				
			}else if(value == "Numeric"){

				this.addEventListener(FocusEvent.FOCUS_IN,onFocusIn);
				this.addEventListener(FocusEvent.FOCUS_OUT,onFocusOut);
//				this.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
				// 数字のみしか入らなくする
				this.restrict = "0-9./\\-";	
			}else{
				
//				this.removeEventListener(FocusEvent.FOCUS_IN,onFocusIn);
//				this.removeEventListener(FocusEvent.FOCUS_OUT,onFocusOut);
//				this.removeEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);

				this.imeMode = value;
		
			}
		}
		
		// IME off 設定用
		private function onFocusIn(e:FocusEvent):void{
			IME.enabled = false;
		}
		// IME off 設定用
		private function onFocusOut(e:FocusEvent):void{
			IME.enabled = true;
		}
//		// IME off 設定用
//		private function onKeyDown(e:KeyboardEvent):void{
//			IME.enabled = false;
//		}		
		
		/**
		 *  項目を初期化する
		 * 
		 */		
		public function clearMe():void
		{
			this.text = "";
			this.errorString = "";
			this.transRet = true;
		}
		
		/**
		 *  コントロールを入力不可にする
		 * @param isLock　True:ロックする、False:ロック解除
		 * 
		 */		
		public function lock(isLock:Boolean):void
		{
			this.enabled = !isLock;
		}
		
	}
}