package cls.com.ils.common.ctrl
{
	/**
	 * 登録コントローラ利用用インタフェース 
	 * @author furoi
	 * 
	 */	
	public interface ISharedRegist extends ISharedCtrl
	{
		/**
		 * 登録OK時処理用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRegiOkResponse(cd : String, message : String) : void;
		
		/**
		 * 登録Ok（メッセージ付き）用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRegiOkMsgResponse(cd : String, message : String) : void;
		
		/**
		 * 登録OK（警告メッセージ付き）用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRegiAlertResponse(cd : String, message : String) : void;
		
		/**
		 * 項目レベルエラー時用抽象メソッド
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRegiItemErrResponse(cd : String, message : String) : void;
		
		/**
		 * 排他エラー時用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRegiHaitaResponse(cd : String, message : String) : void;
		
		/**
		 * 業務エラー時用抽象メソッド 
		 * @param cd
		 * @param message
		 * 
		 */		
		function getRegiAppErrResponse(cd : String, message : String, kbn : String) : void;
		
		
	}
}