package cls.com.ils.common.model
{
	import mx.controls.Alert;
	import flash.display.Sprite;	
	
	/**
	 * eShift用メッセージ表示クラスです。
	 * eShiftでオペレーターにメッセージを通知する必要がある場合、
	 * このクラスのdispMsgを利用してメッセージ表示を行ってください。 
	 * @author furoi
	 * 
	 */	
	public class MsgMgr
	{
		
		
		/**
		 * ブラウザ側で管理するメッセージを定義しておく配列
		 * 1：メッセージコード 2:メッセージ 
		 */		
		public static var msgAry:Array;
		
		public function MsgMgr()
		{
			//TODO: implement function
			
		}
		
		/**
		 * メッセージ表示メソッド
		 * @param cd
		 * @param title タイトル 
		 */		
		public static function dispMsg(cd:String,title:String,...params):void{
			
			var dispBaseMsg:String;
			var dipMsg:String;
			var loopIndex:int;
			
			dispBaseMsg = getBaseMsg(cd);
			dipMsg = dispBaseMsg;
			
			if(params.length == 0){
			}else{
				for(loopIndex=0;loopIndex<params.length;loopIndex++){
					dipMsg = dipMsg.replace("{%" + String(loopIndex+1) + "}",params[loopIndex]);	
				}				
			}
			
			dispServerMsg(cd,dipMsg,title);
			
		}
		
		/**
		 * メッセージ表示メソッド
		 * 主にサーバーからメッセージコード＆メッセージ内容を取得する場合に
		 * 利用する。
		 * @param cd メッセージコード
		 * @param msg メッセージ
		 * @param title タイトル
  		 * 
		 */		
		public static function dispServerMsg(cd:String,msg:String,title:String,parent:Sprite = null):void{
			//Alert.show(cd + ":" + msg,title);			
			var msgAlert:Alert;
			msgAlert=Alert.show(msg,title,Alert.OK,parent);
		}
		
		/**
		 * サーバー操作メッセージ表示メソッド。画面を閉じる場合、このメソッドで指定したメソッドで
		 * クローズ処理する必要がある。
		 * @param cd メッセージコード
		 * @param msg メッセージ
		 * @param title タイトル
		 * @param dispBtn 表示ボタン
		 * @param fnc 関数
		 * 
		 */		
		public static function dispServerMsgAndCallEvent(cd:String,msg:String,title:String,dispBtn:int,fnc:Function,parent:Sprite = null):void{
			//Alert.show(cd + ":" + msg,title,dispBtn,null,fnc);
			var msgAlert:Alert;
			msgAlert=Alert.show(msg,title,dispBtn,parent,fnc);
		}
		
		/**
		 * メッセージ表示メソッド。画面を閉じる場合、このメソッドで指定したメソッドで
		 * クローズ処理する必要がある。
		 * <p> 関数の引数にCloseEventを付ければ、どのボタンを選択したか設定した関数で判断できます。 </p>
		 * @param cd メッセージコード
		 * @param title タイトル
		 * @param dispBtn 表示ボタン
		 * @param fnc 関数
		 * 
		 */		
		public static function dispMsgAndCallEvent(cd:String,title:String,dispBtn:int,fnc:Function,...params):void{
			
			var dispBaseMsg:String;
			var dipMsg:String;
			var loopIndex:int;
			
			dispBaseMsg = getBaseMsg(cd);
			dipMsg = dispBaseMsg;
			
			if(params.length == 0){
			}else{
				for(loopIndex=0;loopIndex<params.length;loopIndex++){
					dipMsg = dipMsg.replace("{%" + String(loopIndex+1) + "}",params[loopIndex]);	
				}				
			}
			
			dispServerMsgAndCallEvent(cd,dipMsg,title,dispBtn,fnc);
			
		}
		
		/**
		 * ブラウザ管理メッセージを対象とし、メッセージコードより
		 * メッセージを取得する。 
		 * @param cd メッセージコード
		 * @return メッセージ
		 * 
		 */		
		public static function getBaseMsg(cd:String):String{
			
			var roopIndex:int;
			var msg:String = "";
			
			for(roopIndex=0;roopIndex<msgAry.length;roopIndex++){
				if(msgAry[roopIndex][0] == cd){
					msg = msgAry[roopIndex][1] as String;	
				}
			}
			
			if(msg==""){
				msg = "存在しないメッセージコードが渡されました。";
			}	
			return msg;
		}

		/**
		 * メッセジ取得処理 
		 * @param cd メッセージコード
		 * @param params メッセージパラメータ
		 * @return 取得したメッセージ
		 * 
		 */		
		public static function getMsg(cd:String,...params):String{

			var dispBaseMsg:String;
			var dipMsg:String;
			var loopIndex:int;
			
			dispBaseMsg = getBaseMsg(cd);
			dipMsg = dispBaseMsg;
			
			if(params.length == 0){
			}else{
				for(loopIndex=0;loopIndex<params.length;loopIndex++){
					dipMsg = dipMsg.replace("{%" + String(loopIndex+1) + "}",params[loopIndex]);	
				}				
			}
			
			return dipMsg;
		}

	}
}