package cls.com.ils.common.utility.net
{
	import cls.com.ils.common.utility.logging.IlsLoggingTool;
	
	import flash.external.ExternalInterface;
	
	public class MagicAjax
	{
		//アプリケーション名
		private var _appname:String;
		//公開プログラム名
		private var _prgname:String;
		// パラメータ文字列
		private var _argString:String;
		// argument 区切り文字列
		private var paramSepString:String;
		private var paramSepStringAfter:String;

		private var _url:String = "";
		private var _param:String = "";
		private var _async:Boolean=false;
		private var _responseText:XML;
		private var _requestType:AjaxRequestType;
		
		public function MagicAjax()
		{
			// パラメータを一つずつ指定してのリクエストで利用する
			paramSepString = "-A";
			paramSepStringAfter = ",";
		
			// 引数文字列保管用文字列の初期化	
			_argString = "";
		}

		public function get url():String
		{
		    return _url;
		}
		
		/**
		 *  @private
		 */
		public function set url(value:String):void
		{
		    _url = value;
		}
		
		public function get param():String
		{
		    return _param;
		}
		
		/**
		 *  @private
		 */
		public function set param(value:String):void
		{
		    _param = value;
		}

		public function get async():Boolean
		{
			return this._async;
		}
		
  		public function set async(value:Boolean):void
  		{
        	this._async = value;
   		}
   		
  		public function get responseText():XML
  		{
  			return this._responseText;
  		}
  		
  		public function get requestType():AjaxRequestType
  		{
   			return this._requestType;
  		}
  		
  		public function set requestType(value:AjaxRequestType):void
  		{
  			this._requestType = value;
  		}
    
  		public function send(data:String=null):XML
  		{
	  		var sendingData:String = sendingData(data);
	  		this._responseText = XML(ExternalInterface.call(sendingData));
	  		return this._responseText;
  		}
  		
    	private function sendingData(data:String=null):String
  		{
   			if(ExternalInterface.available)
   			{     
   				var data:String = "function()" +
								"{" +
                        			"var xmlHttp;"+
                                    "try" +
                                  	"{" +
                                  		" xmlHttp = new ActiveXObject('Msxml2.XMLHTTP');" +
									"}"+
									"catch(e)" +
									"{" +
										"try" +
										"{" +
 											"xmlHttp=new ActiveXObject('Microsoft.XMLHTTP');" +
										"}" +
										"catch(oc)" +
										"{" +
											"xmlHttp=null;" +
										"}" +
									"}" +
									"if(!xmlHttp && typeof XMLHttpRequest != 'undefined')" +
									"{" +
										"xmlHttp=new XMLHttpRequest();" +
									"}"+
									"try" +
									"{" +
										"xmlHttp.open('"+ requestType.toString() + "','" + _url + _param + "'," + async + ");"+
           								"xmlHttp.send("+ data + ");"+
           								"return xmlHttp.responseText;" +
       								"}"+
       								"catch(x){alert(x)}" +
   								"}";
   								return data;
			}else
		   	{
				throw new Error("This browser is not supported.");
			}
		} 

		/**
		 * Magicアプリケーション名を指定する
		 * @param appname アプリケーション名
		 * 
		 */
		protected function set appname(appname:String):void{
			// APPNAMEは動的プロパティ
			_appname = appname;
		}
		
		/**
		 * Magicの公開プログラム名を指定する 
		 * @param prgname 公開プログラム名
		 * 
		 */
		public function set prgname(prgname:String):void{
			// PRGNAMEは動的プロパティ
			_prgname = prgname;	
		}
	

		/**
		 * パラメータの追加処理
		 * @param param パラメータ
		 * 
		 */		
		public function addParam(param:String):void{
			if(_argString.length == 0){
				// 一つ目のパラメータ用
				_argString = _argString + paramSepString + param;	
			}else{
				// 一つ目のパラメータでない場合、カンマで区切る
				_argString = _argString + paramSepStringAfter + paramSepString + param;
			}
		}

		/**
		 * リクエスト送信メソッド 
		 * 
		 */		
		public function sendRequest():XML{
			
			var response:XML;
			// パラメータ文字列へArgumentパラメータを追加 
			this.param = "?APPNAME=" + _appname + "&PRGNAME=" + _prgname + "&ARGUMENTS=" + _argString
			
			IlsLoggingTool.logger.debug("url:{0}",url);
			IlsLoggingTool.logger.debug("param:{0}",param);

			// リクエスト発行
			response = this.send();

			return response;

		}

	}
}