package commonLibrary.sharedFormatters
{
	import mx.formatters.DateFormatter;

	public class TsDateFormatter extends DateFormatter
	{
		private var weekDayLabels:Array = new Array("日","月","火","水","木","金","土");

		public function TsDateFormatter()
		{
			super();
		}
		
		//----------------------------------
		//  useYobi
		//----------------------------------
	    /**
		 *  @private
		 *  曜日表示（日本語）
		 */
		private var _useYobi:Object;
		
	    /**
		 *  @private
		 */
		private var useYobiOverride:Object;
		
	    [Inspectable(category="General", defaultValue="null")]
	
	    /**
	     *  true：曜日表示あり 
		 *  false：曜日表なし
		 *
	     *  @default false
	     */
		public function get useYobi():Object
		{
			return _useYobi;
		}
	
		/**
		 *  @private
		 */
		public function set useYobi(value:Object):void
		{
			useYobiOverride = value;
	
			_useYobi = value != null ?
							   Boolean(value)  : false;
		}

		//----------------------------------
		//  kaigyoFlg
		//----------------------------------
	
	    /**
		 *  @private
		 *  改行フラグ（曜日を改行する）
		 */
		private var _kaigyoFlg:Object;
		
	    /**
		 *  @private
		 */
		private var kaigyoFlgOverride:Object;
		
	    [Inspectable(category="General", defaultValue="null")]
	
	    /**
	     *  true：改行あり 
		 *  false：改行なし
		 *
	     *  @default false
	     */
		public function get kaigyoFlg():Object
		{
			return _kaigyoFlg;
		}
	
		/**
		 *  @private
		 */
		public function set kaigyoFlg(value:Object):void
		{
			kaigyoFlgOverride = value;
	
			_kaigyoFlg = value != null ?
							   Boolean(value)  : false;
		}

		/**
		 *  @private
		 */
		override protected function resourcesChanged():void
		{
			super.resourcesChanged();
	
			useYobi = useYobiOverride;
		}
		
	    override public function format(value:Object):String
	    {
	    	var dateStr:String;

	        if (!value || value == "")
	        {
	            return "";
	        }
	
	        // -- value --	
	        if (value is String)
	        {
				var len:int = String(value).length;
				var yearString:String = String(value).substr(0,4);
				var monthString:String = String(value).substr(4,2);
				var hiString:String = String(value).substr(6,2);

	            value = DateFormatter.parseDateString(String(value));
	            if (!value)
	            {
					if(len==8){						
						// 月は0から始まるため -1する
						value = new Date(Number(yearString),Number(monthString) - 1,Number(hiString));
					}else{
		                error = defaultInvalidValueError;
		                return "";
					}
	            }
	        }
	        else if (!(value is Date))
	        {
	            error = defaultInvalidValueError;
	            return "";
	        }
	
	        // -- format --
	        if(useYobi){
	        	if(kaigyoFlg){
	        		dateStr = super.format(value)+"\n"+weekDayLabels[value.getDay()];
	        	}else{
			        dateStr = super.format(value)+weekDayLabels[value.getDay()];
	        	}
	        }else{
		        dateStr = super.format(value);
	        }

	        return dateStr;
	    	
	    }       

		public function parseDate(valueString:String, inputFormat:String):Date
		{
			var newDate:Date;
			
			if(valueString != "" && (valueString.length == 8 || valueString.length == 10)){
				newDate = new Date(format(valueString));
			}
			return newDate;
		}

	}
}