package commonLibrary.sharedValidators
{
	import cls.com.ils.common.model.MsgMgr;
	
	import mx.events.ValidationResultEvent;
	import mx.validators.DateValidator;

	public class DateValidator extends mx.validators.DateValidator
	{
		public function DateValidator()
		{
			super();
			// 初期化処理
			initErrMsg();
		}

		// エラーメッセージの為の初期処理
		private function initErrMsg():void {
			//値が欠損し、required プロパティが true の場合
			requiredFieldError = MsgMgr.getMsg("W006");

			//inputFormat プロパティが正しい形式でないとき
			formatError = "";		
			
			//無効な文字が日付に存在するとき	
			invalidCharError = "";
			
			//日が無効なとき
			wrongDayError = "";
			
			//日付の長さが inputFormat プロパティの長さと一致しないとき
			wrongLengthError = "";
			
			//月が無効なとき
			wrongMonthError = "";
			
			//年が無効なとき
			wrongYearError = "";
			
		}

	    //----------------------------------
	    //  field
	    //----------------------------------    
	    
	    /**
	     *  @private
	     *  Storage for the property property.
	     */
	    private var _field:String;
	    
	    [Inspectable(category="General")]
	
	    /**
	     *  
	     *  @default null
	     */
	    public function get field():String
	    {
	        return _field;
	    }
	
	    /**
	     *  @private
	     */
	    public function set field(value:String):void
	    {
	        _field = value;
	    }

		override protected function handleResults(errorResults:Array):ValidationResultEvent
		{
	        var resultEvent:ValidationResultEvent;
	        
	        resultEvent = super.handleResults(errorResults);
	        if (_field){
		        resultEvent.field = _field;
	        }
	        
			return resultEvent;
		}
		
		override protected function doValidation(value:Object):Array
	    {
	    	if(value is XMLList){
	    		value = String(value);
	    	}
			var results:Array = super.doValidation(value);
			
	        return results;
	    }

	}
}