﻿Imports System
Imports System.IO
Imports System.Text
Imports System.Data.SqlClient
Imports jp.co.ricoh.ridoc.smartnavi
Imports jp.co.ricoh.ridoc.smartnavi.model

Public Class AccessToRidoc

    Protected m_ridocSystem As RsnSystem
    Protected m_ridocCabinet As RsnCabinet

    Protected Structure DOCSQLData
        Public nodeLevel As Integer
        Public nodeNo As Long
        Public parentNodeNo As Long
        Public folderFlg As String
        Public docNo As String
        Public docTitle As String
        Public docState As Integer
        Public ridocID As String
        Public hassinDate As String
        Public updateDate As DateTime
        Public limitDate As DateTime
        Public parentRidocID As String
    End Structure

    Protected Structure FILESQLData
        Public ridocID As String
        Public fileNo As Integer
        Public fileName As String
        Public filePath As String
    End Structure

    Public Structure ConnectInfo
        Public serverURL As String
        Public userName As String
        Public password As String
        Public domainName As String
    End Structure

    Protected arrDOCSQLData As ArrayList
    Protected arrFILESQLData As ArrayList
    Protected htDeleteData As Hashtable
    Protected htNodeNo As Hashtable
    Protected maxNodeNo As Long

    Protected arrSearchRidocID As ArrayList

    Public Sub New()
        m_ridocSystem = New RsnSystem()
        arrDOCSQLData = New ArrayList
        arrFILESQLData = New ArrayList
        arrSearchRidocID = New ArrayList
        htDeleteData = New Hashtable
        htNodeNo = New Hashtable
        maxNodeNo = 0
    End Sub
    Public Sub Dispose()
        Try
            If Not m_ridocCabinet Is Nothing Then
                m_ridocCabinet = Nothing
                m_ridocSystem.Disconnect()
            End If

            m_ridocSystem = Nothing

            arrDOCSQLData.Clear()
            arrFILESQLData.Clear()
            arrSearchRidocID.Clear()
            htDeleteData.Clear()
            htNodeNo.Clear()
            maxNodeNo = 0

            arrDOCSQLData = Nothing
            arrFILESQLData = Nothing
            arrSearchRidocID = Nothing
            htDeleteData = Nothing
            htNodeNo = Nothing

        Catch ex As Exception

        End Try

    End Sub

    Public Function GetConnectInfo(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String, ByRef conInfo As ConnectInfo) As Integer

        Dim ret As Integer = 0


        Dim con As SqlConnection = Nothing
        Dim sqlCommand As SqlCommand = Nothing
        Dim dataReader As SqlDataReader = Nothing


        Dim conStr As String

        Dim updateDateTime As DateTime = DateTime.Now

        Try

            If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
            End If

            If Not Directory.Exists(logDirectory) Then
                Directory.CreateDirectory(logDirectory)
            End If

            conStr = ""
            conStr += "Data Source=" + server + ";"
            conStr += "User ID=" + userId + ";"
            conStr += "Password=" + password + ";"
            conStr += "Initial Catalog=" + databaseName + ""

            con = New SqlConnection()
            con.ConnectionString = conStr

            con.Open()

            sqlCommand = con.CreateCommand()

            Dim selectSQL As String = ""
            selectSQL += " SELECT RidocサーバURL,RidocユーザID,Ridocパスワード,Ridocドメイン  FROM M_DOC_RIDOC_CTL "

            sqlLogWrite(selectSQL, logDirectory + "\selectSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + ".SQL")
            sqlCommand.CommandText = selectSQL

            dataReader = sqlCommand.ExecuteReader()
            If dataReader.Read() Then
                conInfo.serverURL = CStr(dataReader("RidocサーバURL")).Trim()
                conInfo.userName = CStr(dataReader("RidocユーザID")).Trim()
                conInfo.password = CStr(dataReader("Ridocパスワード")).Trim()
                conInfo.domainName = CStr(dataReader("Ridocドメイン")).Trim()
            Else
                ret = 5
            End If

        Catch ex As Exception
            ret = 5
        Finally
            If Not dataReader Is Nothing Then
                dataReader.Close()
            End If

            If Not sqlCommand Is Nothing Then
                sqlCommand.Dispose()
            End If

            If Not con Is Nothing Then
                If Not con.State = ConnectionState.Closed Then
                    con.Close()
                End If
                con.Dispose()
            End If

        End Try
        Return ret
    End Function

    Public Function GetDocAndUpdateSQLServer(ByVal serverUrl As String, ByVal userName As String, ByVal passWord As String, ByVal domainName As String, ByVal saveDirectory As String, ByVal sqlServer As String, ByVal sqlUser As String, ByVal sqlPassword As String, ByVal sqlDatabaseName As String, ByVal ridocID As String, ByVal nodeLevel As Integer, ByVal nodeNo As Long, ByVal logDirectory As String, ByVal onlyFolder As Boolean) As Integer
        If Not m_ridocSystem Is Nothing Then
            Try
                If m_ridocCabinet Is Nothing Then
                    Me.Connect(serverUrl, userName, passWord, domainName)
                End If
            Catch ex As Exception
                Return 2
            End Try

            arrDOCSQLData.Clear()
            arrFILESQLData.Clear()
            htDeleteData.Clear()
            htNodeNo.Clear()
            maxNodeNo = 0

            Try
                Dim analizeFolder As RsnFolder = Nothing
                Dim analizeNodeLevel As Integer = 0
                Dim analizeNodeNo As Long = 1

                If Not ridocID.Trim() = "" Then
                    analizeFolder = m_ridocSystem.GetFolder(ridocID)
                    If Not analizeFolder Is Nothing Then
                        analizeNodeLevel = nodeLevel
                        analizeNodeNo = nodeNo
                    End If
                Else

                    Dim folderSqlData As DOCSQLData

                    folderSqlData.nodeLevel = 0
                    folderSqlData.nodeNo = maxNodeNo + 1
                    folderSqlData.parentNodeNo = 0
                    folderSqlData.folderFlg = "1"
                    folderSqlData.docNo = "キャビネット"
                    folderSqlData.docTitle = ""
                    folderSqlData.ridocID = "Cabinet"
                    folderSqlData.docState = 1
                    folderSqlData.hassinDate = ""
                    folderSqlData.updateDate = Nothing
                    folderSqlData.limitDate = Nothing
                    folderSqlData.parentRidocID = ""

                    arrDOCSQLData.Add(folderSqlData)

                    maxNodeNo = maxNodeNo + 1

                    Dim hashKey As String = folderSqlData.parentRidocID
                    If Not htDeleteData.ContainsKey(hashKey) Then
                        htDeleteData.Add(hashKey, "")
                    End If

                End If
                Me.AnalizeFolder(analizeFolder, analizeNodeLevel, analizeNodeNo, onlyFolder)

            Catch ex As Exception
                Return 4
            End Try

            Try

                Dim ret As Boolean
                ret = updateSQLServerForGetDoc(sqlServer, sqlUser, sqlPassword, sqlDatabaseName, logDirectory)
                If Not ret Then
                    Return 5
                End If
            Catch ex As Exception
                Return 5
            End Try

        Else
            Return 999
        End If

        Return 0
    End Function

    Public Function GetPDFFile(ByVal serverUrl As String, ByVal userName As String, ByVal passWord As String, ByVal domainName As String, ByVal saveDirectory As String, ByVal sqlServer As String, ByVal sqlUser As String, ByVal sqlPassword As String, ByVal sqlDatabaseName As String, ByVal ridocID As String, ByVal logDirectory As String, ByVal sessionID As String, ByVal bFileCopy As Boolean) As Integer


        If Not m_ridocSystem Is Nothing Then
            Try
                If m_ridocCabinet Is Nothing Then
                    Me.Connect(serverUrl, userName, passWord, domainName)
                End If
            Catch ex As Exception
                Return 2
            End Try

            If bFileCopy Then
                Try
                    If saveDirectory.Substring(saveDirectory.Length - 1) = "\" Then
                        saveDirectory = saveDirectory.Substring(0, saveDirectory.Length - 1)
                    End If

                    If Not Directory.Exists(saveDirectory) Then
                        Directory.CreateDirectory(saveDirectory)
                    End If
                Catch ex As Exception
                    Return 3
                End Try
            End If

            Dim document As RsnDocument = Nothing
            Dim sectionList As List(Of RsnSection) = Nothing
            Dim nowDateTime As DateTime = DateTime.Now

            Try
                document = m_ridocSystem.GetDocument(ridocID)
                sectionList = document.GetSectionList()
                Dim fileNo As Integer = 1
                For Each section As RsnSection In sectionList
                    Dim fileSqlData As FILESQLData

                    If section.existPDF = True Then
                        fileSqlData.ridocID = ridocID
                        fileSqlData.fileName = CStr(section.name).Trim() + "_" + nowDateTime.ToString("yyyyMMddHHmmss") + ".pdf"
                        fileSqlData.fileNo = fileNo
                        If bFileCopy Then
                            fileSqlData.filePath = saveDirectory.Trim() + "\" + fileSqlData.fileName

                            Dim fileStream As Stream = New FileStream(fileSqlData.filePath, FileMode.Create, FileAccess.Write)
                            document.ReadSectionData(section.sectionNo, RsnDocument.OPTION_PDF, fileStream)
                            fileStream.Close()
                            fileStream.Dispose()
                            fileStream = Nothing
                        Else
                            fileSqlData.filePath = " "
                        End If

                        arrFILESQLData.Add(fileSqlData)
                        fileNo += 1
                    End If
                Next

            Catch ex As Exception
                Return 4
            End Try

            Try
                Dim ret As Boolean
                ret = updateSQLServerForPDF(sqlServer, sqlUser, sqlPassword, sqlDatabaseName, logDirectory, sessionID)
                If Not ret Then
                    Return 5
                End If
            Catch ex As Exception
                Return 5
            End Try

        Else
            Return 999
        End If
        Return 0
    End Function

    Public Function GetSearchedDocAndUpdateSQLServer(ByVal serverUrl As String, ByVal userName As String, ByVal passWord As String, ByVal domainName As String, ByVal saveDirectory As String, ByVal sqlServer As String, ByVal sqlUser As String, ByVal sqlPassword As String, ByVal sqlDatabaseName As String, ByVal ridocID As String, ByVal nodeLevel As Integer, ByVal nodeNo As Long, ByVal logDirectory As String, ByVal searchWord As String, ByVal sessionID As String) As Integer
        If Not m_ridocSystem Is Nothing Then
            Try
                If m_ridocCabinet Is Nothing Then
                    Me.Connect(serverUrl, userName, passWord, domainName)
                End If
            Catch ex As Exception
                Return 2
            End Try

            arrSearchRidocID.Clear()

            Try
                Dim condition As RsnSearchCondition = New RsnSearchCondition()
                Dim separator As String() = {" AND "}
                Dim wordList As New List(Of String)(searchWord.Split(separator, StringSplitOptions.RemoveEmptyEntries))
                condition.keywords = wordList
                condition.searchDocument = True
                condition.searchFolder = False
                If Not ridocID.Trim() = "" Then
                    condition.rangeFolderId = ridocID
                Else
                    condition.rangeFolderId = Nothing
                End If

                condition.searchSubFolder = True
                condition.searchFullText = True

                condition.documentTypeId = Nothing

                Dim result As RsnSearchResultSet = Nothing
                result = m_ridocSystem.Search(condition)

                Dim documentCount As Long = result.GetDocumentCount()

                Dim documentList As List(Of RsnDocument) = result.GetDocumentList(0, CInt(documentCount))
                For Each document As RsnDocument In documentList
                    arrSearchRidocID.Add(CStr(document.GetPropertyValue("id")))
                Next
            Catch ex As Exception
                Return 4
            End Try

            Try

                Dim ret As Boolean
                ret = updateSQLServerForGetSearchDoc(sqlServer, sqlUser, sqlPassword, sqlDatabaseName, logDirectory, sessionID)
                If Not ret Then
                    Return 5
                End If
            Catch ex As Exception
                Return 5
            End Try

        Else
            Return 999
        End If

        Return 0
    End Function

    Protected Function Connect(ByVal serverUrl As String, ByVal userName As String, ByVal passWord As String, ByVal domainName As String) As Boolean
        Try
            If domainName = String.Empty Then
                m_ridocCabinet = m_ridocSystem.Connect(serverUrl, userName, passWord)
            Else
                m_ridocCabinet = m_ridocSystem.Connect(serverUrl, userName, passWord, domainName)
            End If
        Catch ex As Exception
            Return False
        End Try

        Return True

    End Function

    Protected Sub AnalizeFolder(ByVal parentFolder As RsnFolder, ByVal parentNodeLevel As Integer, ByVal parentNodeNo As Long, ByVal onlyFolder As Boolean)
        Dim folderList As List(Of RsnFolder) = Nothing
        Dim documentList As List(Of RsnDocument) = Nothing

        If Not parentFolder Is Nothing Then

            folderList = parentFolder.GetFolderList()
            documentList = parentFolder.GetDocumentList()
        Else
            folderList = m_ridocCabinet.GetFolderList()
            documentList = m_ridocCabinet.GetDocumentList()
        End If

        Dim nodeLevel As Integer = parentNodeLevel + 1
        Dim nodeNo As Long

        For Each folder As RsnFolder In folderList

            'If htNodeNo.ContainsKey(nodeLevel) Then
            '    nodeNo = CInt(htNodeNo(nodeLevel)) + 1
            '    htNodeNo(nodeLevel) = nodeNo
            'Else
            '    nodeNo = 1
            '    htNodeNo.Add(nodeLevel, nodeNo)
            'End If

            nodeNo = maxNodeNo + 1
            maxNodeNo = nodeNo

            Dim folderSqlData As DOCSQLData

            folderSqlData.nodeLevel = nodeLevel
            folderSqlData.nodeNo = nodeNo
            folderSqlData.parentNodeNo = parentNodeNo
            folderSqlData.folderFlg = "1"
            folderSqlData.docNo = CStr(folder.GetPropertyValue("name"))
            If Not folderSqlData.docNo = "" Then
                folderSqlData.docNo = folderSqlData.docNo.Replace("'", "''")
            End If
            folderSqlData.docTitle = ""
            folderSqlData.ridocID = CStr(folder.GetPropertyValue("id"))
            folderSqlData.docState = 1
            folderSqlData.hassinDate = ""
            folderSqlData.updateDate = Nothing
            folderSqlData.limitDate = Nothing
            folderSqlData.parentRidocID = CStr(folder.GetPropertyValue("parentId"))
            If folderSqlData.parentRidocID = "" Then
                folderSqlData.parentRidocID = "Cabinet"
            End If

            arrDOCSQLData.Add(folderSqlData)

            Dim hashKey As String = folderSqlData.parentRidocID
            If Not htDeleteData.ContainsKey(hashKey) Then
                htDeleteData.Add(hashKey, "")
            End If

            Me.AnalizeFolder(folder, nodeLevel, nodeNo, onlyFolder)

        Next

        If Not onlyFolder Then
            For Each document As RsnDocument In documentList
                Dim docSqlData As DOCSQLData
                Dim pdfFlg As Boolean = False
                Dim docStatus As Long

                Dim sectionList As List(Of RsnSection) = Nothing
                Try
                    sectionList = document.GetSectionList()
                    For Each section As RsnSection In sectionList
                        If section.existPDF = True Then
                            pdfFlg = True
                        End If
                    Next

                    docStatus = CLng(document.GetPropertyValue("status"))

                Catch ex As Exception
                    pdfFlg = False
                End Try

                If pdfFlg = True Then
                    'If htNodeNo.ContainsKey(nodeLevel) Then
                    '    nodeNo = CInt(htNodeNo(nodeLevel)) + 1
                    '    htNodeNo(nodeLevel) = nodeNo
                    'Else
                    '    nodeNo = 1
                    '    htNodeNo.Add(nodeLevel, nodeNo)
                    'End If

                    nodeNo = maxNodeNo + 1
                    maxNodeNo = nodeNo

                    docSqlData.nodeLevel = nodeLevel
                    docSqlData.nodeNo = nodeNo
                    docSqlData.parentNodeNo = parentNodeNo
                    docSqlData.folderFlg = "0"
                    docSqlData.docNo = CStr(document.GetPropertyValue("userString2"))
                    If Not docSqlData.docNo = "" Then
                        docSqlData.docNo = docSqlData.docNo.Replace("'", "''")
                    End If
                    docSqlData.docTitle = CStr(document.GetPropertyValue("name"))
                    If Not docSqlData.docTitle = "" Then
                        docSqlData.docTitle = docSqlData.docTitle.Replace("'", "''")
                    End If
                    docSqlData.ridocID = CStr(document.GetPropertyValue("id"))
                    If docStatus = RsnDocumentProperty.DOCUMENT_STATUS_COMPLETE Then
                        docSqlData.docState = 1
                    Else
                        docSqlData.docState = 0
                    End If

                    docSqlData.hassinDate = CStr(document.GetPropertyValue("userString1"))
                    docSqlData.updateDate = CType(document.GetPropertyValue("lastUpdateDate"), DateTime)
                    docSqlData.limitDate = CType(document.GetPropertyValue("retentionDate"), DateTime)

                    If Not parentFolder Is Nothing Then
                        docSqlData.parentRidocID = CStr(parentFolder.GetPropertyValue("id"))
                    Else
                        docSqlData.parentRidocID = "Cabinet"
                    End If

                    arrDOCSQLData.Add(docSqlData)

                    Dim hashKey As String = docSqlData.parentRidocID
                    If Not htDeleteData.ContainsKey(hashKey) Then
                        htDeleteData.Add(hashKey, "")
                    End If

                End If
            Next
        End If


    End Sub

    Protected Function updateSQLServerForGetDoc(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String) As Boolean

        Dim ret As Boolean = True

        If arrDOCSQLData.Count() > 0 Then

            Dim con As SqlConnection = Nothing
            Dim sqlCommand As SqlCommand = Nothing
            Dim tran As SqlTransaction = Nothing

            Dim conStr As String

            Dim updateDateTime As DateTime = DateTime.Now

            Try

                If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                    logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
                End If

                If Not Directory.Exists(logDirectory) Then
                    Directory.CreateDirectory(logDirectory)
                End If

                conStr = ""
                conStr += "Data Source=" + server + ";"
                conStr += "User ID=" + userId + ";"
                conStr += "Password=" + password + ";"
                conStr += "Initial Catalog=" + databaseName + ""

                con = New SqlConnection()
                con.ConnectionString = conStr

                con.Open()
                tran = con.BeginTransaction()

                sqlCommand = con.CreateCommand()
                sqlCommand.Transaction = tran
                sqlCommand.Prepare()

                Dim deleteSQL As String
                Dim syokaiFlg As Boolean = True
                Dim loopCounter As Integer = 1
                Dim updateCounter As Integer = 1
                deleteSQL = ""
                deleteSQL += " DELETE FROM T_DOC_RIDOC_RENKEI " + vbCrLf
                sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                sqlCommand.CommandText = deleteSQL
                sqlCommand.ExecuteNonQuery()
                'For Each deleteKey As String In htDeleteData.Keys()

                '    If syokaiFlg Then
                '        deleteSQL += " DELETE FROM T_DOC_RIDOC_RENKEI WHERE " + vbCrLf
                '        syokaiFlg = False
                '    Else
                '        deleteSQL += " OR "
                '    End If
                '    deleteSQL += " 親RidocID='" + deleteKey + "' " + vbCrLf

                '    loopCounter += 1

                '    If loopCounter > 100 Then
                '        loopCounter = 0

                '        sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                '        sqlCommand.CommandText = deleteSQL
                '        sqlCommand.ExecuteNonQuery()

                '        updateCounter += 1
                '        deleteSQL = ""
                '        syokaiFlg = True

                '    End If
                'Next

                'If Not deleteSQL = "" Then

                '    sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                '    sqlCommand.CommandText = deleteSQL
                '    sqlCommand.ExecuteNonQuery()
                'End If

                Dim insertSQL = ""
                loopCounter = 1
                updateCounter = 1
                syokaiFlg = True
                For Each sqlData As DOCSQLData In arrDOCSQLData
                    If syokaiFlg Then
                        insertSQL += " INSERT INTO T_DOC_RIDOC_RENKEI(ノードレベル,ノード番号,親ノード番号,フォルダ区分,文書記号,文書番号,文書記号番号,文章タイトル,RidocID,親RidocID,状態区分,発信日,Ridoc更新日付,Ridoc更新時刻,Ridoc保管期限日付,Ridoc保管期限時刻,作成日付,作成時刻,作成PGM,更新日付,更新時刻,更新PGM) VALUES " + vbCrLf
                        syokaiFlg = False
                    Else
                        insertSQL += " , " + vbCrLf
                    End If

                    insertSQL += " ( " + vbCrLf
                    insertSQL += "   " + sqlData.nodeLevel.ToString() + " , " + vbCrLf
                    insertSQL += "   " + sqlData.nodeNo.ToString() + " , " + vbCrLf
                    insertSQL += "   " + sqlData.parentNodeNo.ToString() + " , " + vbCrLf
                    insertSQL += "   '" + sqlData.folderFlg + "' , " + vbCrLf

                    Dim strHanDocNo As String = StrConv(sqlData.docNo, VbStrConv.Narrow).Trim()
                    If strHanDocNo.Length > 7 AndAlso sqlData.folderFlg = "0" Then
                        insertSQL += "   '" + strHanDocNo.Substring(0, strHanDocNo.Length - 7) + "' , " + vbCrLf
                        insertSQL += "   '" + strHanDocNo.Substring(strHanDocNo.Length - 7, 3) + strHanDocNo.Substring(strHanDocNo.Length - 3, 3) + "1' , " + vbCrLf
                    Else
                        insertSQL += "   '' , " + vbCrLf
                        insertSQL += "   '' , " + vbCrLf
                    End If

                    insertSQL += "   '" + sqlData.docNo + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.docTitle + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.ridocID + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.parentRidocID + "' , " + vbCrLf
                    insertSQL += "   " + CStr(sqlData.docState) + " , " + vbCrLf

                    Dim strHanHassinDate As String = StrConv(sqlData.hassinDate, VbStrConv.Narrow).Trim()
                    If sqlData.folderFlg = "0" Then
                        If strHanHassinDate.Length = 8 AndAlso IsNumeric(strHanHassinDate) Then
                            insertSQL += "   '" + strHanHassinDate + "' , " + vbCrLf
                        Else
                            insertSQL += "   '00000000' , " + vbCrLf
                        End If
                        insertSQL += "   '" + sqlData.updateDate.ToString("yyyyMMdd") + "' , " + vbCrLf
                        insertSQL += "   '" + sqlData.updateDate.ToString("HHmmss") + "' , " + vbCrLf
                        insertSQL += "   '" + sqlData.limitDate.ToString("yyyyMMdd") + "' , " + vbCrLf
                        insertSQL += "   '" + sqlData.limitDate.ToString("HHmmss") + "' , " + vbCrLf
                    Else
                        insertSQL += "   '00000000' , " + vbCrLf
                        insertSQL += "   '00000000' , " + vbCrLf
                        insertSQL += "   '000000' , " + vbCrLf
                        insertSQL += "   '00000000' , " + vbCrLf
                        insertSQL += "   '000000' , " + vbCrLf
                    End If

                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "'  " + vbCrLf
                    insertSQL += " ) " + vbCrLf

                    loopCounter += 1

                    If loopCounter > 100 Then
                        loopCounter = 0

                        sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                        sqlCommand.CommandText = insertSQL
                        sqlCommand.ExecuteNonQuery()

                        updateCounter += 1
                        insertSQL = ""
                        syokaiFlg = True

                    End If
                Next

                If Not insertSQL = "" Then
                    sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                    sqlCommand.CommandText = insertSQL
                    sqlCommand.ExecuteNonQuery()

                    updateCounter += 1
                    insertSQL = ""
                End If

                tran.Commit()
                ret = True
            Catch ex As Exception
                If Not tran Is Nothing Then
                    tran.Rollback()
                End If
                ret = False
            Finally
                If Not con Is Nothing Then
                    If Not con.State = ConnectionState.Closed Then
                        con.Close()
                    End If
                    con.Dispose()
                End If

                If Not tran Is Nothing Then
                    tran.Dispose()
                End If
            End Try

        End If

        Return ret
    End Function

    Protected Function updateSQLServerForPDF(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String, ByVal sessionID As String) As Boolean

        Dim ret As Boolean = True

        Dim con As SqlConnection = Nothing
        Dim sqlCommand As SqlCommand = Nothing
        Dim tran As SqlTransaction = Nothing

        Dim conStr As String

        Dim updateDateTime As DateTime = DateTime.Now

        Try

            If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
            End If

            If Not Directory.Exists(logDirectory) Then
                Directory.CreateDirectory(logDirectory)
            End If

            conStr = ""
            conStr += "Data Source=" + server + ";"
            conStr += "User ID=" + userId + ";"
            conStr += "Password=" + password + ";"
            conStr += "Initial Catalog=" + databaseName + ""

            con = New SqlConnection()
            con.ConnectionString = conStr

            con.Open()
            tran = con.BeginTransaction()

            sqlCommand = con.CreateCommand()
            sqlCommand.Transaction = tran

            Dim deleteSQL As String
            Dim syokaiFlg As Boolean = True
            Dim loopCounter As Integer = 1
            Dim updateCounter As Integer = 1
            deleteSQL = ""
            deleteSQL += " DELETE FROM W_DOC_RIDOC_FILE WHERE セッションID = '" + sessionID + "' " + vbCrLf
            sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

            sqlCommand.CommandText = deleteSQL
            sqlCommand.ExecuteNonQuery()


            If arrFILESQLData.Count() > 0 Then
                Dim insertSQL = ""
                loopCounter = 1
                updateCounter = 1
                syokaiFlg = True
                For Each sqlData As FILESQLData In arrFILESQLData
                    If syokaiFlg Then
                        insertSQL += " INSERT INTO W_DOC_RIDOC_FILE(セッションID,RidocID,ファイル番号,ファイル名,ファイルフルパス,作成日付,作成時刻,作成PGM,更新日付,更新時刻,更新PGM) VALUES " + vbCrLf
                        syokaiFlg = False
                    Else
                        insertSQL += " , " + vbCrLf
                    End If

                    insertSQL += " ( " + vbCrLf
                    insertSQL += "   '" + sessionID.ToString() + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.ridocID + "' , " + vbCrLf
                    insertSQL += "   " + sqlData.fileNo.ToString() + " , " + vbCrLf
                    insertSQL += "   '" + sqlData.fileName + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.filePath + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "'  " + vbCrLf
                    insertSQL += " ) " + vbCrLf

                    loopCounter += 1

                    If loopCounter > 100 Then
                        loopCounter = 0

                        sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                        sqlCommand.CommandText = insertSQL
                        sqlCommand.ExecuteNonQuery()

                        updateCounter += 1
                        insertSQL = ""
                        syokaiFlg = True

                    End If
                Next

                If Not insertSQL = "" Then
                    sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                    sqlCommand.CommandText = insertSQL
                    sqlCommand.ExecuteNonQuery()

                    updateCounter += 1
                    insertSQL = ""
                End If

            End If
            tran.Commit()
            ret = True
        Catch ex As Exception
            If Not tran Is Nothing Then
                tran.Rollback()
            End If
            ret = False
        Finally
            If Not con Is Nothing Then
                If Not con.State = ConnectionState.Closed Then
                    con.Close()
                End If
                con.Dispose()
            End If

            If Not tran Is Nothing Then
                tran.Dispose()
            End If
        End Try

        Return ret
    End Function

    Protected Function updateSQLServerForGetSearchDoc(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String, ByVal sessionID As String) As Boolean

        Dim ret As Boolean = True


        Dim con As SqlConnection = Nothing
        Dim sqlCommand As SqlCommand = Nothing
        Dim tran As SqlTransaction = Nothing

        Dim conStr As String

        Dim updateDateTime As DateTime = DateTime.Now

        Try

            If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
            End If

            If Not Directory.Exists(logDirectory) Then
                Directory.CreateDirectory(logDirectory)
            End If

            conStr = ""
            conStr += "Data Source=" + server + ";"
            conStr += "User ID=" + userId + ";"
            conStr += "Password=" + password + ";"
            conStr += "Initial Catalog=" + databaseName + ""

            con = New SqlConnection()
            con.ConnectionString = conStr

            con.Open()
            tran = con.BeginTransaction()

            sqlCommand = con.CreateCommand()
            sqlCommand.Transaction = tran

            Dim deleteSQL As String
            Dim syokaiFlg As Boolean = True
            Dim loopCounter As Integer = 1
            Dim updateCounter As Integer = 1
            deleteSQL = ""
            deleteSQL += " DELETE FROM W_DOC_RIDOC_ALL_SEARCH WHERE セッションID = '" + sessionID.Trim() + "' " + vbCrLf

            sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

            sqlCommand.CommandText = deleteSQL
            sqlCommand.ExecuteNonQuery()

            If arrSearchRidocID.Count() > 0 Then
                Dim insertSQL = ""
                loopCounter = 1
                updateCounter = 1
                syokaiFlg = True
                For Each ridocID As String In arrSearchRidocID
                    If syokaiFlg Then
                        insertSQL += " INSERT INTO W_DOC_RIDOC_ALL_SEARCH(セッションID,RidocID,作成日付,作成時刻,作成PGM,更新日付,更新時刻,更新PGM) VALUES " + vbCrLf
                        syokaiFlg = False
                    Else
                        insertSQL += " , " + vbCrLf
                    End If

                    insertSQL += " ( " + vbCrLf
                    insertSQL += "   '" + sessionID + "' , " + vbCrLf
                    insertSQL += "   '" + ridocID + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "'  " + vbCrLf
                    insertSQL += " ) " + vbCrLf

                    loopCounter += 1

                    If loopCounter > 100 Then
                        loopCounter = 0

                        sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                        sqlCommand.CommandText = insertSQL
                        sqlCommand.ExecuteNonQuery()

                        updateCounter += 1
                        insertSQL = ""
                        syokaiFlg = True

                    End If
                Next

                If Not insertSQL = "" Then
                    sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                    sqlCommand.CommandText = insertSQL
                    sqlCommand.ExecuteNonQuery()

                    updateCounter += 1
                    insertSQL = ""
                End If

            End If
            tran.Commit()
            ret = True
        Catch ex As Exception
            If Not tran Is Nothing Then
                tran.Rollback()
            End If
            ret = False
        Finally
            If Not con Is Nothing Then
                If Not con.State = ConnectionState.Closed Then
                    con.Close()
                End If
                con.Dispose()
            End If

            If Not tran Is Nothing Then
                tran.Dispose()
            End If
        End Try

        Return ret
    End Function

    Protected Function getMaxNodeNo(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String) As Boolean

        Dim ret As Boolean = True


        Dim con As SqlConnection = Nothing
        Dim sqlCommand As SqlCommand = Nothing
        Dim dataReader As SqlDataReader = Nothing


        Dim conStr As String

        Dim updateDateTime As DateTime = DateTime.Now

        Try

            If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
            End If

            If Not Directory.Exists(logDirectory) Then
                Directory.CreateDirectory(logDirectory)
            End If

            conStr = ""
            conStr += "Data Source=" + server + ";"
            conStr += "User ID=" + userId + ";"
            conStr += "Password=" + password + ";"
            conStr += "Initial Catalog=" + databaseName + ""

            con = New SqlConnection()
            con.ConnectionString = conStr

            con.Open()

            sqlCommand = con.CreateCommand()

            Dim selectSQL As String = ""
            'selectSQL += " SELECT A.ノードレベル as ノードレベル,Max(A.ノード番号) as MAXノード番号 FROM T_DOC_RIDOC_RENKEI A GROUP BY A.ノードレベル "
            selectSQL += " SELECT Max(A.ノード番号) as MAXノード番号 FROM T_DOC_RIDOC_RENKEI A "

            sqlLogWrite(selectSQL, logDirectory + "\selectSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + ".SQL")
            sqlCommand.CommandText = selectSQL

            dataReader = sqlCommand.ExecuteReader()
            While dataReader.Read
                maxNodeNo = CLng(dataReader("MAXノード番号"))
                'htNodeNo.Add(CInt(dataReader("ノードレベル")), CInt(dataReader("MAXノード番号")))
            End While


            ret = True
        Catch ex As Exception
            ret = False
        Finally
            If Not dataReader Is Nothing Then
                dataReader.Close()
            End If

            If Not sqlCommand Is Nothing Then
                sqlCommand.Dispose()
            End If

            If Not con Is Nothing Then
                If Not con.State = ConnectionState.Closed Then
                    con.Close()
                End If
                con.Dispose()
            End If

        End Try
        Return ret
    End Function

    Protected Sub sqlLogWrite(ByVal writeSQL As String, ByVal filePath As String)
        If filePath IsNot Nothing Then
            Dim logSQLWriter As StreamWriter = New StreamWriter(filePath, False, Encoding.GetEncoding("shift_jis"))
            logSQLWriter.Write(writeSQL)
            logSQLWriter.Close()
            logSQLWriter.Dispose()
            logSQLWriter = Nothing
        End If
    End Sub

    Protected Sub DisConnect()
        Try
            If Not m_ridocCabinet Is Nothing Then
                m_ridocCabinet = Nothing
                m_ridocSystem.Disconnect()
            End If
        Catch ex As Exception

        End Try
    End Sub


End Class
