// JavaScript Document
var treeData = [];
var docData = [];
var docPastData = [];
var docFavoriteData = [];
var largeSummary = false;
var largeFavorite = false;
var largeContact = false;

var palettePatern = ['black','red','blue','green','purple'];

$(document).ready(function(){
	ajaxLoadingCreate();
	
	window.name = "D290";

	createTreeTable();
	createDocTable(0,0);

	$('#dialogDocDetail').dialog({
		autoOpen: false,
		title: "発刊文書の詳細",
		closeOnEscape: false,
		width: $('body').width() * 0.78,
		height: $('body').height() * 0.5,
		modal: true,
		open: function() {
			setTimeout(function(){
				$('.ui-dialog-buttonset button:eq(2)').focus();
			},0);
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});

	ajaxLoadingDelete();

});

function createTreeTable(){
	var retXML = getTreeData();
	treeData = cmXmlToTreeData(retXML,'line');

	$('#treeMenu').tree({
		data:treeData,
		closedIcon:'images/migisankaku.png',
		openedIcon:'images/sitasankaku.png',
		
	});

	$('#treeMenu').on('tree.click',function(event){
		var node = event.node;
		createDocTable(node.nodeLevel,node.nodeNo)
	});

}

function getTreeData(){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D291',
		'ssid': $('#ssid').val(),
		'arguments':'ssid'
	};
	var xmlData = cmGetXmlData(param);
	if( $(xmlData).find('message').text() !== '' ){
		alert($(xmlData).find('message').text());
	}
	return xmlData;
}

function createDocTable(nodeLevel,nodeNo){
	var docXml = getPublishDoc(nodeLevel,nodeNo);

	var tableID = "";
	switch( $(docXml).find('ret').text() ){
		case 'I001':
			var lineTag = [];
			lineTag[0] = 'line';
			
			var subLineTag = [];
			subLineTag[0] = 'detailLine';

			var createData = cmXmlToArray(docXml,'line');

			docData = createData;
			tableID = 'tblReportList';
			break;
		case 'S001':
			createData = [];
			break;
		case 'E001':
			ExecPgm('W040');
			break;
	}

	if(tableID !== ""){
		$('#' + tableID ).empty();
		var html = '';
		if( createData.length <= 0 ){
		}else{
			for( var i = 0; i < createData.length; i++ ){
				var lineData = createData[i];
				html = html + '<tr style="height: 24px;">';
				html = html + '<td align="center" width="50px" nowrap>&nbsp';
				html = html + '</td>';
				html = html + '<td>';
				html = html + '<a href="#" class="hrefFile" id="href' + String(i) + '" data-ridocID="' + lineData.ridocID + '" >' + lineData.fileName +'</a>';
				html = html + '</td>';
				html = html + '</tr>';
			}
		}
		$('#' + tableID ).append(html);

		$('.hrefFile').on(
			'click',
			function(){
				var docKind = $(this).attr('data-kind');
				var docNo = $(this).attr('data-no');
				var ridcoID = $(this).attr('data-ridocID');
				/*
				window.open("/Magic33Scripts/MGrqispi.dll?APPNAME=NAIS3WEB&PRGNAME=D220&ARGUMENTS=-ANAIS3WEB,-A" + $('#ssid').val() + ",-A" + docKind + ",-A" + docNo,
							   "",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500,');
							   */
				window.open("","ファイル",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500');
				$('#windowForm').attr('target','ファイル');
				$('#Wprgname').val('D293');
				$('#w_param1').val('ANAIS3WEB');
				$('#w_param2').val($('#ssid').val());
				$('#w_param3').val(ridcoID);
				$('#w_param4').val('');
				$('#w_param5').val('');
				$('#w_param6').val('');
				$('#w_param7').val('');
				$('#w_param8').val('');
				$('#w_param9').val('');
				$('#w_param10').val('');
				$('#windowForm').submit();
				$('#windowForm').attr('target','_self');
			}
		);

	}
}

function getPublishDoc(nodeLevel,nodeNo){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D292',
		'ssid': $('#ssid').val(),
		'nodeNo': nodeNo,
		'nodeLevel': nodeLevel,
		'arguments':'ssid,nodeNo,nodeLevel'
	};
	var xmlData;
	$.ajax({
		async : false,
		url: ajaxURL,
		data : param,
		dataType:'xml',
		scriptCharset: 'utf-8',
		success : function(xml){
			$('#ssid').val($(xml).find('ssid').text());	
			xmlData = xml;
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
				cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
		}
	});
	//var xmlData = cmGetXmlData(param);
	return xmlData;
}
