// JavaScript Document
var docData = [];
var categoryData = [];
var berthData = [];

palettePatern = ['black','red','blue','green','purple'];

var doc_bgcolor_title,doc_font_color_title,doc_font_color_detail;

$(document).ready(function(){
	$('#startDate').mask('9999/99/99');
	$('#startDate').datepicker({dateFormat:'yy/mm/dd'});
	$("#startDate").datepicker("option", "showOn", 'button');
	$("#startDate").datepicker("option", "buttonImageOnly", true);
	$("#startDate").datepicker("option", "buttonImage", '../webnais/pilot/scripts/datepicker.png');
	$('#endDate').mask('9999/99/99');
	$('#endDate').datepicker({dateFormat:'yy/mm/dd'});
	$("#endDate").datepicker("option", "showOn", 'button');
	$("#endDate").datepicker("option", "buttonImageOnly", true);
	$("#endDate").datepicker("option", "buttonImage", '../webnais/pilot/scripts/datepicker.png');
	$("img[class='ui-datepicker-trigger']").each(function(){ 
		$(this).attr('style', 'position:relative; top:3px; left:3px;');
	});

	$('.chbFileType').prop('checked',true);
	$('#rdoKikanKbn_5').prop('checked',true);
	$('#startDate').prop('disabled',true);
	$('#endDate').prop('disabled',true);
	$("img[class='ui-datepicker-trigger']").hide();
	
	$('#dialogSearchOption').dialog({
		autoOpen: false,
		title: "検索オプション",
		closeOnEscape: false,
		width: 500,
		modal: true,
		open: function() {
			$('#searchTextDialog').val($('#searchText').val());
		},
		buttons: {
	        'この条件で検索': function(event){
				$('#searchText').val($('#searchTextDialog').val());
				$(this).dialog("close");
				createDocTable();
			}
    	}
	});

	
	$('#dialogDocDetail').dialog({
		autoOpen: false,
		title: "発刊文書の詳細",
		closeOnEscape: false,
		width: $('body').width() * 0.78,
		height: $('body').height() * 0.5,
		modal: true,
		open: function() {
			var thisObj = this;
			setTimeout(function(){
				$('.ui-dialog-buttonset button:eq(2)').focus();
			},0);
		},
		buttons: {
	        '閉じる': function(event){
				$(this).dialog("close");
			}
    	}
	});

	$('.summaryBtn').click(function(){
		var btnId = $(this).attr('id');
		$('#divAjax').show();
		setTimeout(function(){
			switch( btnId ){
				case 'btnAllSelectSummary' :
					for( var i = 0; i < docData[0].line.length; i++ ){
						$('#chkDoc' + String(i) ).prop("checked",true);
					}
					break;
				case 'btnAllCancelSummary' :
					for( var i = 0; i < docData[0].line.length; i++ ){
						$('#chkDoc' + String(i) ).prop("checked",false);
					}
					break;
				case 'btnMoveFavorite' :
					if( createRegistList('chkDoc') ){
						var retXml = updateDocAttr('1','',registList);
						if( $(retXml).find('ret').text() == 'I001' ){
							cmAlert('結果','処理が完了しました。')
							for( var i = 0; i < docData[0].line.length; i++ ){
								$('#chkDoc' + String(i) ).prop("checked",false);
							}
						}
					}else{
						cmAlert('エラー','1つ以上の文書を選択して下さい。')
					}
					break;
			}
			$('#divAjax').hide();
		},0);
	});

	$('#searchText').blur(function(){
		if( $(this).val() == '' ){
			$(this).addClass('defaultKeyWord')
		}
	});

	$('#searchText').focus(function(){
		if( $(this).hasClass('defaultKeyWord') ){
			$(this).val('');
			$(this).removeClass('defaultKeyWord')
		}
	});

	$('input[name="rdokikanKbn"]').change(function(){
		if($(this).val() === ""){
			$('#startDate').prop('disabled',false);
			$('#endDate').prop('disabled',false);
			$("img[class='ui-datepicker-trigger']").show();
		}else {
			$('#startDate').val("");
			$('#endDate').val("");
			$('#startDate').prop('disabled',true);
			$('#endDate').prop('disabled',true);
			$("img[class='ui-datepicker-trigger']").hide();
		}
	});
	
	$('#btnSearchDoc').click(function(){
		createDocTable();
	});

	$('#divFootDocSummary').hide();

	// 左側にカテゴリを表示しない
	//createCategoryTable();

	$('#searchText').focus();

});

var registList = '';
function createRegistList(registClass){
	var retCheck = false;
	registList = '';
	$('.' + registClass).map(function(){
		if( $(this).prop("checked") ){
			retCheck = true;
			registList = registList + '@' + $(this).attr('data-kind') + ':' + $(this).attr('data-no');
		}
	});
	
	if( registList != '' ){
		registList = registList.substring( 1 );
	}

	return retCheck;
};

function updateDocAttr(kbn,color,list){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D210',
		'ssid': $('#ssid').val(),
		'updateKbn': kbn,
		'color': color,
		'list': list,
		'arguments':'ssid,updateKbn,color,list'
	};

	//var xmlData = ajaxFunction(param,'0');
	var xmlData = cmGetXmlData(param);
	if( $(xmlData).find('message').text() != '' ){
		cmAlert('結果',$(xmlData).find('message').text());
	}
	return xmlData;
}

function createDetailTable(dataNo,createData){

	var lineData = createData[0].line[dataNo];

	$('#tbHeadDocDetail').empty();
	$('#tbBodyDocDetail').empty();
	html = '';
	html = html + '<tr bgcolor="'+doc_bgcolor_title+'">';
	html = html + '<td><font color="'+doc_font_color_title+'"><b>[詳細]' + lineData.title  + '</b></font></td>';
    html = html + '</tr>'
	$('#tbHeadDocDetail').append(html);

	html = '';
	for( var i = 0; i < lineData.detailLine.length; i++ ){
		var detailData = lineData.detailLine[i];
		html = html + '<tr >';
		html = html + '<td>';
		html = html + '<font color="' + lineData.color + '">' + detailData.detailTitle + '</font>';
		html = html + '</td>'
		html = html + '</tr>';
	}

	$('#tbBodyDocDetail').append(html);
}

function createDocTable(){

	$('#divAjax').show();
	setTimeout(function(){
		$('#spnSearchStr').text(createSearchStr());
		var docXml = getPublishDoc();
		if(docXml !== ""){
			doc_bgcolor_title = $(docXml).find('doc_bgcolor_title').text();
			doc_font_color_title = $(docXml).find('doc_font_color_title').text();
			doc_font_color_detail = $(docXml).find('doc_font_color_detail').text();
			switch( $(docXml).find('ret').text() ){
				case 'I001':
					var lineTag = [];
					lineTag[0] = 'line';

					var subLineTag = [];
					subLineTag[0] = 'detailLine';

					createData = xmlToMultiStageArray(docXml,'data',lineTag,subLineTag);
					docData = createData;

					if( $(docXml).find('message').text() !== '' ){
						cmAlert('警告',$(docXml).find('message').text());
					}
					break;
				case 'S001':
					createData = [];
					docData = [];
					break;
				case 'E001':
					//location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME="+nasiappname+"&PRGNAME=W040&ARGUMENTS=''");
					break;
			}

			$('#divDoc').empty();

			html = '';

			if( createData.length <= 0 ){
				html = html + '<TABLE id="tbHeadDoc" border="0" cellspacing="0" cellpadding="2" WIDTH="99%">';
				html = html + '<tr>';
				html = html + '<td align="center" width="10%" nowrap>';
				html = html + '<font color="'+doc_font_color_detail+'"></font>';
				html = html + '</td>';
				html = html + '<td align="center" width="7%" nowrap>';
				html = html + '<font color="'+doc_font_color_detail+'">&nbsp;</font>';
				html = html + '</td>';
				html = html + '<td nowrap>';
				html = html + '<font color="'+doc_font_color_detail+'">検索対象の発刊文書はありません。</font>';
				html = html + '</td>';
				html = html + '<td width="12%" nowrap>';
				html = html + '<font color="'+doc_font_color_detail+'">&nbsp;</font>';
				html = html + '</td>';
				html = html + '</tr>';
				html = html + '</table>';
				$('#divDoc').append(html);
				$('#divFootDocSummary').hide();
			}else{
				html = html + '<div style="height:5%;">';
				html = html + '<TABLE id="tbHeadDoc" border="0" cellspacing="0" cellpadding="2" WIDTH="100%">';
				html = html + '<tr bgcolor="'+doc_bgcolor_title+'">';
				html = html + '<td colspan="6" nowrap><font color="'+doc_font_color_title+'"><b>検索結果：' + String(createData[0].line.length) + '件</b></font></td>';
				html = html + '</tr>';
				html = html + '</table>';
				html = html + '</div>';
				html = html + '<div style="height:95%;overflow-y: scroll;">';
				html = html + '<TABLE id="tbBodyDoc" border="0" cellspacing="0" cellpadding="2" WIDTH="100%">';

				var dataLineNum = 0;
				var hideFlg = false;
				for( var j = 0; j < createData[0].line.length; j++ ){
					var lineData = createData[0].line[j];
					dataLineNum++;
					html = html + '<tr>';
					html = html + '<td align="center" width="2%" nowrap>';
					html = html + '<input type="checkbox" class="chkDoc" id="chkDoc' + String(j) + '" data-color="' + lineData.color + '" data-kind="' + lineData.docKindCd + '" data-no="' + lineData.docNo + '">';
					html = html + '</td>';
					html = html + '<td align="left" width="10%" nowrap>';
					html = html + '<font id="dateFont' + String(j) + '" color="' + lineData.color + '">' + lineData.publishDate + '</font>';
					html = html + '</td>';
					html = html + '<td align="left" width="12%" nowrap>';
					html = html + '<font id="docNoFont' + String(j) + '" color="' + lineData.color + '">' + lineData.docKindName + '</font>';
					html = html + '</td>';
					html = html + '<td>';
					html = html + '<font id="titleFont' + String(j) + '" color="' + lineData.color + '">' + lineData.title + '</font>';
					html = html + '</td>';
					html = html + '<td align="center" width="7%" nowrap>';
					if( lineData.detailFlg === '1' ){
						html = html + '<a href="#" class="detailHref" id="detail' + String(j) + '" data-no="' + String(j) + '" data-title="' + lineData.title + '">詳細</a>';
					}else{
						html = html + '&nbsp;';
					}
					html = html + '</td>';
					html = html + '<td width="12%" nowrap>';
					html = html + '<font color="' + lineData.color + '">';
					if( lineData.tempFlg === '1' ){
						html = html + '<a href="#" class="hrefFile" id="href' + String(j) + '" data-kind="' + lineData.docKindCd + '" data-no="' + lineData.docNo + '"><img src="images/attachment.png" alt="添付資料" width="69" height="20" border="0" align="middle"></a>';
					}else{
						html = html + '&nbsp;';
					}
					html = html + '</font>';
					html = html + '</td>';
					html = html + '</tr>';
					html = html + '<tr>';
					html = html + '<td style="line-height:0px" colspan="6">';
					html = html + '&nbsp;';
					html = html + '</td>';
					html = html + '</tr>';
				}
				html = html + '</TABLE>';
				html = html + '<br>';
				html = html + '</div>';

				$('#divDoc').append(html);
				$('#divFootDocSummary').show();
			}

			$('.detailHref').unbind().click(function(){
				var detailData = [];
				createDetailTable($(this).attr('data-no'),docData);
				$('#dialogDocDetail').dialog('open');
				return false;
			});

			$('.hrefFile').unbind().click(function(){
				var docKind = $(this).attr('data-kind');
				var docNo = $(this).attr('data-no');
				window.open("/Magic33Scripts/MGrqispi.dll?APPNAME=NAIS3WEB&PRGNAME=D220&ARGUMENTS=-ANAIS3WEB,-A" + $('#ssid').val() + ",-A" + docKind + ",-A" + docNo,
							   "",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500,');
				return false;
			});

			$('.arrowDataDoc').unbind().click(function(){
				slideDocData();
				return false;
			});
		}
		$('#divAjax').hide();
	},0);
}

function slideDocData(){

	$('.trDocData').map(function(){
		if( $(this).css("display") == "none" ){
			$('#spnArrowDoc').text('隠す');
			$('#imgArrowDoc').attr('src','images/arrowRight.gif');
			$(this).slideDown();
		}else{
			$('#spnArrowDoc').text('続きを見る');
			$('#imgArrowDoc').attr('src','images/arrowBottom.gif');
			$(this).slideUp();
		}
	});
}

function createCategoryTable(){

	$('#divAjax').show();
	setTimeout(function(){

		var docXml = getCategory();
		switch( $(docXml).find('ret').text() ){
			case 'I001':
				var lineTag = [];
				lineTag[0] = 'line';
				
				var subLineTag = [];
				subLineTag[0] = 'detailLine';

				categoryData = xmlToMultiStageArray(docXml,'data',lineTag,subLineTag)
				break;
			case 'E001':
		        location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME="+nasiappname+"&PRGNAME=W040&ARGUMENTS=''");
				break;
		}
		/*
		html = '';
		html = html + '<table style="border:none" border="0" cellspacing="0" cellpadding="0" align="center" width="98%" frame="box" rules="none">'
		html = html + '<TR height="25">';
		html = html + '<TD valign="center" align="left"><font size="4">＜＜検索オプション＞＞</font></TD>'
		html = html + '</TR>'
		html = html + '</TABLE>'
		for( var i = 0; i < categoryData[0].line.length; i++ ){
			var lineData = categoryData[0].line[i];
			html = html + '<div style="height:16%">'
			html = html + '<table style="border:none" border="0" cellspacing="0" cellpadding="0" align="center" width="98%" frame="box" rules="none">'
			html = html + '<TR height="20px">';
			html = html + '<TD valign="center" align="left"><input type="checkBox" class="categoryCheck" id="categoryCheck' + String(i) + '" name="categoryCheck' + String(i) + '" data-Cd="' + String(i) + '"> <font size="4">' + lineData.categoryName +'</font></TD>'
			html = html + '</TR>'
			html = html + '</TABLE>'
			html = html + '<div style="height:85%;overflow-y: scroll;">';
			html = html + '<table style="border:none" border="0" cellspacing="0" cellpadding="0" align="center" width="98%" frame="box" rules="none">';
			for( var j = 0; j < lineData.detailLine.length; j++ ){
				var detailData = lineData.detailLine[j];
				switch( detailData.catClass ){
					case '1':
						html = html + '<TR id="trPortHref' + detailData.placeCdA + '" name="trPortHref' + detailData.placeCdA + '">';
						html = html + '<TD valign="center" align="left"><input type="checkBox" style="margin-left:20px;" class="portCheck" name="portCheck' + detailData.placeCdA +'" id="portCheck' + detailData.placeCdA +'" data-Cd="' + detailData.placeCdA + '" ><label for="portCheck' + detailData.placeCdA +'">' + detailData.categoryDetail + '</label></TD>'
						html = html + '</TR>';
						break;
					case '3':
						html = html + '<TR>';
						html = html + '<TD valign="center" align="left"><input type="checkBox" style="margin-left:20px;" class="oceanCheck" name="oceanCheck' + detailData.oceanCd +'" id="oceanCheck' + detailData.oceanCd +'" data-Cd="' + detailData.oceanCd + '" ><label for="oceanCheck' + detailData.oceanCd +'">' + detailData.categoryDetail + '</label></TD>'
						html = html + '</TR>';
						break;
					case '4':
						html = html + '<TR>';
						html = html + '<TD valign="center" align="left"><input type="checkBox" style="margin-left:20px;" class="docCheck" name="docCheck' + detailData.docCd +'" id="docCheck' + detailData.docCd +'" data-Cd="' + detailData.docCd + '" ><label for="docCheck' + detailData.docCd +'">' + detailData.categoryDetail + '</label></TD>'
						html = html + '</TR>';
						break;
					case '5':
						html = html + '<TR>';
						html = html + '<TD valign="center" align="left"><input type="checkBox" style="margin-left:20px;" class="docOtherCheck" name="docOtherCheck' + detailData.docCd +'" id="docOtherCheck' + detailData.docCd +'" data-Cd="' + detailData.docCd + '" ><label for="docOtherCheck' + detailData.docCd +'">' + detailData.categoryDetail + '</label></TD>'
						html = html + '</TR>';
						break;
				}
				html = html + '</TR>';
			}
			html = html + '</TABLE>';
			html = html + '</div>';
			html = html + '</div>';
			html = html + '<br>';
		}
		html = html + '<table  style="border:none" border="0" cellspacing="0" cellpadding="0" align="center" width="98%" frame="box" rules="none">'
		html = html + '<TR height="30">';
		html = html + '<TD valign="center" align="left"><input type="checkBox" class="categoryCheck" id="categoryCheck' + String(categoryData[0].line.length) + '" name="categoryCheck' + String(categoryData[0].line.length) + '" data-Cd="' + String(categoryData[0].line.length) + '"> <font size="4">発行期間で絞り込む</font></TD>'
		html = html + '</TR>'
		html = html + '</TABLE>'
		html = html + '<input type="text" style="height:30px;margin-top:10px;width:80px;" id="startDate" name="startDate"><span style="margin-left:10px;">～</span>'
		html = html + '<input type="text" style="height:30px;margin-top:10px;width:80px;" id="endDate" name="endDate">'
		$('#divCategory').append(html)	
		
		$('#startDate').blur(function(){
			if( $(this).val() == '' ){
				$(this).val('発行期間を指定');
				$(this).addClass('defaultKeyWord')
			}
		});
		$('#startDate').focus(function(){
			if( $(this).hasClass('defaultKeyWord') ){
				$(this).val('');
				$(this).removeClass('defaultKeyWord')
			}
		});

		$('#endDate').blur(function(){
			if( $(this).val() == '' ){
				$(this).val('発行期間を指定');
				$(this).addClass('defaultKeyWord')
			}
		});

		$('#endDate').focus(function(){
			if( $(this).hasClass('defaultKeyWord') ){
				$(this).val('');
				$(this).removeClass('defaultKeyWord')
			}
		});
		*/
		$('#divAjax').hide();
	},0);
	
}

function updateDocAttr(kbn,color,list){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D210',
		'ssid': $('#ssid').val(),
		'updateKbn': kbn,
		'color': color,
		'list': list,
		'arguments':'ssid,updateKbn,color,list'
	};

	//var xmlData = ajaxFunction(param,'0');
	var xmlData = cmGetXmlData(param);
	if( $(xmlData).find('message').text() != '' ){
		cmAlert('結果',$(xmlData).find('message').text());
		
	}
	return xmlData;
}

function getPublishDoc(){

	var paraFileTypeFlag = '0';
	var paraDateFlag = '0';

	var paraFileType = '';
	var paraOtherClass = '';
	var paraStartDate = '';
	var paraEndDate = '';
	var paraSearchWord = '';
	var paraSearchWordForSubject = '';

	if( !$('#searchText').hasClass('defaultKeyWord') ){
		paraSearchWord = $('#searchText').val();

		arrSearchWord = $('#searchText').val().split(' ');
		if( arrSearchWord.length === 0 ){
			paraSearchWordForSubject = $('#searchText').val();
		}else{
			for( var i = 0; i < arrSearchWord.length; i++ ){
				paraSearchWordForSubject = paraSearchWordForSubject + '@' + arrSearchWord[i];
			}
			if( paraSearchWordForSubject !== '' ){
				paraSearchWordForSubject = paraSearchWordForSubject.substring(1);
			}
		}

	}

	$('.chbFileType').each(function(){
		if( $(this).prop('checked') ){
			paraFileType = paraFileType + '@' + $(this).attr('data-Cd');
		}
	});
	if( paraFileType !== '' ){
		paraFileType = paraFileType.substring(1);
		paraFileTypeFlag = 1;
	}
	
	if($('input[name="rdokikanKbn"]:checked').val() === ""){
		paraStartDate = $('#startDate').val();
		paraEndDate = $('#endDate').val();
	}else {
		paraStartDate = $('input[name="rdokikanKbn"]:checked').val();
		paraEndDate = '9999/12/31';
	}
	
	var validMsg = '';
	if(paraFileType === ""){
		validMsg = validMsg + '文書種類が選択されていません。' + '<br>';
	}
	if(paraStartDate === "" && paraEndDate === ""){
		validMsg = validMsg + '期間が指定されていません。' + '<br>';
	}

	var xmlData = '';
	if(validMsg === ""){
		var param = {
			'appname':'NAIS3WEB',
			'prgname':'D271',
			'ssid': $('#ssid').val(),
			'paraPortFlag': 0,
			'paraOceanFlag': 0,
			'paraFileTypeFlag': paraFileTypeFlag,
			'paraSonotaFlg' : 0,
			'paraDateFlag': 1,
			'paraPortCd': '',
			'paraOceanCd': '',
			'paraFileType': paraFileType,
			'paraOtherClass': '',
			'paraStartDate': paraStartDate,
			'paraEndDate': paraEndDate,
			'paraSearchWord': paraSearchWord,
			'paraSearchWordForSubject': paraSearchWordForSubject,	'arguments':'ssid,paraPortFlag,paraOceanFlag,paraFileTypeFlag,paraSonotaFlg,paraDateFlag,paraPortCd,paraOceanCd,paraFileType,paraOtherClass,paraStartDate,paraEndDate,paraSearchWord,paraSearchWordForSubject'
		};

		//var xmlData = ajaxFunction(param,'0');
		xmlData = cmGetXmlData(param);		
	}else {
		cmAlert('エラー',validMsg);
	}
	
	return xmlData;
}

function getCategory(){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D261',
		'ssid': $('#ssid').val(),
		'searchKbn': '0',
		'arguments':'ssid,searchKbn'
	};

	//var xmlData = ajaxFunction(param,'0');
	var xmlData = cmGetXmlData(param);
	return xmlData;
}

function DispStatus(form)
        {
        status = ("");
        }
function ColChange(para)
		{
		para.style.color = "#800080";
		}
function gotoCategorySearch(){
	//location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=D260&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>");
	$('#prgname').val('D260');
	$('#menuForm').submit();
}

function NPHelp(){
	var hdnWebDocAlias = $('#hdnWebDocAlias').val();
	window.open(hdnWebDocAlias+"help/nphelp_search001.htm");
}
function openSearchOption(){
	$('#dialogSearchOption').dialog('open');
}
function createSearchStr(){
	var searchStr = '検索条件：全文検索';
	if($('#searchText').val() !== ""){
		searchStr = searchStr + '  ' + $('#searchText').val();
	}
	
	var fileTypeStr = '';
	var fileTypeCheck = 0;
	$('.chbFileType').each(function(){
		if($(this).prop('checked')){
			fileTypeStr = fileTypeStr + ',' + $('label[for="'+$(this).attr('id')+'"]').text();
		}else {
			fileTypeCheck = 1;
		}
	});
	
	if(fileTypeStr !== ''){
		if(fileTypeCheck === 0){
			fileTypeStr = '全て';
		}else {
			fileTypeStr = fileTypeStr.substring(1);
		}
		searchStr = searchStr + '  文書種類：' + fileTypeStr;
	}
	
	var KikanStr = '';
	if($('input[name="rdokikanKbn"]:checked').val() === ""){
		KikanStr = $('#startDate').val() + ' ～ ' + $('#endDate').val();
	}else {
		KikanStr = $('label[for="'+$('input[name="rdokikanKbn"]:checked').attr('id')+'"]').text();
	}
	searchStr = searchStr + '  期間：' + KikanStr;
	
	return searchStr;
}
