﻿Imports System
Imports System.IO
Imports System.Text
Imports System.Data.SqlClient
Imports jp.co.ricoh.ridoc.smartnavi
Imports jp.co.ricoh.ridoc.smartnavi.model

Public Class AccessToRidoc

    Protected m_ridocSystem As RsnSystem
    Protected m_ridocCabinet As RsnCabinet

    Protected Structure DOCSQLData
        Public nodeLevel As Integer
        Public nodeNo As Integer
        Public parentNodeNo As Integer
        Public folderFlg As String
        Public docNo As String
        Public docTitle As String
        Public ridocID As String
    End Structure

    Protected Structure FILESQLData
        Public ridocID As String
        Public fileNo As Integer
        Public fileName As String
        Public filePath As String
    End Structure

    Protected arrDOCSQLData As ArrayList
    Protected arrFILESQLData As ArrayList
    Protected htDeleteData As Hashtable
    Protected htNodeNo As Hashtable

    Public Sub New()
        m_ridocSystem = New RsnSystem()
        arrDOCSQLData = New ArrayList
        arrFILESQLData = New ArrayList
        htDeleteData = New Hashtable
        htNodeNo = New Hashtable
    End Sub
    Public Sub Dispose()
        Try
            If Not m_ridocCabinet Is Nothing Then
                m_ridocCabinet = Nothing
                m_ridocSystem.Disconnect()
            End If

            m_ridocSystem = Nothing

            arrDOCSQLData.Clear()
            arrFILESQLData.Clear()
            htDeleteData.Clear()
            htNodeNo.Clear()

            arrDOCSQLData = Nothing
            arrFILESQLData = Nothing
            htDeleteData = Nothing
            htNodeNo = Nothing

        Catch ex As Exception

        End Try

    End Sub

    Public Function GetDocAndUpdateSQLServer(ByVal serverUrl As String, ByVal userName As String, ByVal passWord As String, ByVal domainName As String, ByVal saveDirectory As String, ByVal sqlServer As String, ByVal sqlUser As String, ByVal sqlPassword As String, ByVal sqlDatabaseName As String, ByVal ridocID As String, ByVal nodeLevel As Integer, ByVal nodeNo As Integer, ByVal logDirectory As String) As Integer
        If Not m_ridocSystem Is Nothing Then
            Try
                If m_ridocCabinet Is Nothing Then
                    Me.Connect(serverUrl, userName, passWord, domainName)
                End If
            Catch ex As Exception
                Return 2
            End Try

            arrDOCSQLData.Clear()
            arrFILESQLData.Clear()
            htDeleteData.Clear()
            htNodeNo.Clear()

            Try
                Dim analizeFolder As RsnFolder = Nothing
                Dim analizeNodeLevel As Integer = 0
                Dim analizeNodeNo As Integer = 0

                If Not ridocID.Trim() = "" Then
                    analizeFolder = m_ridocSystem.GetFolder(ridocID)
                    If Not analizeFolder Is Nothing Then
                        analizeNodeLevel = nodeLevel
                        analizeNodeNo = nodeNo
                        getMaxNodeNo(sqlServer, sqlUser, sqlPassword, sqlDatabaseName, logDirectory)
                    End If
                End If
                Me.AnalizeFolder(analizeFolder, analizeNodeLevel, analizeNodeNo)

            Catch ex As Exception
                Return 4
            End Try

            Try

                Dim ret As Boolean
                ret = updateSQLServerForGetDoc(sqlServer, sqlUser, sqlPassword, sqlDatabaseName, logDirectory)
                If Not ret Then
                    Return 5
                End If
            Catch ex As Exception
                Return 5
            End Try

        Else
            Return 999
        End If

        Return 0
    End Function

    Public Function GetPDFFile(ByVal serverUrl As String, ByVal userName As String, ByVal passWord As String, ByVal domainName As String, ByVal saveDirectory As String, ByVal sqlServer As String, ByVal sqlUser As String, ByVal sqlPassword As String, ByVal sqlDatabaseName As String, ByVal ridocID As String, ByVal logDirectory As String, ByVal sessionID As String) As Integer


        If Not m_ridocSystem Is Nothing Then
            Try
                If m_ridocCabinet Is Nothing Then
                    Me.Connect(serverUrl, userName, passWord, domainName)
                End If
            Catch ex As Exception
                Return 2
            End Try

            Try
                If saveDirectory.Substring(saveDirectory.Length - 1) = "\" Then
                    saveDirectory = saveDirectory.Substring(0, saveDirectory.Length - 1)
                End If

                If Not Directory.Exists(saveDirectory) Then
                    Directory.CreateDirectory(saveDirectory)
                End If
            Catch ex As Exception
                Return 3
            End Try

            Dim document As RsnDocument = Nothing
            Dim sectionList As List(Of RsnSection) = Nothing
            Dim nowDateTime As DateTime = DateTime.Now

            Try
                document = m_ridocSystem.GetDocument(ridocID)
                sectionList = document.GetSectionList()
                Dim fileNo As Integer = 1
                For Each section As RsnSection In sectionList
                    Dim fileSqlData As FILESQLData

                    If section.existPDF = True Then
                        fileSqlData.ridocID = ridocID
                        fileSqlData.fileName = CStr(section.name).Trim() + "_" + nowDateTime.ToString("yyyyMMddHHmmss") + ".pdf"
                        fileSqlData.fileNo = fileNo
                        fileSqlData.filePath = saveDirectory.Trim() + "\" + fileSqlData.fileName

                        Dim fileStream As Stream = New FileStream(fileSqlData.filePath, FileMode.Create, FileAccess.Write)
                        document.ReadSectionData(section.sectionNo, RsnDocument.OPTION_PDF, fileStream)
                        fileStream.Close()
                        fileStream.Dispose()
                        fileStream = Nothing

                        arrFILESQLData.Add(fileSqlData)
                        fileNo += 1
                    End If
                Next

            Catch ex As Exception
                Return 4
            End Try

            Try
                Dim ret As Boolean
                ret = updateSQLServerForPDF(sqlServer, sqlUser, sqlPassword, sqlDatabaseName, logDirectory, sessionID)
                If Not ret Then
                    Return 5
                End If
            Catch ex As Exception
                Return 5
            End Try

        Else
            Return 999
        End If
        Return 0
    End Function

    Protected Function Connect(ByVal serverUrl As String, ByVal userName As String, ByVal passWord As String, ByVal domainName As String) As Boolean
        Try
            If domainName = String.Empty Then
                m_ridocCabinet = m_ridocSystem.Connect(serverUrl, userName, passWord)
            Else
                m_ridocCabinet = m_ridocSystem.Connect(serverUrl, userName, passWord, domainName)
            End If
        Catch ex As Exception
            Return False
        End Try

        Return True

    End Function

    Protected Sub AnalizeFolder(ByVal parentFolder As RsnFolder, ByVal parentNodeLevel As Integer, ByVal parentNodeNo As Integer)
        Dim folderList As List(Of RsnFolder) = Nothing
        Dim documentList As List(Of RsnDocument) = Nothing

        If Not parentFolder Is Nothing Then

            folderList = parentFolder.GetFolderList()
            documentList = parentFolder.GetDocumentList()
        Else
            folderList = m_ridocCabinet.GetFolderList()
            documentList = m_ridocCabinet.GetDocumentList()
        End If

        Dim nodeLevel As Integer = parentNodeLevel + 1
        Dim nodeNo As Integer

        For Each folder As RsnFolder In folderList

            If htNodeNo.ContainsKey(nodeLevel) Then
                nodeNo = CInt(htNodeNo(nodeLevel)) + 1
                htNodeNo(nodeLevel) = nodeNo
            Else
                nodeNo = 1
                htNodeNo.Add(nodeLevel, nodeNo)
            End If

            Dim folderSqlData As DOCSQLData

            folderSqlData.nodeLevel = nodeLevel
            folderSqlData.nodeNo = nodeNo
            folderSqlData.parentNodeNo = parentNodeNo
            folderSqlData.folderFlg = "1"
            folderSqlData.docNo = CStr(folder.GetPropertyValue("name"))
            folderSqlData.docTitle = ""
            folderSqlData.ridocID = CStr(folder.GetPropertyValue("id"))

            arrDOCSQLData.Add(folderSqlData)

            Dim hashKey As String = nodeLevel.ToString().PadLeft(5, "0"c) + parentNodeNo.ToString.PadLeft(5, "0"c)
            If Not htDeleteData.ContainsKey(hashKey) Then
                htDeleteData.Add(hashKey, "")
            End If

            Me.AnalizeFolder(folder, nodeLevel, nodeNo)

        Next

        For Each document As RsnDocument In documentList
            Dim docSqlData As DOCSQLData
            Dim pdfFlg As Boolean = False
            Dim docStatus As Long

            Dim sectionList As List(Of RsnSection) = Nothing
            sectionList = document.GetSectionList()
            For Each section As RsnSection In sectionList
                If section.existPDF = True Then
                    pdfFlg = True
                End If
            Next

            docStatus = CLng(document.GetPropertyValue("status"))

            If docStatus = RsnDocumentProperty.DOCUMENT_STATUS_COMPLETE AndAlso pdfFlg = True Then
                If htNodeNo.ContainsKey(nodeLevel) Then
                    nodeNo = CInt(htNodeNo(nodeLevel)) + 1
                    htNodeNo(nodeLevel) = nodeNo
                Else
                    nodeNo = 1
                    htNodeNo.Add(nodeLevel, nodeNo)
                End If

                docSqlData.nodeLevel = nodeLevel
                docSqlData.nodeNo = nodeNo
                docSqlData.parentNodeNo = parentNodeNo
                docSqlData.folderFlg = "0"
                docSqlData.docNo = CStr(document.GetPropertyValue("number"))
                docSqlData.docTitle = CStr(document.GetPropertyValue("name"))
                docSqlData.ridocID = CStr(document.GetPropertyValue("id"))

                arrDOCSQLData.Add(docSqlData)

                Dim hashKey As String = nodeLevel.ToString().PadLeft(5, "0"c) + parentNodeNo.ToString.PadLeft(5, "0"c)
                If Not htDeleteData.ContainsKey(hashKey) Then
                    htDeleteData.Add(hashKey, "")
                End If

            End If
        Next

    End Sub

    Protected Function updateSQLServerForGetDoc(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String) As Boolean

        Dim ret As Boolean = True

        If arrDOCSQLData.Count() > 0 Then

            Dim con As SqlConnection = Nothing
            Dim sqlCommand As SqlCommand = Nothing
            Dim tran As SqlTransaction = Nothing

            Dim conStr As String

            Dim updateDateTime As DateTime = DateTime.Now

            Try

                If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                    logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
                End If

                If Not Directory.Exists(logDirectory) Then
                    Directory.CreateDirectory(logDirectory)
                End If

                conStr = ""
                conStr += "Data Source=" + server + ";"
                conStr += "User ID=" + userId + ";"
                conStr += "Password=" + password + ";"
                conStr += "Initial Catalog=" + databaseName + ""

                con = New SqlConnection()
                con.ConnectionString = conStr

                con.Open()
                tran = con.BeginTransaction()

                sqlCommand = con.CreateCommand()
                sqlCommand.Transaction = tran

                Dim deleteSQL As String
                Dim syokaiFlg As Boolean = True
                Dim loopCounter As Integer = 1
                Dim updateCounter As Integer = 1
                deleteSQL = ""
                For Each deleteKey As String In htDeleteData.Keys()
                    Dim deleteNodeLevel As Integer
                    Dim deleteParentNodeNo As Integer

                    deleteNodeLevel = CInt(deleteKey.Substring(0, 5))
                    deleteParentNodeNo = CInt(deleteKey.Substring(5, 5))

                    If syokaiFlg Then
                        deleteSQL += " DELETE FROM W_DOC_RIDOC WHERE " + vbCrLf
                        syokaiFlg = False
                    Else
                        deleteSQL += " OR "
                    End If
                    deleteSQL += " ( ノードレベル=" + deleteNodeLevel.ToString() + " AND 親ノード番号=" + deleteParentNodeNo.ToString() + " ) " + vbCrLf

                    loopCounter += 1

                    If loopCounter > 100 Then
                        loopCounter = 0

                        sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                        sqlCommand.CommandText = deleteSQL
                        sqlCommand.ExecuteNonQuery()

                        updateCounter += 1
                        deleteSQL = ""
                        syokaiFlg = True

                    End If
                Next

                If Not deleteSQL = "" Then

                    sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                    sqlCommand.CommandText = deleteSQL
                    sqlCommand.ExecuteNonQuery()
                End If

                Dim insertSQL = ""
                loopCounter = 1
                updateCounter = 1
                syokaiFlg = True
                For Each sqlData As DOCSQLData In arrDOCSQLData
                    If syokaiFlg Then
                        insertSQL += " INSERT INTO W_DOC_RIDOC(ノードレベル,ノード番号,親ノード番号,フォルダ区分,文書番号,文章タイトル,RidocID,作成日付,作成時刻,作成PGM,更新日付,更新時刻,更新PGM) VALUES " + vbCrLf
                        syokaiFlg = False
                    Else
                        insertSQL += " , " + vbCrLf
                    End If

                    insertSQL += " ( " + vbCrLf
                    insertSQL += "   " + sqlData.nodeLevel.ToString() + " , " + vbCrLf
                    insertSQL += "   " + sqlData.nodeNo.ToString() + " , " + vbCrLf
                    insertSQL += "   " + sqlData.parentNodeNo.ToString() + " , " + vbCrLf
                    insertSQL += "   '" + sqlData.folderFlg + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.docNo + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.docTitle + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.ridocID + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "'  " + vbCrLf
                    insertSQL += " ) " + vbCrLf

                    loopCounter += 1

                    If loopCounter > 100 Then
                        loopCounter = 0

                        sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                        sqlCommand.CommandText = insertSQL
                        sqlCommand.ExecuteNonQuery()

                        updateCounter += 1
                        insertSQL = ""
                        syokaiFlg = True

                    End If
                Next

                If Not insertSQL = "" Then
                    sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                    sqlCommand.CommandText = insertSQL
                    sqlCommand.ExecuteNonQuery()

                    updateCounter += 1
                    insertSQL = ""
                End If

                tran.Commit()
                ret = True
            Catch ex As Exception
                If Not tran Is Nothing Then
                    tran.Rollback()
                End If
                ret = False
            Finally
                If Not con Is Nothing Then
                    If Not con.State = ConnectionState.Closed Then
                        con.Close()
                    End If
                    con.Dispose()
                End If

                If Not tran Is Nothing Then
                    tran.Dispose()
                End If
            End Try

        End If

        Return ret
    End Function

    Protected Function updateSQLServerForPDF(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String, ByVal sessionID As String) As Boolean

        Dim ret As Boolean = True
        If arrFILESQLData.Count() > 0 Then

            Dim con As SqlConnection = Nothing
            Dim sqlCommand As SqlCommand = Nothing
            Dim tran As SqlTransaction = Nothing

            Dim conStr As String

            Dim updateDateTime As DateTime = DateTime.Now

            Try

                If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                    logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
                End If

                If Not Directory.Exists(logDirectory) Then
                    Directory.CreateDirectory(logDirectory)
                End If

                conStr = ""
                conStr += "Data Source=" + server + ";"
                conStr += "User ID=" + userId + ";"
                conStr += "Password=" + password + ";"
                conStr += "Initial Catalog=" + databaseName + ""

                con = New SqlConnection()
                con.ConnectionString = conStr

                con.Open()
                tran = con.BeginTransaction()

                sqlCommand = con.CreateCommand()
                sqlCommand.Transaction = tran

                Dim deleteSQL As String
                Dim syokaiFlg As Boolean = True
                Dim loopCounter As Integer = 1
                Dim updateCounter As Integer = 1
                deleteSQL = ""
                deleteSQL += " DELETE FROM W_DOC_RIDOC_FILE WHERE セッションID = '" + sessionID + "' " + vbCrLf
                sqlLogWrite(deleteSQL, logDirectory + "\deleteSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                sqlCommand.CommandText = deleteSQL
                sqlCommand.ExecuteNonQuery()


                Dim insertSQL = ""
                loopCounter = 1
                updateCounter = 1
                syokaiFlg = True
                For Each sqlData As FILESQLData In arrFILESQLData
                    If syokaiFlg Then
                        insertSQL += " INSERT INTO W_DOC_RIDOC_FILE(セッションID,RidocID,ファイル番号,ファイル名,ファイルフルパス,作成日付,作成時刻,作成PGM,更新日付,更新時刻,更新PGM) VALUES " + vbCrLf
                        syokaiFlg = False
                    Else
                        insertSQL += " , " + vbCrLf
                    End If

                    insertSQL += " ( " + vbCrLf
                    insertSQL += "   '" + sessionID.ToString() + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.ridocID + "' , " + vbCrLf
                    insertSQL += "   " + sqlData.fileNo.ToString() + " , " + vbCrLf
                    insertSQL += "   '" + sqlData.fileName + "' , " + vbCrLf
                    insertSQL += "   '" + sqlData.filePath + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("yyyyMMdd") + "' , " + vbCrLf
                    insertSQL += "   '" + updateDateTime.ToString("HHmmss") + "' , " + vbCrLf
                    insertSQL += "   '" + "VBPG" + "'  " + vbCrLf
                    insertSQL += " ) " + vbCrLf

                    loopCounter += 1

                    If loopCounter > 100 Then
                        loopCounter = 0

                        sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                        sqlCommand.CommandText = insertSQL
                        sqlCommand.ExecuteNonQuery()

                        updateCounter += 1
                        insertSQL = ""
                        syokaiFlg = True

                    End If
                Next

                If Not insertSQL = "" Then
                    sqlLogWrite(insertSQL, logDirectory + "\insertSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + "_" + updateCounter.ToString() + ".SQL")

                    sqlCommand.CommandText = insertSQL
                    sqlCommand.ExecuteNonQuery()

                    updateCounter += 1
                    insertSQL = ""
                End If

                tran.Commit()
                ret = True
            Catch ex As Exception
                If Not tran Is Nothing Then
                    tran.Rollback()
                End If
                ret = False
            Finally
                If Not con Is Nothing Then
                    If Not con.State = ConnectionState.Closed Then
                        con.Close()
                    End If
                    con.Dispose()
                End If

                If Not tran Is Nothing Then
                    tran.Dispose()
                End If
            End Try
        End If

        Return ret
    End Function

    Protected Function getMaxNodeNo(ByVal server As String, ByVal userId As String, ByVal password As String, ByVal databaseName As String, ByVal logDirectory As String) As Boolean

        Dim ret As Boolean = True


        Dim con As SqlConnection = Nothing
        Dim sqlCommand As SqlCommand = Nothing
        Dim dataReader As SqlDataReader = Nothing


        Dim conStr As String

        Dim updateDateTime As DateTime = DateTime.Now

        Try

            If logDirectory.Substring(logDirectory.Length - 1) = "\" Then
                logDirectory = logDirectory.Substring(0, logDirectory.Length - 1)
            End If

            If Not Directory.Exists(logDirectory) Then
                Directory.CreateDirectory(logDirectory)
            End If

            conStr = ""
            conStr += "Data Source=" + server + ";"
            conStr += "User ID=" + userId + ";"
            conStr += "Password=" + password + ";"
            conStr += "Initial Catalog=" + databaseName + ""

            con = New SqlConnection()
            con.ConnectionString = conStr

            con.Open()

            sqlCommand = con.CreateCommand()

            Dim selectSQL As String = ""
            selectSQL += " SELECT A.ノードレベル as ノードレベル,Max(A.ノード番号) as MAXノード番号 FROM W_DOC_RIDOC A GROUP BY A.ノードレベル "

            sqlLogWrite(selectSQL, logDirectory + "\selectSQL_" + updateDateTime.ToString("yyyyMMddHHmmss") + ".SQL")
            sqlCommand.CommandText = selectSQL

            dataReader = sqlCommand.ExecuteReader()
            While dataReader.Read
                htNodeNo.Add(CInt(dataReader("ノードレベル")), CInt(dataReader("MAXノード番号")))
            End While


            ret = True
        Catch ex As Exception
            ret = False
        Finally
            If Not dataReader Is Nothing Then
                dataReader.Close()
            End If

            If Not sqlCommand Is Nothing Then
                sqlCommand.Dispose()
            End If

            If Not con Is Nothing Then
                If Not con.State = ConnectionState.Closed Then
                    con.Close()
                End If
                con.Dispose()
            End If

        End Try
        Return ret
    End Function

    Protected Sub sqlLogWrite(ByVal writeSQL As String, ByVal filePath As String)
        Dim logSQLWriter As StreamWriter = New StreamWriter(filePath, False, Encoding.GetEncoding("shift_jis"))
        logSQLWriter.Write(writeSQL)
        logSQLWriter.Close()
        logSQLWriter.Dispose()
        logSQLWriter = Nothing
    End Sub

    Protected Sub DisConnect()
        Try
            If Not m_ridocCabinet Is Nothing Then
                m_ridocCabinet = Nothing
                m_ridocSystem.Disconnect()
            End If
        Catch ex As Exception

        End Try
    End Sub


End Class
