@ECHO OFF
REM 既定時間(5分)を経過したファイル(pdf)を削除する
REM 零時直前のファイルがすぐに消えないように実行時刻を調整すること
REM   (引数) %1 対象フォルダ


REM ****** 削除する基準時刻を求める **************************
REM 【ARGV1】は時刻  【ARGV2】は加算／減算する時間（分単位）

SET ARGV1=%time%
SET ARGV2=-5

IF "%ARGV1:~3,1%" EQU "0" (SET /A MINUTE=%ARGV1:~4,1%) ELSE (SET /A MINUTE=%ARGV1:~3,2%)
IF "%ARGV1:~0,1%" EQU "0" (SET /A HOUR=%ARGV1:~1,1%)   ELSE (SET /A HOUR=%ARGV1:~0,2%)

SET /A MINTOTAL=HOUR*60+MINUTE+ARGV2

IF %MINTOTAL% LSS 0 SET /A MINTOTAL+=((-MINTOTAL/1440+1)*1440)
SET /A MINTOTAL%%=1440
SET /A HOUR=MINTOTAL / 60
SET /A MINUTE=MINTOTAL %% 60

IF %MINUTE% LSS 10 SET MINUTE=0%MINUTE%
IF %HOUR% LSS 10 SET HOUR=0%HOUR%

SET ref_time=%HOUR%:%MINUTE%
REM ***********************************************************

REM ****** 基準時刻以前のファイルを削除する *******************

REM 基準時刻以前のファイルの削除
for /f "tokens=2,4" %%i in ('dir %1 ^| findstr /I ".pdf .doc .xls .xlsx"') do (
  if %%i lss %ref_time% (
      del "%1\%%j"
  )
)

REM 前日以前のファイルは削除する
rem forfiles /P %1 /D -1   /C "cmd /c del %1\@file"

REM ***********************************************************

