﻿// JavaScript Document

$.ajaxSetup({ cache: false });

jQuery.fn.checked = function(){
	var returnval = '0';
	if(jQuery(this).prop('checked')){
		returnval = '1';
	}
    return returnval;
}

$(document).ready(function(){
	var errHTML = '<div id="dialogError">'+
					'<div id="dialogErrorContents">'+
					'</div>'+
				'</div>';
	$(errHTML).appendTo('body');
	
	$('#dialogError').dialog({
		autoOpen: false,
		title: "エラー",
		closeOnEscape: false,
		width : 500,
		modal: true,
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});
	
	window.name = "";
	var divAjax =
		'<div style="text-align:center;z-index:10000;" class="Shadow" id="divAjax">'+
			'<div  style="width:48px;height:48px;position:absolute;top:50%;margin-top:-24px;left:50%;margin-left:-24px;">'+
				'<img src="../webnais/images/loading.gif" width="48" height="48">'+
			'</div>'+
		'</div>';
	$(divAjax).appendTo('body');
	
	$('#divAjax').hide();
	
	$('.btnMenu').click(function(){
		var menuKbn = $(this).attr('data-menuKbn');
		var menuPrg = $(this).attr('data-menuPrg');
		switch(menuKbn){
			case 'call':
				$('#prgname').val(menuPrg);
				$('#menuForm').submit();
				break;
				
			case 'close':
				var closeHtml = $('#hdnWebDocAlias').val() + 'npclose.html';
				window.location.href = closeHtml;
				break;
		}
	});
	
	$('#btnHelp').click(function(){
		NPHelp();
	});
	
	$('#btnReLogin').click(function(){
		var reloginURL = topURL + $('#hdnWebDocAlias').val() + 'login.html';
		window.location.href = reloginURL;
	});
});

$(document).keydown(function(e){
	if (e.keyCode === 8) {
		var tag = e.target.nodeName.toLowerCase();
		var $target = $(e.target);
		if ((tag !== 'input' && tag !== 'textarea') || $target.attr('readonly') || $target.is(':disabled')) {
			return false;
		}
	}
	return true;
});

$(document).ajaxStart(function(){
	ajaxLoadingCreate();
});

$(document).ajaxComplete(function(){
	ajaxLoadingDelete();
});

jQuery.fn.ButtonDisable = function(){
	$(this).button('disable');
	$(this).removeClass("ui-state-hover");
	$(this).prop('tabIndex',-1);
}

jQuery.fn.ButtonEnable = function(){
	$(this).button('enable');
	$(this).prop('tabIndex',0);
}

function cm_sessionError(){
	var docAlias = $('#hdnWebDocAlias').val();
	var errorHtml = '<div style="width: 500px;margin: 100px auto;text-align: center;">'+
					'<input type="hidden" value="'+docAlias+'" id="hdnWebDocAlias">'+
					'<p>ログイン情報が無効です。</p>'+
					'<p>恐れ入りますが、始めからやり直してください。</p>'+
					'<input type="button" id="btnReLogin" value="ログインに戻る">'+
					'</div>';
	$('body').empty();
	$('body').append(errorHtml);
	$('#btnReLogin').on(
		'click',
		function(){
			var reloginURL = topURL + $('#hdnWebDocAlias').val() + 'login.html';
			window.location.href = reloginURL;
		}
	);
}

function ajaxLoadingCreate(){
	$('#divAjax').show();
}

function ajaxLoadingDelete(){
	$('#divAjax').hide();
}

function ajaxLoadingCreateDiv(){
	var divAjax =
		'<div style="text-align:center;" class="Shadow" id="divAjax">'+
			'<div  style="width:48px;height:48px;position:absolute;top:50%;margin-top:-24px;left:50%;margin-left:-24px;">'+
				'<img src="../../'+projectName+'/lib/loading.gif" with="48" heigh="48">'+
			'</div>'+
		'</div>';
	$(divAjax).appendTo('body');
	
	$('#'+divName).show();
}

function ajaxLoadingDeleteDiv(divName){
	$('#'+divName).hide();
	$('#'+divName).remove();
}

var $focusedInput;
// End of ready(funciton)
//--------------------------------------------------------

//--------------------------------------------------------
// ダイアログの表示
function cmAlert(setTitle,message,errKbn){
	if(setTitle !== ''){
		$('#dialogError').dialog({title: setTitle});
	}else {
		$('#dialogError').dialog({title: 'エラー'});
	}
	
	var errMsg = "OK";
	if(errKbn === "E001"){
		errMsg = "ログオフ";
	}
	
	$('#ajaxErrKbn').val(errKbn);
	$('#spnAjaxErrOK').text(errMsg);
	
	var errHtml =
		'<fieldset>'+
			'<label>'+message+'</label>'+
		'</fieldset>';
	/*
	$('#dialogAjaxErrContents').html(errHtml);
	$('#dialogAjaxErr').dialog('open');
	*/
	$('#dialogErrorContents').html(errHtml);
	$('#dialogError').dialog('open');
	
	/*
	$('#dialogAjaxErr').focus();
	$('#btnAjaxErrOK').focus();
	*/
}

function cmCreateZoomDialog(zoomTitle){
	$('#dialogZoom').dialog({
		autoOpen: false,
		title: zoomTitle,
		closeOnEscape: true,
		modal: true,
		width: 600,
		close : function(){
			$('#' + focusInput).focus();
		}
	});
}

//--------------------------------------------------------
// ヘッダ・メニューの表示
/*
function cmDispHeader(){
	var ssid=jobno;
	$("#myHeader").load("../aw/session/"+ssid+"_h.html",function() {
		$("#myMenu").load("../aw/session/"+ssid+"_m.html",function() {
			$('.menu').fixedMenu();
		});
	});
}
*/

//-----------------------------------------------
//Ajaxでxmlを取得

function cmGetXmlData(param,disDiv){
	var retData;
	//ajaxLoadingCreate();

	$.ajaxSetup({ cache: false });	

	$.ajax({
		async : false,
		url: ajaxURL,
		data : param,
		dataType:'xml',
		scriptCharset: 'utf-8',
		success : function(xml){
			$('#ssid').val($(xml).find('ssid').text());
			var kbn = $(xml).find('ret').text();
			var msg = $(xml).find('message').text();
			$('#' + disDiv).text("");
			
			if(kbn !== 'I001'){
				if(!disDiv){
					cmAlert("警告",msg,kbn);
				}else {
					$('#' + disDiv).text(msg);
				}
			}
			retData = xml;
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
				cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
		}
	});

	return retData;
}


// ajax通信が成功した場合、指定の処理を行う
var AjaxRetData;
function cmAjaxFunction(param,callback,divName){
	
	//ajaxLoadingCreate();

	$.ajaxSetup({ cache: false });	

	$.ajax({
		async : true,
		url: ajaxURL,
		data : param,
		dataType:'xml',
		scriptCharset: 'utf-8',
		success : function(xml){
			$('#ssid').val($(xml).find('jobno').text());
			var kbn = $(xml).find('kbn').text();
			var msg = $(xml).find('message').text();
			if(divName){
				ajaxLoadingDeleteDiv(divName);
			}else {
				ajaxLoadingDelete();
			}
			if(kbn != 'I001'){
				cmAlert("警告",msg,kbn);
			}
			AjaxRetData = xml;
			callback();
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
			cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
			if(divName){
				ajaxLoadingDeleteDiv(divName);
			}else {
				ajaxLoadingDelete()
			}
		}
	});
}
//-----------------------------------------------
//aJaxエラー時の処理

function cmAjaxError(XMLHttpRequest, textStatus, errorThrown){
	
	var errHtml =
		'<fieldset>'+
			'<label>'+errorThrown+'</label>'+
		'</fieldset>';
	$('#dialogErrorContents').html(errHtml);
	$('#dialogError').dialog('open');
					
	
}


//-----------------------------------------------
//xml→配列変換

function cmXmlToArray(xml,rectag){

	retData	=	new Array();

	//	get result
	list = xml.getElementsByTagName(rectag);
	if (list == null){
		return retData;
	}

	for(recpos = 0; recpos < list.length; recpos++)	{
		node = list.item(recpos);
		rec = new Array();
		for(cellpos = 0; cellpos < node.childNodes.length; cellpos++){
			cellData =node.childNodes[cellpos];
			//case Element（nodeType=1)
			if ( cellData.nodeType == 1){
				key = cellData.nodeName;
				val	=	"";
				if ( cellData.hasChildNodes()){
					if(cellData.firstChild.textContent){
						val = cellData.firstChild.textContent;
					}else if(cellData.firstChild.text){
						val = cellData.firstChild.text;
					}else {
					}
				}
				rec[key] = val;
				
				
				if(cellData.attributes.length > 0){
					for(var i=0; i<cellData.attributes.length; i++){
						rec[key+"-" +cellData.attributes[i].name] = cellData.attributes[i].value;
					}
				}
				
			} 
		}
		retData[recpos]	=	rec;
	}

	return retData;
}

function cmXmlToList(xml,rectag){

	retData	=	new Array();

	//	get result
	list = xml.getElementsByTagName(rectag);
	if (list == null){
		return retData;
	}

	for(recpos = 0; recpos < list.length; recpos++)	{
		node = list.item(recpos);
		rec = new Array();
		var line = 0;
		for(cellpos = 0; cellpos < node.childNodes.length; cellpos++){
			cellData =node.childNodes[cellpos];
			//case Element（nodeType=1)
			if ( cellData.nodeType == 1){
				key = cellData.nodeName;
				val	=	"";
				if ( cellData.hasChildNodes()){
					if(cellData.firstChild.textContent){
						val = cellData.firstChild.textContent;
					}else if(cellData.firstChild.text){
						val = cellData.firstChild.text;
					}else {
					}
				}
				rec[line] = val;
				line = line + 1;
			}
		}
		retData[recpos]	=	rec;
	}

	return retData;
}

function cmXmlToSubGrid(xml,rectag,linetag){
	var subGridArr = [];
	var rootCount = 0;
	$(xml).find(rectag).map(function(){
		var lineCount = 0;
		var lineArr = [];
		$(this).find(linetag).map(function(){
			var children = $(this).children();
			var childArr = [];
			for(var i=0; i<children.length; i++){
				childArr[children[i].tagName] = $(this).find(children[i].tagName).text();
			}
			lineArr[lineCount] = childArr;
			lineCount = lineCount + 1;
		});
		subGridArr[rootCount] = lineArr;
		rootCount = rootCount + 1;
	})
	return subGridArr;
}


function cmXmlToArraySub(xml,rectag,rowID){
	var node = xml;
	retData	=	new Array();
	var nodeNo = rowID*2-1;

	//	get result
	//list = xml.getElementsByTagName(rectag);
	var browserIE;
	if (/*@cc_on!@*/false) {
		browserIE = true;
	}else {
		browserIE = false;
	}
	
	if(browserIE){
		list = node.childNodes[1].childNodes[1].childNodes[rowID-1].getElementsByTagName(rectag);
	}else {
		list = node.childNodes[0].childNodes[3].childNodes[nodeNo].getElementsByTagName(rectag);
	}
	
	if (list == null){
		return retData;
	}

	for(recpos = 0; recpos < list.length; recpos++)	{
		node = list.item(recpos);
		rec = new Array();
		for(cellpos = 0; cellpos < node.childNodes.length; cellpos++){
			cellData =node.childNodes[cellpos];
			//case Element（nodeType=1)
			if ( cellData.nodeType == 1){
				key = cellData.nodeName;
				val	=	"";
				if ( cellData.hasChildNodes()){
					if(cellData.firstChild.textContent){
						val = cellData.firstChild.textContent;
					}else if(cellData.firstChild.text){
						val = cellData.firstChild.text;
					}else {
					}
				}
				rec[key] = val;
			} 
		}
		retData[recpos]	=	rec;
	}

	return retData;
}

//-----------------------------------------------
//グリッドの表示

function cmCreateGrid(gridOptions,targetGrid){
	$(targetGrid).GridUnload();
	$(targetGrid).jqGrid(gridOptions);
}

//--------------------------------------------------------
// Zoomのクローズ

function cmHideZoomPanel(gridID){
	$('#zoomPanel').empty();
	$('#grayPanel').hide();
	$('#zoomPanel').hide();
	$('#btnSrch').focus();
}



function cmSetXML(xml,parent){
	if(parent){
		$('#'+parent).find('*[data-tag]').each(
			function(){
				var tagName = $(this).attr('data-tag');
				if($(this).is('a')){
					$(this).attr('href',$(xml).find(tagName).text());
					
				}else if($(this).is('span')){
					$(this).html($(xml).find(tagName).text());
					
				}else if($(this).is('label')){
					$(this).html($(xml).find(tagName).text());
					
				}else if($(this).is('textarea')){
					$(this).val($(xml).find(tagName).text());
					
				}else if($(this).is('input')){
					switch($(this).attr('type')){
						case 'text' :
							if($(this).hasClass('num')){
								if($(xml).find(tagName).text() === ''){
								}else {
									var realVal = $(xml).find(tagName).text().replace(/,/g,'');
									realVal = realVal.replace(/(^\s+)|(\s+$)/g,'');
									var dispVal = setComma(realVal);
									$(this).val(dispVal);
								}
							}else {
								$(this).val($(xml).find(tagName).text());
							}
							break;
							
						case 'checkbox' :
							if($(xml).find(tagName).text() === '1'){
								$(this).prop('checked',true);
							}else {
								$(this).prop('checked',false);
							}
							break;
						
						default :
							$(this).val($(xml).find(tagName).text());
							break;
					}
				}else {
					$(this).val($(xml).find(tagName).text());
				}
			}
		);
	}else{
		$('*[data-tag]').map(
			function(){
				var tagName = $(this).attr('data-tag');
				if($(this).is('a')){
					$(this).attr('href',$(xml).find(tagName).text());
					
				}else if($(this).is('span')){
					$(this).html($(xml).find(tagName).text());
					
				}else if($(this).is('textarea')){
					$(this).val($(xml).find(tagName).text());
					
				}else if($(this).is('input')){
					switch($(this).attr('type')){
						case 'text' :
							if($(this).hasClass('num')){
								if($(xml).find(tagName).text() === ''){
								}else {
									var realVal = $(xml).find(tagName).text().replace(/,/g,'');
									realVal = realVal.replace(/(^\s+)|(\s+$)/g,'');
									var dispVal = setComma(realVal);
									$(this).val(dispVal);
								}
							}else {
								$(this).val($(xml).find(tagName).text());
							}
							break;
							
						case 'checkbox' :
							if($(xml).find(tagName).text() === '1'){
								$(this).prop('checked',true);
							}else {
								$(this).prop('checked',false);
							}
							break;
						
						default :
							$(this).val($(xml).find(tagName).text());
							break;
					}
				}else {
					$(this).val($(xml).find(tagName).text());
				}
			}
		);
	}
}

function cmCreateSelect(formatOpt,selectID){
	for(var i=0; i<formatOpt.length; i++){
		var val = formatOpt.eq(i).attr('value');
		var txt = formatOpt.eq(i).text();
		var option = '<option value="'+val+'">'+txt+'</option>';
		$('#'+selectID).append(option);
	}
}

function cmSetGridSelectVal(formatOpt){
	var selectVal = '';
	var j = 0;
	for(var i=0; i<formatOpt.length; i++){
		var val = formatOpt.eq(i).attr('value');
		var txt = formatOpt.eq(i).text();
		selectVal = selectVal + val + ':' + txt;
		j++;
		if( j<formatOpt.length)
		{
			selectVal = selectVal + ';';
		}
	}
	return selectVal;
}

function cmArrayFromGrid(grid){
	var getArray = [];
	var gridIDs = $(grid).jqGrid('getDataIDs');
	for(var j = 0; j < gridIDs.length; j++) {
		var gridRow = $(grid).jqGrid('getRowData',gridIDs[j]);
		getArray[j] = gridRow;
	}
	
	return getArray;
}

function cmArrayFromXML(tagtype){
	
	var array = [];
	var count = 0;
	
	if(tagtype){
		$('*[data-xml="'+tagtype+'"]').map(function(){
			var obj = [];
			obj[$(this).attr('data-tag')] = $(this).val();
			array[count] = obj;
			count = count + 1;
		})
	}else {
		$('*[data-xml="tag"]').map(function(){
			var obj = [];
			obj[$(this).attr('data-tag')] = $(this).val();
			array[count] = obj;
			count = count + 1;
		})
	}
	
	return array;
}

function cmXmlFromArray(array,root){
	var xml = '';
	xml = '<data>\n';
	xml = xml + '<' + root + '>\n';
	
	for(var i=0; i<array.length; i++){
		var obj = array[i];
		for(var key in obj){
			xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
		}
	}
	
	xml = xml + '</' + root + '>\n';
	xml = xml + '</data>';
	return xml;
}

function cmXmlFromGridNoRoot(gridData,gridline){
	var array = [];
	var count = 0;
	$('*[data-xml="tag"]').map(function(){
		var obj = [];
		if($(this).is('span')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else if($(this).is('input')){
			switch($(this).attr('type')){
				case 'number' :
					obj[$(this).attr('data-tag')] = $(this).val().replace(/,/g,'');
					break;
				case 'checkbox' :
					obj[$(this).attr('data-tag')] = $(this).checked();
					break;
				
				default :
					obj[$(this).attr('data-tag')] = $(this).val();
					break;
			}
		}else if($(this).is('label')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else {
			obj[$(this).attr('data-tag')] = $(this).val();
		}
		
		array[count] = obj;
		count = count + 1;
	})
	
	var xml = '';
	xml = '<data>\n';
	
	for(var i=0; i<array.length; i++){
		var obj = array[i];
		for(var key in obj){
			xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
		}
	}
	for(var i=0; i<gridData.length; i++){
		var gridArray = [];
		for(var j=0; j<gridData[i].length; j++){
			gridArray[j] = gridData[i][j];
		}
		
		for(var k=0; k<gridArray.length; k++){
			var obj = gridArray[k];
			var lineXML = "";
			for(var key in obj){
				var splitKey = key.split('-');
				if(splitKey.length > 1){
					if(lineXML.search(splitKey[0]) != -1){
						lineXML = lineXML.replace('<'+splitKey[0]+'>', '<'+splitKey[0]+' '+splitKey[1]+'="'+cmReplaceXml(obj[key]))+'">';
					}else {
						lineXML = lineXML + '<' + splitKey[0] + ' '+splitKey[1]+'="'+cmReplaceXml(obj[key])+'">/' + splitKey[0] + '/</' + splitKey[0]+ '>\n';
					}
				}else {
					if(lineXML.search(key) != -1){
						lineXML = lineXML.replace('/'+key+'/',cmReplaceXml(obj[key]));
					}else {
						lineXML = lineXML + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
					}
				}
			}
			xml = xml + '<' + gridline[i] + '>'+ lineXML +'</' + gridline[i] + '>\n';
			lineXML = "";
			/*
			xml = xml + '<' + gridline[i] + '>\n';
			var obj = gridArray[k];
			for(var key in obj){
				xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
			}
			xml = xml + '</' + gridline[i] + '>\n';
			*/
		}
	}
	
	xml = xml + '</data>';
	
	return xml;
}

function cmXmlFromGrid(root,gridData,gridroot,gridline){
	var array = [];
	var count = 0;
	$('*[data-xml="tag"]').map(function(){
		var obj = [];
		if($(this).is('span')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else if($(this).is('input')){
			switch($(this).attr('type')){
				case 'number' :
					obj[$(this).attr('data-tag')] = $(this).val().replace(/,/g,'');
					break;
				case 'checkbox' :
					obj[$(this).attr('data-tag')] = $(this).checked();
					break;
				
				default :
					obj[$(this).attr('data-tag')] = $(this).val();
					break;
			}
		}else if($(this).is('label')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else {
			obj[$(this).attr('data-tag')] = $(this).val();
		}
		
		array[count] = obj;
		count = count + 1;
	})
	
	var xml = '';
	xml = '<data>\n';
	xml = xml + '<' + root + '>\n';
	
	for(var i=0; i<array.length; i++){
		var obj = array[i];
		for(var key in obj){
			xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
		}
	}
	for(var i=0; i<gridData.length; i++){
		var gridArray = [];
		for(var j=0; j<gridData[i].length; j++){
			gridArray[j] = gridData[i][j];
		}
		
		xml = xml + '<'+gridroot[i]+'>\n';
		for(var k=0; k<gridArray.length; k++){
			var obj = gridArray[k];
			var lineXML = "";
			for(var key in obj){
				var splitKey = key.split('-');
				if(splitKey.length > 1){
					if(lineXML.search(splitKey[0]) != -1){
						lineXML = lineXML.replace('<'+splitKey[0]+'>', '<'+splitKey[0]+' '+splitKey[1]+'="'+cmReplaceXml(obj[key]))+'">';
					}else {
						lineXML = lineXML + '<' + splitKey[0] + ' '+splitKey[1]+'="'+cmReplaceXml(obj[key])+'">/' + splitKey[0] + '/</' + splitKey[0]+ '>\n';
					}
				}else {
					if(lineXML.search(key) != -1){
						lineXML = lineXML.replace('/'+key+'/',cmReplaceXml(obj[key]));
					}else {
						lineXML = lineXML + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
					}
				}
			}
			xml = xml + '<' + gridline[i] + '>'+ lineXML +'</' + gridline[i] + '>\n';
			lineXML = "";
		}
		xml = xml + '</' + gridroot[i] + '>\n';
	}
	
	xml = xml + '</' + root + '>\n';
	xml = xml + '</data>';
	
	return xml;
}

function cmXmlFromGridSub(root,gridData,gridroot,gridline,subgirdline){
	var array = [];
	var count = 0;
	var subgrid = 0;
	$('*[data-xml="tag"]').map(function(){
		var obj = [];
		if($(this).is('span')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else if($(this).is('input')){
			switch($(this).attr('type')){
				case 'number' :
					obj[$(this).attr('data-tag')] = $(this).val().replace(/,/g,'');
					break;
				case 'checkbox' :
					obj[$(this).attr('data-tag')] = $(this).checked();
					break;
				
				default :
					obj[$(this).attr('data-tag')] = $(this).val();
					break;
			}
		}else if($(this).is('label')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else {
			obj[$(this).attr('data-tag')] = $(this).val();
		}
		
		array[count] = obj;
		count = count + 1;
	})
	
	var xml = '';
	xml = '<data>\n';
	xml = xml + '<' + root + '>\n';
	
	for(var i=0; i<array.length; i++){
		var obj = array[i];
		for(var key in obj){
			xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
		}
	}
	for(var i=0; i<gridData.length; i++){
		var gridArray = [];
		for(var j=0; j<gridData[i].length; j++){
			gridArray[j] = gridData[i][j];
		}
		
		xml = xml + '<'+gridroot[i]+'>\n';
		for(var k=0; k<gridArray.length; k++){
			xml = xml + '<' + gridline[i] + '>\n';
			
			var obj = gridArray[k];
			for(var key in obj){
				if(obj[key] instanceof Array){
					xml = xml + '<' + key+ '>';
					for(var x=0; x<obj[key].length; x++){
						xml = xml + '<' + subgirdline[subgrid] + '>';
						var subobj = obj[key][x];
						for(var subkey in subobj){
							xml = xml + '<' + subkey+ '>' + cmReplaceXml(subobj[subkey]) + '</' + subkey+ '>\n';
						}
						xml = xml + '</' + subgirdline[subgrid] + '>';
					}
					xml = xml + '</' + key+ '>\n';
					subgrid = subgrid + 1;
				}else {
					xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
				}
			}
			xml = xml + '</' + gridline[i] + '>\n';
			subgrid = 0;
		}
		xml = xml + '</' + gridroot[i] + '>\n';
	}
	
	xml = xml + '</' + root + '>\n';
	xml = xml + '</data>';
	
	return xml;
}

function cmXmlFromGridGrandSub(root,gridData,gridroot,gridline,subgridline,grandsubgridline){
	var array = [];
	var count = 0;
	var subgrid = 0;
	var grandsubgrid = 0;
	$('*[data-xml="tag"]').map(function(){
		var obj = [];
		if($(this).is('span')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else if($(this).is('input')){
			switch($(this).attr('type')){
				case 'number' :
					obj[$(this).attr('data-tag')] = $(this).val().replace(/,/g,'');
					break;
				case 'checkbox' :
					obj[$(this).attr('data-tag')] = $(this).checked();
					break;
				
				default :
					obj[$(this).attr('data-tag')] = $(this).val();
					break;
			}
		}else if($(this).is('label')){
			obj[$(this).attr('data-tag')] = $(this).text();
		}else {
			obj[$(this).attr('data-tag')] = $(this).val();
		}
		
		array[count] = obj;
		count = count + 1;
	})
	
	var xml = '';
	xml = '<data>\n';
	xml = xml + '<' + root + '>\n';
	
	for(var i=0; i<array.length; i++){
		var obj = array[i];
		for(var key in obj){
			xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
		}
	}
	for(var i=0; i<gridData.length; i++){
		var gridArray = [];
		for(var j=0; j<gridData[i].length; j++){
			gridArray[j] = gridData[i][j];
		}
		
		xml = xml + '<'+gridroot[i]+'>\n';
		for(var k=0; k<gridArray.length; k++){
			xml = xml + '<' + gridline[i] + '>\n';
			
			var obj = gridArray[k];
			for(var key in obj){
				if(obj[key] instanceof Array){
					xml = xml + '<' + key+ '>';
					for(var x=0; x<obj[key].length; x++) {
						xml = xml + '<' + subgridline[subgrid] + '>';
						var subobj = obj[key][x];
						for(var subkey in subobj){
							if(subobj[subkey] instanceof Array){
								xml = xml + '<' + subkey + '>';
								for(var y=0; y<subobj[subkey].length; y++){
									xml = xml + '<' + grandsubgridline[grandsubgrid] + '>';
									var grandsubobj = subobj[subkey][y];
									for(var grandsubkey in grandsubobj){
										xml = xml + '<' + grandsubkey+ '>' + cmReplaceXml(grandsubobj[grandsubkey]) + '</' + grandsubkey+ '>\n';
									}
									xml = xml + '</' + grandsubgridline[grandsubgrid] + '>';
								}
								xml = xml + '</' + subkey+ '>\n';
								grandsubgrid = grandsubgrid + 1;
							}else {
								xml = xml + '<' + subkey+ '>' + cmReplaceXml(subobj[subkey]) + '</' + subkey+ '>\n';
							}
						}
						xml = xml + '</' + subgridline[subgrid] + '>';
						grandsubgrid = 0;
					}
					xml = xml + '</' + key+ '>\n';
					subgrid = subgrid + 1;
				}else {
					xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
				}
			}
			xml = xml + '</' + gridline[i] + '>\n';
			subgrid = 0;
		}
		xml = xml + '</' + gridroot[i] + '>\n';
	}
	
	xml = xml + '</' + root + '>\n';
	xml = xml + '</data>';
	
	return xml;
}

function cmReplaceXml(str){
	var reStr = '';
	if(str){
		reStr = str.toString();
		reStr = reStr.replace(/✓/g,'1');
		reStr = reStr.replace(/&/g,'&amp;');
		reStr = reStr.replace(/</g,'&lt;');
		reStr = reStr.replace(/>/g,'&gt;');
		reStr = reStr.replace(/"/g,'&quot;');
		reStr = reStr.replace(/,/g,'&#44;');
	}
	return reStr;
}

function cmCheckGridError(gridID){
	var gridCheck = true;
	$(gridID + ' tbody tr td').map(
		function(){
			if($(this).hasClass('GridError')){
				gridCheck = false;
			}
		}
	);
	
	return gridCheck;
}

function cmCheckGridRowError(gridID,rowID){
	var gridCheck = true;
	var tr = $('#' + gridID )[0].rows.namedItem(rowID);

	for( var i = 0; i < tr.cells.length; i++ ){
		var td = tr.cells[i];
		if( $(td).hasClass('GridError') ) {
			gridCheck = false;
			break;
		}
	}

	return gridCheck;
}

function cmSetReadonly(){
	$('*[data-tag]').map(function(){
		var tagName = $(this).attr('data-tag');
		var xmlTag = $(this).attr('data-xml');
		
		var replaceText = '';
		var replaceStyle = '';
		var replaceTag = '';
		if($(this).is('input')){
			switch($(this).attr('type')){
				case 'checkbox' :
					if($(this).checked() == '1'){
						replaceText = '&#10003';
					}
					if(!xmlTag){
						replaceTag = '<input type="text" class="inp valid" style="width:16px;" value="'+replaceText+'" readonly="readonly" data-xml="'+xmlTag+'" data-tag="'+tagName+'">';
					}else {
						replaceTag = '<input type="text" class="inp valid" style="width:16px;" value="'+replaceText+'" readonly="readonly" data-tag="'+tagName+'">';
					}
					break;
					
				default :
					break;
			}
		}else if($(this).is('select')){
			var id = $(this).attr('id');
			replaceText = $('#'+id+' option:selected').text();
			replaceStyle = $(this).attr('style');
			if(!xmlTag){
				replaceTag = '<input type="text" class="inp valid" style="'+replaceStyle+'" value="'+replaceText+'" readonly="readonly" data-xml="'+xmlTag+'" data-tag="'+tagName+'">';
			}else {
				replaceTag = '<input type="text" class="inp valid" style="'+replaceStyle+'" value="'+replaceText+'" readonly="readonly" data-tag="'+tagName+'">';
			}
		}
		
		$('td[data-replace="'+tagName+'"]').map(function(){
			if(replaceTag != ''){
				$(this).get(0).innerHTML = (replaceTag);
			}
		})
		$(this).attr('readonly','readonly');
	});
}

function checkDateFormat(value){
	var check = false;
	var validDate = value;
	if(!validDate.match(/^\d{4}\/\d{2}\/\d{2}$/)){
	}else {
		var validY = validDate.substr(0,4) -0;
		var validM = validDate.substr(5,2) -1;
		var validD = validDate.substr(8,2) -0;
		
		if(validY >= 0 && validM >= 0 && validM <= 11 && validD >= 1 && validD <= 31){
			var validDt = new Date(validY,validM,validD);
			if(isNaN(validDt)){
				check = false;
			}else if(validDt.getFullYear() == validY && validDt.getMonth() == validM && validDt.getDate() == validD){
				check = true;
			}else {
				check = false;
			}
		}else {
			check = false;
		}
	}
	
	return check;
}

function cmSetGridRowColor(gridID){
	var rowIDs = $('#' + gridID).getDataIDs(); 
	for( i = 0; i < rowIDs.length; i++){
		if (i % 2 == 0) {
			tr = $('#' + gridID)[0].rows.namedItem(rowIDs[i]);
			$(tr).removeClass('ui-widget-content');
			$(tr).addClass('gridColor');
		}
	}
}

function cmSetFigure(str){
	var num = new String(str).replace(/,/g, "");
	
	while(num != (num = num.replace(/^(-?\d+)(\d{3})/, "$1,$2")));
	
	return num;
}

function cmSetGridRowCount(gridH,rowH){
	var rowCount = Math.floor(gridH/rowH)
	return 	rowCount;
}

function cmXmlFromInput(gridline,parent){
	var array = [];
	var count = 0;
	if(parent){
		$('#'+parent).find('*[data-xml="tag"]').each(function(){
            var obj = [];
			if($(this).is('span')){
				obj[$(this).attr('data-tag')] = $(this).text();
			}else if($(this).is('input')){
				switch($(this).attr('type')){
					case 'number' :
						obj[$(this).attr('data-tag')] = $(this).val().replace(/,/g,'');
						break;
					case 'checkbox' :
						obj[$(this).attr('data-tag')] = $(this).checked();
						break;
					
					default :
						obj[$(this).attr('data-tag')] = $(this).val();
						break;
				}
			}else if($(this).is('label')){
				obj[$(this).attr('data-tag')] = $(this).text();
			}else {
				obj[$(this).attr('data-tag')] = $(this).val();
			}
			
			array[count] = obj;
			count = count + 1;
		});
	}else {
		$('*[data-xml="tag"]').map(function(){
			var obj = [];
			if($(this).is('span')){
				obj[$(this).attr('data-tag')] = $(this).text();
			}else if($(this).is('input')){
				switch($(this).attr('type')){
					case 'number' :
						obj[$(this).attr('data-tag')] = $(this).val().replace(/,/g,'');
						break;
					case 'checkbox' :
						obj[$(this).attr('data-tag')] = $(this).checked();
						break;
					
					default :
						obj[$(this).attr('data-tag')] = $(this).val();
						break;
				}
			}else if($(this).is('label')){
				obj[$(this).attr('data-tag')] = $(this).text();
			}else {
				obj[$(this).attr('data-tag')] = $(this).val();
			}
			
			array[count] = obj;
			count = count + 1;
		})
	}
	var xml = '';
	xml = '<data>\n';
	if(gridline){ xml = xml + '<' + gridline + '>\n'; }
	
	for(var i=0; i<array.length; i++){
		var obj = array[i];
		for(var key in obj){
			xml = xml + '<' + key+ '>' + cmReplaceXml(obj[key]) + '</' + key+ '>\n';
		}
	}
	if(gridline){ xml = xml + '</' + gridline + '>\n'; }
	xml = xml + '</data>';
	
	return xml;
}

function checkProhibition(inpStr){
	chk = inpStr;
	var errStr = "";
	if (chk.match(/&/i) == "&") errStr = errStr +"半角の & は入力できません\n";
	if (chk.match(/,/i) == ",") errStr = errStr +"半角の , は入力できません\n";
	if (chk.match(/%/i) == "%") errStr = errStr +"半角の % は入力できません\n";
	if (chk.match(/#/i) == "#") errStr = errStr +"半角の # は入力できません\n";
	if (chk.match(/\+/i) == "\+") errStr = errStr +"半角の \+ は入力できません\n";
	if (chk.match(/\\/i) == "\\") errStr = errStr +"半角の \\ は入力できません\n";
	if (chk.match(/</i) == "<") errStr = errStr +"半角の < は入力できません\n";
	if (chk.match(/>/i) == ">") errStr = errStr +"半角の > は入力できません\n";
	if (chk.match(/"/i) == '"') errStr = errStr +'半角の " は入力できません\n';
	if (chk.match(/'/i) == "'") errStr = errStr +"半角の ' は入力できません\n";
	if (chk.match(/;/i) == ";") errStr = errStr +"半角の ; は入力できません\n";
	if (chk.match(/\*/i) == "\*") errStr = errStr +"半角の * は入力できません\n";
	if (chk.match(/%/i) == "%") errStr = errStr +"半角の % は入力できません\n";
	if(errStr !== "") errStr = "※入力内容に禁則文字がく含まれています"
	return errStr;
}

function xmlToMultiStageArray(xml,rectag,linetag,subLinetag){
	var subViewArr = [];
	var rootCount = 0;
	$(xml).find(rectag).map(function(){

		var recChildren = $(this).children();
		var tmpSubViewArr = [];
		for(var i=0; i<recChildren.length; i++){
			tmpSubViewArr[recChildren[i].tagName] = $(this).find(recChildren[i].tagName).text();
		}

		for( var j = 0; j < linetag.length; j++ ){
			var lineCount = 0;
			var lineArr = [];
			$(this).find(linetag[j]).map(function(){

				var lineChildren = $(this).children();
				var tmpLineArr =[];
				for(var i=0; i<lineChildren.length; i++){
					tmpLineArr[lineChildren[i].tagName] = $(this).find(lineChildren[i].tagName).text();
				}

				for( var q = 0; q < subLinetag.length; q++){
					var childArr = [];
					var childCount = 0;
					$(this).find(subLinetag[q]).map(function(){
						var children = $(this).children();
						var tmpChildArr = [];
						for(var i=0; i<children.length; i++){
							tmpChildArr[children[i].tagName] = $(this).find(children[i].tagName).text();
						}
						childArr[childCount] = tmpChildArr;
						childCount = childCount + 1;
					});
					
					tmpLineArr[subLinetag[q]] = childArr;
				}

				lineArr[lineCount] = tmpLineArr;
				lineCount = lineCount + 1;
			});
			tmpSubViewArr[linetag[j]] = lineArr;
		}
		subViewArr[rootCount] = tmpSubViewArr;
		rootCount = rootCount + 1;
	})
	return subViewArr;
}





