// JavaScript Document
var web_doc_alias = '';
var unkoCd = '';
var sodairiCd = '';
var mizusakiCd = '';
var validPtn = '';
var dispKbn = '';
$(document).ready(function(){
	setupZoomModal('harbor');
	setupZoomModal('dairiten');
	web_doc_alias = $('#web_doc_alias').val();
	
	// ズームのコールバック関数を設定
	// zoomCallBackFncはzoom_agency.js内で宣言
	zoomCallBackFnc['callBackJosen'] = callBackJosen;
	zoomCallBackFnc['callBackGesen'] = callBackGesen;
	
    $.validator.addMethod(
        'mojichk',
        function(value,element,num){
            count = textbyte(value);
            if (this.optional(element)){
                return true;
            } else if (count > num){
                return false;
            } else {
                return true;
            }
        },       
    );
	//▼禁止文字チェック(& , % # + \)
    $.validator.addMethod(
        'kinshi',
        function(value,element){
            if (this.optional(element)){
                return true;
            } else if (value.match(/&/i) == "&"){
                return false;
            } else if (value.match(/,/i) == ","){
                return false;
            } else if (value.match(/%/i) == "%"){
                return false;
            } else if (value.match(/#/i) == "#"){
                return false;
            } else if (value.match(/\+/i) == "\+"){
                return false;
            } else if (value.match(/\\/i) == "\\"){
                return false;
            } else if (value.match(/</i) == "<"){
                return false;
            } else if (value.match(/>/i) == ">"){
                return false;
            } else {
                return true;
            }
        },'入力できない文字が含まれています。'  
    );

	$('#form_A114').validate({
		ignore: [], //type="hidden"項目のエラーチェックを可能とする
		rules : {
			inpZenkou : {
                mojichk: 20,
				kinshi: true
			},
			inpZenRinsetsuDate : {
				required: function(){return $('#hdnL2').val() === 'True' && $('#slctZenRinsetsu').val() !== '';}
			},
			inpZenRinsetsuTime : {
				required: function(){return $('#hdnL2').val() === 'True' && $('#slctZenRinsetsu').val() !== '';}
			},
			inpJosenTokki : {
				mojichk: 20,
				kinshi: true
			},
//			slctJosenSetsugangen : {
//				required: function(){return $('#hdnL3').val() === 'True' && $('#kyodo_k').val() !== '1' && $('#hdnJosenGanpeki').val() === '1';}
//			},
			inpJosenDate : {
				required: function(){return $('#hdnL4').val() === 'True';},
			},
			inpJosenTime : {
				required: function(){return $('#hdnL4').val() === 'True';}
			},
			inpGesenTokki : {
				mojichk: 20,
				kinshi: true
			},
//			slctGesenSetsugangen : {
//				required: function(){return $('#hdnL5').val() === 'True' && $('#kyodo_k').val() !== '2' && $('#hdnGesenGanpeki').val() === '1';} ,
//			},
			inpJiRinsetsuDate : {
				required: function(){return $('#hdnL6').val() === 'True' && $('#slctJiRinsetsu').val() !== '';}
			},
			inpJiRinsetsuTime : {
				required: function(){return $('#hdnL6').val() === 'True' && $('#slctJiRinsetsu').val() !== '';}
			},
			inpJikou : {
				mojichk: 20,
				kinshi: true
			},
			inpKissuiF : {
//				required: function(){return $('#hdnL9').val() === 'True' && !$('#inpKissuiMiteiCheck').prop('checked');} ,
				max : 25.99,
				min : 0.01
			},
			inpKissuiA : {
//				required: function(){return $('#hdnL9').val() === 'True' && !$('#inpKissuiMiteiCheck').prop('checked');} ,
				max : 25.99,
				min : 0.01
			},
			inpTsumini : {
				required: function(){return $('#hdnL10').val() === 'True' && $('#slctTsumini').val() === 'OT';} ,
				mojichk: 10,
				kinshi: true
			},
			rdoKikenbutsu : {
				required: function(){return $('#hdnL10').val() === 'True';} ,
			},
			rdoKeneki : {
				required: function(){return $('#hdnL11').val() === 'True';} ,
			},
			inpKenekiBasho : {
				required: function(){return $('#hdnL11').val() === 'True' && $('*[name="rdoKeneki"]:checked').val() === '2';} ,
				mojichk: 40,
				kinshi: true
			},
			rdoFukaiko : {
				required: function(){return $('#hdnL12').val() === 'True';} ,
			},
			txtTokki : {
				mojichk: 200,
				kinshi: true
			},
			rdoKoro : {
				required: function(){return $('#hdnL14').val() === 'True';} ,
			},
		},
		messages: {
			inpZenkou : {
                mojichk: '文字数オーバー(全角10文字,半角20文字)'
			},
			inpZenRinsetsuDate : {
				required: '隣接水先人の乗船日付を指定して下さい。',
			},
			inpZenRinsetsuTime : {
				required: '隣接水先人の乗船時刻を指定して下さい。',
			},
			inpJosenTokki : {
				mojichk: '文字数オーバー(全角10文字,半角20文字)'
			},
//			slctJosenSetsugangen : {
//				required: '乗船接岸舷を指定して下さい。',
//			},
			inpJosenDate : {
				required: '乗船日付を指定して下さい。',
				min: '当日以降の日付を指定してください。'
			},
			inpJosenTime : {
				required: '乗船時刻を指定して下さい。'
			},
			inpGesenTokki : {
				mojichk: '文字数オーバー(全角10文字,半角20文字)'
			},
//			slctGesenSetsugangen : {
//				required: '下船接岸舷を指定して下さい。',
//			},
			inpJikou : {
				required: '次港を入力して下さい。' ,
				mojichk: '文字数オーバー(全角10文字,半角20文字)'
			},
			inpKissuiF : {
//				required: '吃水Fを入力して下さい。' ,
				max : '最大値は25.99です。',
				min : '最小値は0.01です。'
			},
			inpKissuiA : {
//				required: '吃水Aを入力して下さい。' ,
				max : '最大値は25.99です。',
				min : '最小値は0.01です。'
			},
			inpTsumini : {
				required : '積荷を入力してください。',
				mojichk: '文字数オーバー(全角5文字,半角10文字)'
			},
			rdoKikenbutsu : {
				required: '危険物積載を指定して下さい。'
			},
			rdoKeneki : {
				required: '検疫を指定して下さい。'
			},
			inpKenekiBasho : {
				required: '検疫場所を入力してください。',
				mojichk: '文字数オーバー(全角20文字,半角40文字)'
			},
			rdoFukaiko : {
				required: '不開港手続を指定して下さい。'
			},
			txtTokki : {
				mojichk: '文字数オーバー(全角100文字,半角200文字)'
			},
			rdoKoro : {
				required: '航路通報を指定して下さい。'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parents('fieldset');
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});
	
	$('#btnUpload').on('click',function(){
		$('#filUpload').click();
	});
	$('#filUpload').on('change',function(){
		var fileNameVal = $(this).prop('files')[0].name;
		var fileNameArr = fileNameVal.split('.');
		var kakuchoshi = fileNameArr[fileNameArr.length-1];
		var fileName = fileNameVal.slice(0,-(kakuchoshi.length+1));
		$('#hdnFileName').val(fileName);
		$('#hdnFileType').val(kakuchoshi);
		if(kakuchoshi.toUpperCase() !== 'PDF'){
			modalAlert('0','エラー！','PDFファイル以外は添付出来ません。');
			return false;
		}
		updateFile();
	});

	//クリア処理（乗船地）
	$('#btnClJosen').on('click',function(){
		$('#spnJosenName').text('');
		$('#hdnJosenCd').val('000');
		$('#hdnJosenCd2').val('00');
		$('#hdnJosenGanpeki').val('0');
		callBackJosen();
	});
	//クリア処理（下船地）
	$('#btnClGesen').on('click',function(){
		$('#spnGesenName').text('');
		$('#hdnGesenCd').val('000');
		$('#hdnGesenCd2').val('00');
		$('#hdnGesenGanpeki').val('0');
		callBackGesen();
	});
	//クリア処理（中継地）
	$('#btnClChukei').on('click',function(){
		$('#spnChukeiName').text('');
		$('#hdnChukeiCd').val('000');
		$('#hdnChukeiCd2').val('00');
	});
	//クリア処理（タグ配備乗船地）
	$('#btnClTagHaibiJosen').on('click',function(){
		$('#spnTagHaibiJosenName').text('');
		$('#hdnTagHaibiJosenCd').val('0000');
		$('#hdnTagHaibiJosenCd2').val('00');
	});
	//クリア処理（タグ配備下船地）
	$('#btnClTagHaibiGesen').on('click',function(){
		$('#spnTagHaibiGesenName').text('');
		$('#hdnTagHaibiGesenCd').val('0000');
		$('#hdnTagHaibiGesenCd2').val('00');
	});
	//クリア処理（エスコート配備）
	$('#btnClEscortHaibi').on('click',function(){
		$('#spnEscortHaibiName').text('');
		$('#hdnEscortHaibiCd').val('0000');
		$('#hdnEscortHaibiCd2').val('00');
	});

	//キャンセル
	$('#btnCancel').on('click',function(){
		modalAlert('1','確認','入力が取り消されますが、よろしいですか？',callbackCancel);
	});
	
	$('#btnBack').on('click',function(){
		updateMizusakiIrai('3');
	});
	
	//一時保存
	$('#btnSave').on('click',function(){
		updateMizusakiIrai('1');
	});

	//航路通報入力へ進む
	$('#btnNext').on('click',function(){
		var errCount = 0;

		errCount = errCount + checkZenRinsetsu();
		errCount = errCount + checkJosen();
		errCount = errCount + checkJosenSetsugangen();
		errCount = errCount + checkGesen();
		errCount = errCount + checkGesenSetsugangen();
		errCount = errCount + checkJiRinsetsu();
		errCount = errCount + checkTsumini();
		errCount = errCount + checkKissui();

		if($('#form_A114').valid()){
			if(errCount == 0) {
				updateMizusakiIrai('2');
			} else {
				modalAlert('0','エラー！','入力内容を確認してください。');
				return false;
			}
		}else {
			modalAlert('0','エラー！','入力内容を確認してください。');
		}
	});

	initInputRules();
	getFileList();
	if($('#initErrMsg').val() !== ''){
	   modalAlert('0','エラー！',$('#initErrMsg').val());
	}
});

function initInputRules(){
	$('#slctDispKbn').on('change',function(){
		$('#kyodo_k').val($(this).val());
		updateMizusakiIrai('4');
	});
	
	$('#inpKissuiMiteiCheck').on('change',function(){
		changeKissuiMiteiCheck();
		checkKissui();
	});
	$('#slctZenRinsetsu').on('change',function(){
		changeSlctZenRinsetsu();
		checkZenRinsetsu();
	});
	$('#inpZenRinsetsuDate').on('change',function(){
		checkZenRinsetsu();
	});
	$('#inpZenRinsetsuTime').on('change',function(){
		checkZenRinsetsu();
	});
	$('#inpJosenDate').on('change',function(){
		checkZenRinsetsu();
		checkJiRinsetsu();
	});
	$('#inpJosenTime').on('change',function(){
		checkZenRinsetsu();
		checkJiRinsetsu();
	});
	$('#slctJosenSetsugangen').on('change',function(){
		checkJosenSetsugangen();
	});
	$('#slctGesenSetsugangen').on('change',function(){
		checkGesenSetsugangen();
	});
	$('#slctJiRinsetsu').on('change',function(){
		changeSlctJiRinsetsu();
		checkJiRinsetsu();
	});
	$('#inpJiRinsetsuDate').on('change',function(){
		checkJiRinsetsu();
	});
	$('#inpJiRinsetsuTime').on('change',function(){
		checkJiRinsetsu();
	});

	$('.inpKissui').on('change',function(){
		var maxKissui = Number($('#maxKissui').val());
		var checkVal = (Number($('#inpKissuiF').val()) + Number($('#inpKissuiA').val())) / 2;
		if( maxKissui !== 0 && checkVal > maxKissui){
			modalAlert('0','警告','満載時吃水を超えています。');
		}
		if(Number($('#inpKissuiF').val()) !== 0 && Number($('#inpKissuiA').val()) !== 0 && Number($('#inpKissuiF').val()) >  Number($('#inpKissuiA').val())){
			modalAlert('0','警告','Trim by the head。');
		}
		checkKissui();
	});
	
	$('#slctTsumini').on('change',function(){
		changeSlctTsumini();
		checkTsumini();
	});
	
	$('#inpTsumini').on('change',function(){
		changeSlctTsumini();
		checkTsumini();
	});

	$('*[name="rdoKoro"]').on('change',function(){
		changeKoro();
	});
	
	$('#slctDispKbn').val($('#kyodo_k').val());
	
	
	
	changeKissuiMiteiCheck();
	changeSlctZenRinsetsu();
	changeSlctJiRinsetsu();
	changeSlctTsumini();
	changeKoro();
	
	switch($('#kyodo_k').val()){
		case '1':
			$('.dispKbn_1').hide();
			$('.dispKbn_2').show();
			$('.dispKbn_3').show();
			$('.dispKbn_4').show();
			break;
		case '2':
			$('.dispKbn_1').show();
			$('.dispKbn_2').hide();
			$('.dispKbn_3').show();
			$('.dispKbn_4').show();
			break;
		case '3':
			$('.dispKbn_1').show();
			$('.dispKbn_2').show();
			$('.dispKbn_3').hide();
			$('.dispKbn_4').show();
			break;
		case '4':
			$('.dispKbn_1').show();
			$('.dispKbn_2').show();
			$('.dispKbn_3').show();
			$('.dispKbn_4').hide();
			break;
	}
	
//	callBackJosen();
//	callBackGesen();

	changeJosenGanpeki();
	changeGesenGanpeki()
}

function changeSlctZenRinsetsu(){
	if($('#slctZenRinsetsu').val() !== ''){
		$('#inpZenRinsetsuDate').prop('disabled',false);
		$('#inpZenRinsetsuTime').prop('disabled',false);
	}else {
		$('#inpZenRinsetsuDate').val($('#initDate').val());
		$('#inpZenRinsetsuDate').prop('disabled',true);
		$('#inpZenRinsetsuTime').val('00:00');
		$('#inpZenRinsetsuTime').prop('disabled',true);
	}
}
function changeSlctJiRinsetsu(){
	if($('#slctJiRinsetsu').val() !== ''){
		$('#inpJiRinsetsuDate').prop('disabled',false);
		$('#inpJiRinsetsuTime').prop('disabled',false);
	}else {
		$('#inpJiRinsetsuDate').val($('#initDate').val());
		$('#inpJiRinsetsuDate').prop('disabled',true);
		$('#inpJiRinsetsuTime').val('00:00');
		$('#inpJiRinsetsuTime').prop('disabled',true);
	}
}
function changeSlctTsumini(){
	if($('#slctTsumini').val() === 'OT'){
		$('#inpTsumini').prop('disabled',false);
	}else {
		$('#inpTsumini').prop('disabled',true);
		$('#inpTsumini').val('');
	}
}

function changeKoro(){
	if($('*[name="rdoKoro"]:checked').val() === '1'){
		$('#btnNext').text('航路通報入力へ進む');
	}else {
		$('#btnNext').text('入力確認画面へ進む');
	}
}

function changeKissuiMiteiCheck(){
	if($('#inpKissuiMiteiCheck').prop('checked')){
		$('#inpKissuiF').prop('disabled',true);
		$('#inpKissuiA').prop('disabled',true);
		$('#inpKissuiF').val('');
		$('#inpKissuiA').val('');
	}else {
		$('#inpKissuiF').prop('disabled',false);
		$('#inpKissuiA').prop('disabled',false);
	}
}

function callBackJosen(){
	changeJosenGanpeki();
	checkJosen();
	checkJosenSetsugangen();
}

function changeJosenGanpeki(){
	var ganpekiVal = $('#hdnJosenGanpeki').val();
	var josenCdA = $('#hdnJosenCd').val();
	if(ganpekiVal === '0'){
		$('#slctJosenSetsugangen').prop('disabled',true);
		$('#slctJosenSetsugangen').val('');
	}else {
		$('#slctJosenSetsugangen').prop('disabled',false);
	}
	if(josenCdA == '010' || josenCdA == '020' || josenCdA == '030'){
		$('#btnZoomTagHaibiJosen').prop('disabled',true);
		$('#btnClTagHaibiJosen').prop('disabled',true);
		$('#spnTagHaibiJosenName').text('');
		$('#hdnTagHaibiJosenCd').val('0000');
		$('#hdnTagHaibiJosenCd2').val('00');
	}else{
		$('#btnZoomTagHaibiJosen').prop('disabled',false);
		$('#btnClTagHaibiJosen').prop('disabled',false);
	}
}

function callBackGesen(){
	changeGesenGanpeki();
	checkGesen();
	checkGesenSetsugangen();
}

function changeGesenGanpeki(){
	var ganpekiVal = $('#hdnGesenGanpeki').val();
	var gesenCdA = $('#hdnGesenCd').val();
	if(ganpekiVal === '0'){
		$('#slctGesenSetsugangen').prop('disabled',true);
		$('#slctGesenSetsugangen').val('');
	}else {
		$('#slctGesenSetsugangen').prop('disabled',false);
	}
	if(gesenCdA == '010' || gesenCdA == '020' || gesenCdA == '030'){
		$('#btnZoomTagHaibiGesen').prop('disabled',true);
		$('#btnClTagHaibiGesen').prop('disabled',true);
		$('#spnTagHaibiGesenName').text('');
		$('#hdnTagHaibiGesenCd').val('0000');
		$('#hdnTagHaibiGesenCd2').val('00');
	}else{
		$('#btnZoomTagHaibiGesen').prop('disabled',false);
		$('#btnClTagHaibiGesen').prop('disabled',false);
	}
}

//▼文字バイト数計算  ※文字数チェックから呼び出し
function textbyte(str) {
        count=0;
        for(i=0;i<str.length;i++)
        (str.charAt(i).match(/[ｱ-ﾝ]/) || encodeURI(str.charAt(i)).length< 4)?count++:count+=2;
        return count;
}

//更新処理
function updateMizusakiIrai(syoriKbn){
	var checkKissuiMitei = '';
	if($('#inpKissuiMiteiCheck').prop('checked')){ checkKissuiMitei = '1'; }
	var param = {
		'appname': nasiappname,
		'prgname':'A115',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': $('#kubun').val(),
		'param4': syoriKbn,
		'param5': $('#k_order_no').val(),
		'param6': $('#kyodo_k').val(),
		'param7': $('#inpZenkou').val(),
		'param8': $('#slctZenRinsetsu').val(),
		'param9': $('#inpZenRinsetsuDate').val(),
		'param10': $('#inpZenRinsetsuTime').val(),
		'param11': $('#hdnJosenCd').val(),
		'param12': $('#hdnJosenCd2').val(),
		'param13': $('#slctJosenSetsugangen').val(),
		'param14': $('#inpJosenDate').val(),
		'param15': $('#inpJosenTime').val(),
		'param16': $('#hdnGesenCd').val(),
		'param17': $('#hdnGesenCd2').val(),
		'param18': $('#slctGesenSetsugangen').val(),
		'param19': $('#slctJiRinsetsu').val(),
		'param20': $('#inpJiRinsetsuDate').val(),
		'param21': $('#inpJiRinsetsuTime').val(),
		'param22': $('#inpJikou').val(),
		'param23': $('#hdnChukeiCd').val(),
		'param24': $('#hdnChukeiCd2').val(),
		'param25': $('#inpKissuiF').val(),
		'param26': $('#inpKissuiA').val(),
		'param27': checkKissuiMitei,
		'param28': $('#slctTsumini').val(),
		'param29': $('#inpTsumini').val(),
		'param30': $('*[name="rdoKikenbutsu"]:checked').val(),
		'param31': $('*[name="rdoKeneki"]:checked').val(),
		'param32': $('#inpKenekiBasho').val(),
		'param33': $('*[name="rdoFukaiko"]:checked').val(),
		'param34': $('#txtTokki').val(),
		'param35': $('*[name="rdoKoro"]:checked').val(),
		'param36': $('#hdnTagHaibiJosenCd').val(),
		'param37': $('#hdnTagHaibiJosenCd2').val(),
		'param38': $('#hdnTagHaibiGesenCd').val(),
		'param39': $('#hdnTagHaibiGesenCd2').val(),
		'param40': $('#hdnEscortHaibiCd').val(),
		'param41': $('#hdnEscortHaibiCd2').val(),
		'param42': $('#spnSelectFile').text(),
		'param43': $('#inpJosenTokki').val(),
		'param44': $('#inpGesenTokki').val(),
		'arguments':'param1,param2,param3,param4,param5,param6,param7,param8,param9,param10,param11,param12,param13,param14,param15,param16,param17,param18,param19,param20,param21,param22,param23,param24,param25,param26,param27,param28,param29,param30,param31,param32,param33,param34,param35,param36,param37,param38,param39,param40,param41,param42,param43,param44'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001' ){
		if(syoriKbn === '1'){
			// 履歴紹介画面へ移動
			$('#prgname').val('A130');
			$('#menuForm').submit();
		}else if(syoriKbn === '2'){
			// 航路通報入力画面へ進む
			$('#arguments').val('paramAppName,ssid,parentPG,param1,param2,param3,param4,param5,param6,param7,param8,param9,param10');
			if($('*[name="rdoKoro"]:checked').val() === '1'){
				$('#prgname').val('A116');
				$('#param1').val($('#kubun').val());
				$('#param2').val($('#k_order_no').val());
			}else {
				$('#prgname').val('A133');
				$('#param1').val($('#k_order_no').val());
				$('#param2').val($('#kubun').val());
			}
			$('#menuForm').submit();
		}else if(syoriKbn === '3'){
			// 船舶情報入力へ戻る
			$('#arguments').val('paramAppName,ssid,parentPG,param1,param2,param3,param4,param5,param6,param7,param8,param9,param10');
			$('#prgname').val('A112');
			$('#param1').val($('#kubun').val());
			$('#param2').val($('#k_order_no').val());
			$('#menuForm').submit();
		}else if(syoriKbn === '4'){
			// 嚮導区分を切り替えて再表示
			$('#arguments').val('paramAppName,ssid,parentPG,param1,param2,param3,param4,param5,param6,param7,param8,param9,param10');
			$('#prgname').val('A114');
			$('#param1').val($('#kubun').val());
			$('#param2').val($('#k_order_no').val());
			$('#menuForm').submit();
		}
	}else if(kekka === 'E001' ){
		// セッションエラーを表示
		$('#prgname').val('A040');
		$('#menuForm').submit();
	}else if(kekka === 'P001' ){
		// パラメータエラーを表示
		$('#prgname').val('A000');
		$('#menuForm').submit();
	}
}

function updateFile(){
	var $form = $('#form_A114_file');
	var fd = new FormData($form.get(0));
	fd.append('appname',nasiappname);
	fd.append('prgname','A124');
	
	var fd_key = [];
	for(item of fd){
		fd_key.push(item[0]);
	}
	var argumentsStr = fd_key.join(',');
	fd.append('arguments',argumentsStr);

	$.ajax({
		async : false,
		url: '../Magic33Scripts/MGrqispi.dll',
		type:'post',
		dataType:'xml',
		data: fd,
		processData: false,
		contentType: false,
		cache: false,
		scriptCharset: 'utf-8',
		}).done(function (xml) {
			var ret = $(xml).find('ret').text();
			var msg = $(xml).find('message').text();
			if(ret === 'I001'){
				$('#filUpload').val('');
				$('#hdnFileName').val('');
				$('#hdnFileType').val('');
				createFileList(xml);
			}else {
				modalAlert('0','エラー！',msg);
			}
		}).fail(function() {
			// 失敗時の処理
	});
}

function callbackCancel(){
	/* 2022/03/18 戻るボタンで遷移する先をトップページに変更
	$('#prgname').val('A130');
	$('#menuForm').submit();
	*/
	$('#prgname').val($('#parentPG').val());
	$('#param1').val('0');
	$('#menuForm').submit();
}

function checkZenRinsetsu(){
	if($('#hdnL4').val() === 'True' && $('#hdnL2').val() === 'True' && $('#slctZenRinsetsu').val() !== '' && $('#inpZenRinsetsuDate').val()+$('#inpZenRinsetsuTime').val() > $('#inpJosenDate').val()+$('#inpJosenTime').val()){
		$('#lblErrZenRinsetsu').text('隣接水先人の乗船日時は乗船日時以前の値を入力して下さい');
		return 1;
	}else {
		$('#lblErrZenRinsetsu').text('');
		return 0;
	}
}

function checkJosen(){
	if($('#hdnL3').val() === 'True' && ($('#hdnJosenCd').val() + $('#hdnJosenCd2').val() =='00000')){
		$('#lblErrJosen').text('乗船地を指定して下さい。');
		return 1;
	}else {
		$('#lblErrJosen').text('');
		return 0;
	}
}

function checkJosenSetsugangen(){
	if($('#hdnL3').val() === 'True' && $('#kyodo_k').val() !== '1' && $('#hdnJosenGanpeki').val() === '1' && $('#slctJosenSetsugangen').val() === ''){
		$('#lblErrJosenSetsugangen').text('乗船接岸舷を指定して下さい。');
		return 1;
	}else {
		$('#lblErrJosenSetsugangen').text('');
		return 0;
	}
}

function checkGesen(){
	if($('#hdnL5').val() === 'True' && ($('#hdnGesenCd').val() + $('#hdnGesenCd2').val() =='00000')){
		$('#lblErrGesen').text('下船地を指定して下さい。');
		return 1;
	}else {
		$('#lblErrGesen').text('');
		return 0;
	}
}

function checkGesenSetsugangen(){
	if($('#hdnL5').val() === 'True' && $('#kyodo_k').val() !== '2' && $('#hdnGesenGanpeki').val() === '1' && $('#slctGesenSetsugangen').val() === ''){
		$('#lblErrGesenSetsugangen').text('下船接岸舷を指定して下さい。');
		return 1;
	}else {
		$('#lblErrGesenSetsugangen').text('');
		return 0;
	}
}

function checkJiRinsetsu(){
	if($('#hdnL4').val() === 'True' && $('#hdnL6').val() === 'True' && $('#slctJiRinsetsu').val() !=='' && $('#inpJiRinsetsuDate').val()+$('#inpJiRinsetsuTime').val() < $('#inpJosenDate').val()+$('#inpJosenTime').val()){
		$('#lblErrJiRinsetsu').text('隣接水先人の乗船日時は乗船日時以降の値を入力して下さい。');
		return 1;
	}else {
		$('#lblErrJiRinsetsu').text('');
		return 0;
	}
}

function checkTsumini(){
	if($('#hdnL10').val() === 'True' && ($('#slctTsumini').val() =='00')){
		$('#lblErrSlctTsumini').text('積荷を指定して下さい。');
		return 1;
	}else if($('#hdnL10').val() === 'True' && ($('#slctTsumini').val() =='OT' && $('#inpTsumini').val() === '')){
		$('#lblErrSlctTsumini').text('積荷を指定して下さい。');
		return 1;
	}else {
		$('#lblErrSlctTsumini').text('');
		return 0;
	}
}

function checkKissui(){
	if($('#hdnL9').val() === 'True' && !$('#inpKissuiMiteiCheck').prop('checked') && ($('#inpKissuiF').val() === '' || $('#inpKissuiA').val() === '')){
		$('#lblErrKissui').text('吃水を入力して下さい。');
		return 1;
	}else {
		$('#lblErrKissui').text('');
		return 0;
	}
}

function getFileList(){
	var param = {
		'appname': nasiappname,
		'prgname':'A124',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': 'L',
		'param4': $('#k_order_no').val(),
		'param5': '0',
		'param6': '0',
		'arguments':'param1,param2,param3,param4,param5,param6'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001' ){
		createFileList(retXml);
	}else if(kekka === 'E001' ){
		// セッションエラーを表示
		$('#prgname').val('A040');
		$('#menuForm').submit();
	}else if(kekka === 'P001' ){
		// パラメータエラーを表示
		$('#prgname').val('A000');
		$('#menuForm').submit();
	}
}

function deleteFile(renban){
	var param = {
		'appname': nasiappname,
		'prgname':'A124',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': 'D',
		'param4': $('#k_order_no_file').val(),
		'param5': $('#k_order_no_edaban_file').val(),
		'param6': renban,
		'arguments':'param1,param2,param3,param4,param5,param6'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001' ){
		createFileList(retXml);
	}else if(kekka === 'E001' ){
		// セッションエラーを表示
		$('#prgname').val('A040');
		$('#menuForm').submit();
	}else if(kekka === 'P001' ){
		// パラメータエラーを表示
		$('#prgname').val('A000');
		$('#menuForm').submit();
	}
}

function createFileList(xml){
	$('#fldFileList').empty();
	$(xml).find('fileLine').each(function(){
		var k_order_renban = $(this).find('order_renban').text()
		var fileName = $(this).find('file_name').text();
		var fileNo = $(this).find('file_no').text();
		var btnHtml = '';
		if($('#k_order_no_edaban_file').val() === k_order_renban){
			btnHtml = '<button type="button" class="btn btn-sm btn-secondary align-top btnFileDelete m-1" data-file_renban="'+fileNo+'">削除</button>';
		}
		var addHtml = 	'<div>' +
							'<label class="uwd-15">&nbsp;</label>' + 
							'<label class="mt-2">' + fileName + '</label>' +
							btnHtml + 
						'</div>';
		$('#fldFileList').append(addHtml);
	});
	
	$('.btnFileDelete').on('click',function(){
		var renban = $(this).attr('data-file_renban');
		deleteFile(renban);
	});
}
