// JavaScript Document
var web_doc_alias = '';
var calcHarvorFrom = '',calcHarvorFrom2 = '';
var calcHarvorTo = '',calcHarvorTo2 = '';
var newCalcFlg = true;
$(document).ready(function(){
	setupZoomModal('harbor');
	setupZoomModal('shipName');
	web_doc_alias = $('#web_doc_alias').val();
	showTable();

	$('#form_A810').validate({
		ignore: [],
		rules : {
			searchMinatoCd : {
				required: true
			},
			inpJousenDate : {
				required: true
			},
		},
		messages: {
			searchMinatoCd : {
				required: '港を選択して下さい。'
			},
			inpJousenDate : {
				required: '日付を選択して下さい。'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parent();
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});
	
	// ズームのコールバック関数を設定
	// zoomCallBackFncはzoom_agency.js内で宣言
	//zoomCallBackFnc['callBackHarvor'] = callBackHarvor;
	
	$('#mdlMinatoList').on('show.bs.modal', function (e) {
		var minatoParam = {
			'appname':'NAIS3WEB',
			'prgname':'W510',
			'ssid': $('#ssid').val(),
			'searchKbn': '',
			'kyotenKbn': '',
			'dateYM' : '',
			'day' : '',
			'orderNo' : '',
			'arguments':'ssid,searchKbn,kyotenKbn,dateYM,day,orderNo'
		};
		var retHtml = ajaxFunctionHtml(minatoParam);
		var getHtml = $($.parseHTML(retHtml));
		var sessionError = getHtml.filter('#sessionError').val();
		if(sessionError === '0'){
			$('#mdlMinatoListContenrs').empty();
			$('#mdlMinatoListContenrs').append(getHtml.filter('#divMinatoRes')[0].innerHTML);
			$('.minatoSelect').each(function(){
				$(this).attr('data-bs-dismiss','modal');
				$(this).attr('aria-label','Close');
			});
			$('.minatoSelect').on('click',function(){
				var timeiCd = $(this).attr("data-timeicd");
				$('#searchMinatoCd').val(timeiCd);
				$('#spnMinatoName').text($(this).text());
				$('#slctKyoten').val('90');
			});
		}
		
	});
	
	$('#btnSearch').on('click',function(){
		if($('#form_A810').valid()){
			searchList();
		}
	});
	
	$('#btnBack').on('click',function(){
		$('#prgname').val('A020');
		$('#param1').val('0');
		$('#menuForm').submit();
	});
});

function showTable(){
	// datatableの設定を変更
	varTable1 =	$("#table1").DataTable({
		dom:"<'row'<'col-sm-6'i><'col-sm-6 right mb-1'f>>" +
		"<'row'<'col-sm-12'tr>>" +
		"<'row'<'col-sm-6 mt-1'l><'col-sm-6 right mt-1'p>>",
		'paging'      :true,
		'pageLength'  :10,
		'lengthChange':true,
		'searching'   :true,
		'ordering'    :true,
		'info'        :true,
		'autoWidth'   :false,
		'scrollX'     :true,
		'scrollY'     :true,
		'order'       :[[0,'asc']],
		'columns'     :[
		{data:"datetime"},
		{data:"from"},
		{data:"to"},
		{data:"name",width:"30%"},
		{data:"loa",className:"dt-body-right"},
		{data:"weight",className:"dt-body-right"},
		{data:"speed",className:"dt-body-right"}
		],
		"language": {
			"url": "../webnais/lib/DataTables/plug-ins/Japanese.json"
		}
	});
};

function searchList(){
	var param = {
		'appname': nasiappname,
		'prgname':'A811',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		//'param3': $('#slctKyoten').val(),
		'param3': '90',
		'param4': $('#searchMinatoCd').val(),
		'param5': $('#inpJousenDate').val(),
		'arguments':'param1,param2,param3,param4,param5'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001'){
		varTable1.state.clear();
		varTable1.destroy();
		$("#table1 tbody > tr").remove();
		showTable();
		$(retXml).find('lines').each(function(){
			var ship_name = $(this).find('ship_name').text();
			var operator1 = $(this).find('operator1').text();
			var agency1 = $(this).find('agency1').text();
			var loa = $(this).find('loa').text();
			var big = $(this).find('big').text();
			var kiken = $(this).find('kiken').text();
			var dw = $(this).find('dw').text();
			var gt = $(this).find('gt').text();
			var soku = $(this).find('soku').text();
			var df = $(this).find('df').text();
			var josenchi_name = $(this).find('josenchi_name').text();
			var josen_memo = $(this).find('josen_memo').text();
			var kyodo_daytime = $(this).find('kyodo_daytime').text();
			var kanri = $(this).find('kanri').text();
			var gesenchi_name = $(this).find('gesenchi_name').text();
			var gesen_memo = $(this).find('gesen_memo').text();
			varTable1.row.add({
				name:ship_name + '<br>' + operator1 + agency1
				,loa:loa + '<br><span>' + big + '</span><span class="text-danger">　' + kiken + '</span>'
				,weight:dw + '<br>' + gt
				,speed:soku + '<br>' + df
				,from:josenchi_name + '<br>' + josen_memo
				,datetime:kyodo_daytime + '<br>' + kanri
				,to:gesenchi_name + '<br>' + gesen_memo
				}).draw(false);
		});
	}
}