// JavaScript Document
var web_doc_alias = '';
$(document).ready(function(){
	setupZoomModal('harbor');
	setupZoomModal('shipName');
	web_doc_alias = $('#web_doc_alias').val();

	//文字数チェック
	$.validator.addMethod(
        'mojichk',
        function(value,element,num){
            count = textbyte(value);
            if (this.optional(element)){
                return true;
            } else if (count > num){
                return false;
            } else {
                return true;
            }
        },       
    );	
	
	$('#form_A900').validate({
		ignore: [], //type="hidden"項目のエラーチェックを可能とする
		rules : {
			inpTantoNm : {
				required: true,
				mojichk : 50
			},
			inpTantoTelNo : {
				required: true,
				maxlength : 15,
				digits : true
			},
			inpTantoMail : {
				required: true,
				email : true,
				maxlength : 120,
			},
			inpTantoMailKakunin : {
				required: true,
				email : true,
				maxlength : 120,
				equalTo : '#inpTantoMail'
			},
			inpPassNow : {
				required: true,
				maxlength : 12,
			},
			inpPassNew : {
				maxlength : 12,
			},
			inpPassNewKakunin : {
				maxlength : 12,
				equalTo : '#inpPassNew'
			},
		},
		messages: {
			inpTantoNm : {
				required: '必須入力です。',
				mojichk : '全角25文字(半角50文字)以内で入力してください。',
			},
			inpTantoTelNo : {
				required: '必須入力です。',
				maxlength : '15桁以内で入力してください。',
				digits : '数値のみを入力してください。'
			},
			inpTantoMail : {
				required: '必須入力です。',
				email: 'メールアドレスを入力して下さい。',
				maxlength : '120桁以内で入力してください。',
			},
			inpTantoMailKakunin : {
				required: '必須入力です。',
				email: 'メールアドレスを入力して下さい。',
				maxlength : '120桁以内で入力してください。',
				equalTo: 'メールアドレスと入力内容が異なります。'
			},
			inpPassNow : {
				required: '必須入力です。',
				maxlength : '12桁以内で入力してください。',
			},
			inpPassNew : {
				maxlength : '12桁以内で入力してください。',
			},
			inpPassNewKakunin : {
				maxlength : '12桁以内で入力してください。',
				equalTo: '新しいパスワードと入力内容が異なります。'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parent();
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});
	
	$('#btnUpdate').on('click',function(){
		if($('#form_A900').valid()){
			updateUserInfo('2');
		}
	});
	
	$('#btnBack').on('click',function(){
		$('#prgname').val('A020');
		$('#param1').val('0');
		$('#menuForm').submit();
	});
	
	$('#lnkNewUser').on('click',function(){
		$('#prgname').val('A910');
		$('#param1').val('0');
		$('#menuForm').submit();
	});
	
});

function updateUserInfo(syoriKbn){
	var param = {
		'appname': nasiappname,
		'prgname':'A901',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': $('#inpTantoNm').val(),
		'param4': $('#inpTantoTelNo').val(),
		'param5': $('#inpTantoMail').val(),
		'param6': $('#inpPassNow').val(),
		'param7': $('#inpPassNew').val(),
		'arguments':'param1,param2,param3,param4,param5,param6,param7'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001'){
		modalAlert('0','','登録情報を更新しました。',callbackUpdate);
	}
}

function callbackUpdate(){
	$('#prgname').val('A020');
	$('#param1').val('0');
	$('#menuForm').submit();
}

//▼文字バイト数計算  ※文字数チェックから呼び出し
function textbyte(str) {
	count=0;
	for(i=0;i<str.length;i++)
	(str.charAt(i).match(/[ｱ-ﾝ]/) || encodeURI(str.charAt(i)).length< 4)?count++:count+=2;
	return count;
}