// JavaScript Document
var web_doc_alias = '';
$(document).ready(function(){
	setupZoomModal('harbor');
	setupZoomModal('shipName');
	web_doc_alias = $('#web_doc_alias').val();
	
	$('#form_A900').validate({
		ignore: [], //type="hidden"項目のエラーチェックを可能とする
		rules : {
			inpTantoNm : {
				required: true,
				checkBytes : 50
			},
			inpTantoTelNo : {
				required: true,
				maxlength : 15,
				digits : true
			},
			inpTantoMail : {
				required: true,
				email : true,
				maxlength : 120,
			},
			inpTantoMailKakunin : {
				required: true,
				email : true,
				maxlength : 120,
				equalTo : '#inpTantoMail'
			},
			inpPassNew : {
				required: true,
				maxlength : 12,
			},
			inpPassNewKakunin : {
				required: true,
				maxlength : 12,
				equalTo : '#inpPassNew'
			},
		},
		messages: {
			inpTantoNm : {
				required: '必須入力です。',
				checkBytes : '全角25文字(半角50文字)以内で入力してください。',
			},
			inpTantoTelNo : {
				required: '必須入力です。',
				maxlength : '15桁以内で入力してください。',
				digits : '数値のみを入力してください。'
			},
			inpTantoMail : {
				required: '必須入力です。',
				email: 'メールアドレスを入力して下さい。',
				maxlength : '120桁以内で入力してください。',
			},
			inpTantoMailKakunin : {
				required: '必須入力です。',
				email: 'メールアドレスを入力して下さい。',
				maxlength : '120桁以内で入力してください。',
				equalTo: 'メールアドレスと入力内容が異なります。'
			},
			inpPassNow : {
				required: '必須入力です。',
				maxlength : '12桁以内で入力してください。',
			},
			inpPassNew : {
				required: '必須入力です。',
				maxlength : '12桁以内で入力してください。',
			},
			inpPassNewKakunin : {
				required: '必須入力です。',
				maxlength : '12桁以内で入力してください。',
				equalTo: 'パスワードと入力内容が異なります。'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parent();
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});
	
	$('#btnUpdate').on('click',function(){
		if($('#form_A900').valid()){
			updateUserInfo('2');
		}
	});
	
	$('#btnBack').on('click',function(){
		$('#prgname').val('A020');
		$('#param1').val('0');
		$('#menuForm').submit();
	});
});

function updateUserInfo(syoriKbn){
	var param = {
		'appname': nasiappname,
		'prgname':'A911',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': $('#inpTantoNm').val(),
		'param4': $('#inpTantoTelNo').val(),
		'param5': $('#inpTantoMail').val(),
		'param6': $('#inpPassNew').val(),
		'arguments':'param1,param2,param3,param4,param5,param6'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001'){
		modalAlert('0','','新規ユーザを登録しました。',callbackUpdate);
	}
}

function callbackUpdate(){
	$('#prgname').val('A020');
	$('#param1').val('0');
	$('#menuForm').submit();
}
