// JavaScript Document
var docData = [];
var docPastData = [];
var docFavoriteData = [];
var largeSummary = false;
var largeFavorite = false;
var largeContact = false;

var intervalSec = 1000 * 60;
var intervalSearchKbn;
var intervalKyotenKbn;
var intervalRigyojunKbn;
var intervalShikakuKbn;
var intervalParam = {
	'appname':'NAIS3WEB',
	'prgname':'W113',
	'ssid': $('#ssid').val(),
	'searchKbn': intervalSearchKbn,
	'kyotenKbn': intervalKyotenKbn,
	'rigyojunKbn': intervalRigyojunKbn,
	'shikakuKbn': intervalShikakuKbn,
	'arguments':'ssid,searchKbn,kyotenKbn,rigyojunKbn,shikakuKbn'
};
var intervalSearchCall;

$(document).ready(function(){
	window.name = "W110";
	
	$('#dialogSubMenu').dialog({
		autoOpen: false,
		title: "",
		closeOnEscape: false,
		width: $('body').width() * 0.7,
		modal: true,
		open: function() {
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});

	
	$('.extract').click(function(){
		var extractKbn = $(this).attr("data-extractKbn");
		$('#searchSyoriKbn').val(extractKbn);
		getSearch();
	});
	
	if($('#searchReloadKbn').val() === 'Y'){
		setSearchInterval();
	}
	
	$('#btnReload1').click(function(){
		if($('#searchReloadKbn').val() === 'Y'){
			$('#searchReloadKbn').val('N');
			clearInterval(intervalSearchCall);
			$('#spnReloadStatus').text('手動');			
			alert("手動更新に切り替えました。最新ボタンで更新できます。");
		}else {
			$('#searchReloadKbn').val('Y');
			setSearchInterval();
			$('#spnReloadStatus').text('自動');
		}
		getSearch();
	});
	
	$('#btnReload2').click(function(){
		getSearch();
	});
	
	$('#btnGotoMizusaki').click(function(){
		var order_no = '';
		var r_dateym = $('#mizusakiDateYM').val();
		var r_dated = $('#mizusakiDateD').val();
		var kyotenCd = $('#mizusakiKyoten').val();
		MizusakiKiroku(order_no,r_dateym,r_dated,kyotenCd,kyotenCd);
	});
	
	$('.sideButton').click(function(){
		var menuKbn = $(this).attr("data-btnKbn");
		getSideMenu(menuKbn);
	});
	
	getSearch();
});

function setSearchInterval(){
	intervalSearchCall = setInterval(function(){
        getSearchCore(intervalParam);
    },intervalSec);
}

function getSearch(){
	intervalSearchKbn = $('#searchSyoriKbn').val();
	intervalKyotenKbn = $('#slctKyoten').val();
	intervalRigyojunKbn = $('#slctRigyojun').val();
	intervalShikakuKbn = $('#slctShikaku').val();
	intervalParam = {
		'appname':'NAIS3WEB',
		'prgname':'W113',
		'ssid': $('#ssid').val(),
		'searchKbn': intervalSearchKbn,
		'kyotenKbn': intervalKyotenKbn,
		'rigyojunKbn': intervalRigyojunKbn,
		'shikakuKbn': intervalShikakuKbn,
		'aoutReloadKbn' : $('#searchReloadKbn').val(),
		'arguments':'ssid,searchKbn,kyotenKbn,rigyojunKbn,shikakuKbn,aoutReloadKbn'
	};
	var setParam = {
		'appname':'NAIS3WEB',
		'prgname':'W113',
		'ssid': $('#ssid').val(),
		'searchKbn': $('#searchSyoriKbn').val(),
		'kyotenKbn': $('#slctKyoten').val(),
		'rigyojunKbn': $('#slctRigyojun').val(),
		'shikakuKbn': $('#slctShikaku').val(),
		'aoutReloadKbn' : $('#searchReloadKbn').val(),
		'arguments':'ssid,searchKbn,kyotenKbn,rigyojunKbn,shikakuKbn,aoutReloadKbn'
	};
	getSearchCore(setParam);
}

function getSearchCore(searchParam){
	$.ajax({
		async : true,
		url: ajaxURL,
		data : searchParam,
		dataType:'html',
		scriptCharset: 'utf-8',
		success : function(html){			
			var getHtml = $($.parseHTML(html));
			var sessionError = getHtml.filter('#sessionError').val();
			if(sessionError === '0'){
				$('#spnSyoriDateTime').empty();
				$('#spnSyoriDateTime').append(getHtml.filter('#spnSyoriDateTimeRes')[0].innerHTML);

				$('#divSearchContents').empty();
				$('#divSearchContents').append(getHtml.filter('#divSearchRes')[0].innerHTML);
				
				$('.headYMD').empty();
				$('.headYMD').append(getHtml.filter('#spnheadYMD')[0].innerHTML);
				
				$('.callMizusaki').on(
					'click',
					function(){
						var order_no = $(this).attr('data-orderNo');
						var r_dateym = $(this).attr('data-dateYM');
						var r_dated = $(this).attr('data-dateD');
						var kyotenCd = parseInt($('#slctKyoten').val()) + parseInt($('#loginKyoten').val());
						MizusakiKiroku(order_no,r_dateym,r_dated,kyotenCd);
					}
				);

				$('.btnPrint').on(
					'click',
					function(){
						PKirokuPrt();
					}
				);
			}else {
				cm_sessionError();
			}
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
				cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
		}
	});
}				 

function getSideMenu(menuKbn){
	var submenuParam = {
		'appname':'NAIS3WEB',
		'prgname':'W114',
		'ssid': $('#ssid').val(),
		'menuKbn' : menuKbn,
		'searchKbn': $('#searchSyoriKbn').val(),
		'kyotenKbn': $('#slctKyoten').val(),
		'rigyojunKbn': $('#slctRigyojun').val(),
		'shikakuKbn': $('#slctShikaku').val(),
		'arguments':'ssid,menuKbn,searchKbn,kyotenKbn,rigyojunKbn,shikakuKbn'
	}
	$.ajax({
		async : false,
		url: ajaxURL,
		data : submenuParam,
		dataType:'html',
		scriptCharset: 'utf-8',
		success : function(html){
			var getHtml = $($.parseHTML(html));
			var sessionError = getHtml.filter('#sessionError').val();
			if(sessionError === '0'){
				$('#divSubMenu').empty();
				$('#divSubMenu').append(getHtml.filter('#divSubMenuRes')[0].innerHTML);
				$('#dialogSubMenu').dialog('open');
			}else {
				cm_sessionError();
			}
			
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
			cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
		}
	});
}

//水先記録に移る
function MizusakiKiroku(order_no,r_dateym,r_dated,kyotenCd){
	var funk1 = $('#searchSyoriKbn').val();
	var haijo = $('#slctKyoten').val();
	var rigyo = $('#slctRigyojun').val();
	var shikaku = $('#slctShikaku').val();
	$('#prgname').val('W120');
	$('#param1').val('1');
	$('#param2').val(kyotenCd);
	$('#param3').val(r_dateym);
	$('#param4').val(r_dated);
	$('#param5').val(order_no);
	$('#param6').val('W110');
	$('#param7').val(funk1);
	$('#param8').val(haijo);
	$('#param9').val(rigyo);
	$('#param10').val(shikaku);
	$('#param11').val('');
	$('#param12').val('');
	$('#menuForm').submit();
}

//稼動記録印刷
function PKirokuPrt(){
	var funk1 = $('#searchSyoriKbn').val();
	var haijo = $('#slctKyoten').val();
	var rigyo = $('#slctRigyojun').val();
	var shikaku = $('#slctShikaku').val();
	var ssid = $('#ssid').val();
	/*
	var printUrl = naisserver+'?APPNAME='+nasiappname+'&PRGNAME=W100&ARGUMENTS=-A'+nasiappname+',-A'+ssid+',-A'+funk1+',-A'+haijo+',-A'+rigyo+',-A'+shikaku;
	window.open(printUrl,"稼動記録印刷",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550,');
	*/
	window.open("","稼動記録印刷",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550');
	$('#windowForm').attr('target','稼動記録印刷');
	$('#Wprgname').val('W100');
	$('#w_param1').val(nasiappname);
	$('#w_param2').val(ssid);
	$('#w_param3').val(funk1);
	$('#w_param4').val(haijo);
	$('#w_param5').val(rigyo);
	$('#w_param6').val(shikaku);
	$('#w_param7').val('');
	$('#w_param8').val('');
	$('#w_param9').val('');
	$('#w_param10').val('');
	$('#windowForm').submit();
	$('#windowForm').attr('target','_self');
}

function NPHelp(){
	var hdnWebDocAlias = $('#hdnWebDocAlias').val();
	window.open(hdnWebDocAlias+"help/nphelp_kado001.htm");
}