// JavaScript Document
var docData = [];
var docPastData = [];
var docFavoriteData = [];
var largeSummary = false;
var largeFavorite = false;
var largeContact = false;

var paraBar;
var paraDocBar;

var createData = [];
var gOrderNo = '';

var ssid;
var order_no;
var inoutKbn;
var chimei_codeA;
var chimei_codeB;
var mizusaki_code;
var map_number;
var createType;

var canvasBackURL;

var canvasPic;

var tagWidth = 15;
var tagHeight = 40;
var tagWidthZoom = 1.0;
var tagHeightZoom = 1.0; 

var backgroundWidth = 0;
var backgroundHeight = 0;

var canvasZoom = 1;

$(document).ready(function(){
	window.name = "W130";
	
	$('#dialogDoenload').dialog({
		autoOpen: false,
		title: "",
		closeOnEscape: false,
		width: 400,
		modal: true,
		open: function() {
		},
		buttons: {
			'OK': function(){
				$(this).dialog("close");
			}
		}
	});
	$('#dialogClose').dialog({
		autoOpen: false,
		title: "確認",
		closeOnEscape: false,
		width: 400,
		modal: true,
		open: function() {
		},
		buttons: {
			'はい': function(){
				$(this).dialog("close");
				$('#prgname').val('W240');
				$('#param1').val(order_no);
				$("#param2").val($("#harborInExist").val());
				$("#param3").val($("#harborOutExist").val());
				$("#param4").val($("#harborInTug").val());
				$("#param5").val($("#harborInBarse").val());
				$("#param6").val($("#harborOutTug").val());
				$("#param7").val($("#harborOutBarse").val());
				$("#param8").val($("#signalFlag1").val());
				$("#param9").val($("#signalFlag2").val());
				$("#param10").val($("#harborInTugNoList").val());
				$("#param11").val($("#harborOutTugNoList").val());	
				$('#menuForm').submit();
			},
	        'いいえ': function(){
				$(this).dialog("close");
			}
    	},
		close : function (){
		}
	});
	
	ssid = $('#ssid').val();
	order_no  = $('#searchOrderNo').val();
	inoutKbn = $('#searchInOutKbn').val();
	chimei_codeA  = $('#searchChimeiA').val();
	chimei_codeB  = $('#searchChimeiB').val();
	mizusaki_code  = $('#searchMizusakiCd').val();
	map_number = $('#mapNumber').val();
	createType = $('#createType').val();
	canvasBackURL  = $('#searchCanvasBackURL').val();
	
	var backImg = new Image();
	backImg.src = canvasBackURL;
	backImg.onload = function(){
		backgroundWidth = backImg.width;
		backgroundHeight = backImg.height;
		setBackground();
	};
	
	$('#btnAddTag').on('click',function(){
		addTag();
	});
	
	$('#btnDelTag').on('click',function(){
		var activeObject = canvasPic.getActiveObject();
		if (activeObject) {
			canvasPic.remove(activeObject);
		}else{
			alert('本船を選択してください。');
		}
	});
	
	$('#btnHozonTag').on('click',function(){
		var activeObject = canvasPic.getActiveObject();
		if (activeObject) {
			tagWidth = activeObject.width;
			tagHeight = activeObject.height;
			tagWidthZoom = activeObject.scaleX;
			tagHeightZoom = activeObject.scaleY;
		}else{
			alert('本船を選択してください。');
		}
	});
	
	$('#btnUpload').on('click',function(){
		$('#filUpload').click();
	});
	$('#filUpload').on('change',function(){
		var file = this.files[0];
		var reader = new FileReader();
		reader.onload = function(){
			var upload64Data = reader.result;
			upload64Data = upload64Data.replace('data:image/jpeg;base64,', '');
			upload64Data = upload64Data.replace('data:image/png;base64,', '');
			var setParam = {
				'appname':'NAIS3WEB',
				'prgname':'W244',
				'ssid': $('#ssid').val(),
				'inoutKbn' : inoutKbn,
				'chimei_codeA' : chimei_codeA,
				'chimei_codeB' : chimei_codeB,
				'mizusaki_code' : mizusaki_code,
				'map_number' : map_number,
				'imageData' : upload64Data,
				'arguments':'ssid,inoutKbn,chimei_codeA,chimei_codeB,mizusaki_code,map_number,imageData'
			};
			$.ajax({
				async : true,
				url: ajaxURL,
				type:'POST',
				data : setParam,
				dataType:'xml',
				scriptCharset: 'utf-8',
				success : function(xml){
					var retMsg = $(xml).find('message').text();
					var retKbn = $(xml).find('ret').text();
					var retUrl = $(xml).find('url').text();
					
					if(retKbn !== 'I001'){
						cmAlert("エラー",retMsg);
					}else {
						$('#prgname').val('W241');
						$('#param1').val(order_no);
						$('#param2').val(inoutKbn);
						$('#param3').val(chimei_codeA);
						$('#param4').val(chimei_codeB);
						$('#param5').val(mizusaki_code);
						$('#param6').val($('#harborInExist').val());
						$('#param7').val($('#harborOutExist').val());
						$('#param8').val($('#harborInTug').val());
						$('#param9').val($('#harborInBarse').val());
						$('#param10').val($('#harborOutTug').val());
						$('#param11').val($('#harborOutBarse').val());
						$('#param12').val($('#signalFlag1').val());
						$('#param13').val($('#signalFlag2').val());
						$('#param14').val($('#harborInTugNoList').val());
						$('#param15').val($('#harborOutTugNoList').val());
						$('#param16').val(createType);
						$('#param17').val(map_number);
						$('#menuForm').submit();
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown){
					cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
				}
			});
		};
		reader.readAsDataURL(file);
	});
	
	
	$('#btnDownload').on('click',function(){
		var get64Data400 = canvasPic.toDataURL("image/jpeg");
		var img01 = new Image();
		img01.src = get64Data400;
		var canvas = document.getElementById('cnvPic400');
		var context = canvas.getContext('2d');
		img01.onload = function(){
			backgroundWidth = canvasPic.backgroundImage.width;
			backgroundHeight = canvasPic.backgroundImage.height;
			context.drawImage(img01,0,0,backgroundWidth,backgroundHeight);
			var get64Data = canvas.toDataURL("image/jpeg",1);
			get64Data = get64Data.replace('data:image/jpeg;base64,', '');
			//get64Data = get64Data.replace('data:image/png;base64,', '');
			var setParam = {
				'appname':'NAIS3WEB',
				'prgname':'W242',
				'ssid': $('#ssid').val(),
				'inoutKbn' : inoutKbn,
				'chimei_codeA' : chimei_codeA,
				'chimei_codeB' : chimei_codeB,
				'mizusaki_code' : mizusaki_code,
				'map_number' : map_number,
				'imageData' : get64Data,
				'arguments':'ssid,inoutKbn,chimei_codeA,chimei_codeB,mizusaki_code,map_number,imageData'
			};
			$.ajax({
				async : true,
				url: ajaxURL,
				type:'POST',
				data : setParam,
				dataType:'xml',
				scriptCharset: 'utf-8',
				success : function(xml){
					var downloadHtml ='<span>'+$(xml).find('message').text()+'</span>';
					$('#dialogDoenloadContents').empty();
					$('#dialogDoenloadContents').append(downloadHtml);
					$('#dialogDoenload').dialog('open');
				},
				error : function(XMLHttpRequest, textStatus, errorThrown){
					cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
				}
			});
		};
	});
	
	$('#btnClose').on('click',function(){
		$('#dialogClose').dialog('open');
	});
	
	$('.btnManual').on('click',function(){
		var manualURL = $(this).attr('data-ManualURL');
		window.open(manualURL);
	});
	
});

function setBackground(){
	$('#divCanvas').css('width',backgroundWidth * canvasZoom);
	$('#divCanvas').css('height',backgroundHeight * canvasZoom);
	$('#divCanvas').parent('div').css('width',(backgroundWidth * canvasZoom)+230);
	$('#cnvPic400').attr('width',backgroundWidth);
	$('#cnvPic400').attr('height',backgroundHeight);
	
	canvasPic = new fabric.Canvas('cnvPic', {
		width: backgroundWidth * canvasZoom,
		height: backgroundHeight * canvasZoom
	});
	canvasPic.setBackgroundImage(canvasBackURL, canvasPic.renderAll.bind(canvasPic), {
		top: 0,
		left: 0,
		originX: 'left',
		originY: 'top',
		scaleX: canvasZoom,
		scaleY: canvasZoom
	});
	canvasPic.renderAll();
	
	canvasPic.on('object:selected', function(o){
		var activeObj = o.target;
		activeObj.set({'borderColor':'#F00','cornerColor':'#F00'});
	});
}

function addTag(){
	fabric.Image.fromURL('../webnais/images/pic_tag.png', function(oImg) {
		oImg.left = 200;
		oImg.top = 200;
		oImg.width = tagWidth*tagWidthZoom;
		oImg.height = tagHeight*tagHeightZoom;
		canvasPic.add(oImg);
	});
}

function NPHelp(){
	var hdnWebDocAlias = $('#hdnWebDocAlias').val();
	window.open(hdnWebDocAlias+"help/nphelp_search001.htm");
}