// JavaScript Document
var web_doc_alias = '';
var calcHarvorFrom = '',calcHarvorFrom2 = '';
var calcHarvorTo = '',calcHarvorTo2 = '';
var newCalcFlg = true;
$(document).ready(function(){
	setupZoomModal('harbor');
	setupZoomModal('shipName');
	web_doc_alias = $('#web_doc_alias').val();

	$('.hiro').addClass("d-none");

	$.validator.addMethod('plus', function(value, element) {
		if ( this.optional( element ) ) {
			return true;
		}
		if (Number(value) < 0) {
			return false;
		}
		return true;
	}, '正の値を入力してください。');

	$('#form_A700').validate({
		ignore: [],
		rules : {
			inpGT : {
				plus: true
			},
			inpDW : {
				plus: true
			},
			inpLOA : {
				plus: true
			},
			inpDFF : {
				plus: true
			},
			inpDFA : {
				plus: true
			},
			hdnHarvorCdFrom : {
				required: true
			},
			hdnHarvorCdTo : {
				required: true
			},
			inpKikan : {
				required: true,
				min : 1
			},
		},
		messages: {
			hdnHarvorCdFrom : {
				required: '乗船地を選択して下さい。'
			},
			hdnHarvorCdTo : {
				required: '下船地を選択して下さい。'
			},
			inpJousenDate : {
				required: '乗船日を入力してください。'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parent();
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});
	
	// ズームのコールバック関数を設定
	// zoomCallBackFncはzoom_agency.js内で宣言
	zoomCallBackFnc['callBackHarvor'] = callBackHarvor;
	
	//翻訳処理を設定
	$('.shipNameTrans').on('blur',function(){
		var prevVal = $(this).attr('data-prevVal');
		var newVal = $(this).val();
		if(prevVal !== newVal && newVal !== ''){
			getShipName();
		}
		$(this).attr('data-prevVal',newVal);
	});
	
	$('#btnCalc').on('click',function(){
		$('#lblErrDispCheck').text('');
		if($('#form_A700').valid()){
			//$('#divListkoro').empty(); 
			calcChoryuChoseki('0');
		}

	});

	$('#btnPrint').on('click',function(){
		if($('#form_A700').valid()){
			calcChoryuChoseki('2');
		}
	});
	
	$('#btnKoro').on('click',function(){
		var myModal= document.getElementById('mdlKoroLost');
		var modal= bootstrap.Modal.getOrCreateInstance(myModal)
		modal.show();
	});
	$('#chkAllKoro').on('change',function(){
		$('.chbKoro').prop('checked',$(this).prop('checked'));
	});
	$('#btnKoroCalc').on('click',function(){
		calcChoryuChoseki('0');
	});
	$('#btnKoro').prop('disabled',true);
	
	$('#btnBack').on('click',function(){
		$('#prgname').val('A020');
		$('#param1').val('0');
		$('#menuForm').submit();
	});
});

function getShipName(){
	var param = {
		'appname': nasiappname,
		'prgname':'A520',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': $('#inpImoNo').val(), //IMO No.
		'param4': '', //ｺｰﾙｻｲﾝ
		'param5': '', //検索文字列
		'arguments':'param1,param2,param3,param4,param5'
	};
	var zoomXml = ajaxFunction(param);
	var kekka = $(zoomXml).find('ret').text();
	if(kekka === 'I001'){
		var shipName = $(zoomXml).find('shipName').text();
		var IMONo = $(zoomXml).find('IMONo').text();
		var GT = Number($(zoomXml).find('GT').text());
		var newGT = Number($(zoomXml).find('newGT').text());
		var DW = Number($(zoomXml).find('DW').text());
		var LOA = Number($(zoomXml).find('LOA').text());
		$('#inpImoNo').val(IMONo);
		$('#spnShipName').text(shipName);
		if(newGT !== 0){
			$('#inpGT').val(newGT);
		}else {
			$('#inpGT').val(GT);
		}
		$('#inpDW').val(DW);
		$('#inpLOA').val(LOA);
	}else {
		$('#spnShipName').text('');
		$('#inpGT').text('');
		$('#inpDW').text('');
		$('#inpLOA').text('');
	}
}

function callBackHarvor(){
	var newHarvorFrom = $('#hdnHarvorCdFrom').val();
	var newHarvorFrom2 = $('#hdnHarvorCdFrom2').val();
	var newHarvorTo = $('#hdnHarvorCdTo').val();
	var newHarvorTo2 = $('#hdnHarvorCdTo2').val();
	if(calcHarvorFrom !== newHarvorFrom || calcHarvorFrom2 !== newHarvorFrom2 || calcHarvorTo !== newHarvorTo || calcHarvorTo2 !== newHarvorTo2){
		newCalcFlg = true;
		$('#btnKoro').prop('disabled',true);
	}
	if (newHarvorTo==='330' && (newHarvorTo2==='00' || newHarvorTo2==='01' || newHarvorTo2==='02' || newHarvorTo2==='03')){
		$('.hiro').removeClass('d-none');
	} else {
		$('.hiro').addClass('d-none');
	}
}

function calcChoryuChoseki(printKbn){
	var dispKbn = '0';
	if(!newCalcFlg){
		dispKbn = '1';
	}
	var chbDojiChakusanVal = 0;
	if($('#chbDojiChakusan').prop('checked')){ 
		chbDojiChakusanVal = 1;
	}
	var calcKoroPID = [];
	// 航路リストの中でチェックが付いているものを対象とする
	$('.chbKoro').each(function(){
		if($(this).prop('checked')){
			calcKoroPID.push($(this).attr('data-koropid'));
		}
	});
	var param = {
		'appname': nasiappname,
		'prgname':'A710',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': dispKbn,
		'param4': $('#inpImoNo').val(),
		'param5': $('#inpGT').val(),
		'param6': $('#inpDW').val(),
		'param7': $('#inpLOA').val(),
		'param8': $('#inpDFF').val(),
		'param9': $('#inpDFA').val(),
		'param10': $('#hdnHarvorCdFrom').val(),
		'param11': $('#hdnHarvorCdFrom2').val(),
		'param12': $('#slctSetsugangenFrom').val(),
		'param13': $('#hdnHarvorCdTo').val(),
		'param14': $('#hdnHarvorCdTo2').val(),
		'param15': $('#slctSetsugangenTo').val(),
		'param16': $('#inpJousenDate').val(),
		'param17': $('#inpJousenTime').val(),
		'param18': $('#inpKikan').val(),
		'param19': calcKoroPID.join(':'),
		'param20': chbDojiChakusanVal,
		'param21': printKbn,
		'arguments':'param1,param2,param3,param4,param5,param6,param7,param8,param9,param10,param11,param12,param13,param14,param15,param16,param17,param18,param19,param20,param21'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001'){
		newCalcFlg = false;
		createKoroList(retXml);
		$('#divCalcRet').empty();
		
		var dispMsgHtml = '';
		for(var msgIDX=1; msgIDX<=9; msgIDX++){
			var dispMsg = $(retXml).find('seigenMsg0'+msgIDX).text();
			if(dispMsg !== ''){
				dispMsgHtml = dispMsgHtml + 
					'<div class="row">' +
						'<div class="col-12">' +
							'<h6 class="text-danger">' + dispMsg + '</h6>' +
						'</div>' +
					'</div>';
			}
		}
		if (dispMsgHtml !== ''){
			dispMsgHtml = '<div class="mb-2">' + dispMsgHtml + '</div>';
			$('#divCalcRet').append(dispMsgHtml);
		}

		var dispCalcHtml = '';
		var prevDate = '';
		var printRequestNo ='';

		$(retXml).find('calcline').each(function(){
			var headTitle = $(this).find('headTitle').text();
			var headDate = $(this).find('hiduke').text();
			printRequestNo = $(this).find('printRequestNo').text();
			if (headDate !== prevDate){
				dispCalcHtml = dispCalcHtml + 
				'<div class="mb-3">' +
					'<div class="row">' +
						'<div class="col-12">' +
							'<h5 class="text-primary">' + headDate + '</h5>' +
						'</div>' +
					'</div>';
				prevDate = headDate;
			}
			dispCalcHtml = dispCalcHtml + 
				'<div class="mb-3">' +
					'<div class="row">' +
						'<div class="col-12">' +
							'<h5><u>' + headTitle + '</u></h5>' +
						'</div>' +
					'</div>';
			$(this).find('joholine').each(function(){
				var johoBiko = $(this).find('johoBiko').text(); 
				var johoFT1 = $(this).find('johoFT1').text();
				var johoFT2 = $(this).find('johoFT2').text();
				var johoFT3 = $(this).find('johoFT3').text();
				var johoFT4 = $(this).find('johoFT4').text();
				var johoMaxD = $(this).find('johoMaxD').text();
				var johoSB = $(this).find('johoSB').text();
				dispCalcHtml = dispCalcHtml + 
					'<div class="row mt-1">' +
						'<div class="col-1"></div>' +
						'<div class="col-2"><span>' + johoBiko + '</span></div>' + 
						'<div class="col-2"><span>' + johoFT1 + '</span></div>' + 
						'<div class="col-2"><span>' + johoFT2 + '</span></div>' + 
						'<div class="col-2"><span>' + johoFT3 + '</span></div>' + 
						'<div class="col-2"><span>' + johoFT4 + '</span></div>' + 
					'</div>';
			});
			dispCalcHtml = dispCalcHtml + 
				'</div>';
		});
		$('#divCalcRet').append(dispCalcHtml);

		if(printKbn === '2'){
			printChoryuChoseki(printRequestNo);
		}

	}else {
		$('#divCalcRet').empty();
	}
}

function createKoroList(xml){
	$('#divListkoro').empty();
	if ($(xml).find('koroAllChecked').text()==='1'){
		$('#chkAllKoro').prop('checked',true);
	} else {
		$('#chkAllKoro').prop('checked',false);
	};
	
	$(xml).find('koro').each(function(){
		var koroPKBN = $(this).find('koroPKBN').text();
		var koroPID = $(this).find('koroPID').text();
		var koroName = $(this).find('koroName').text();
		var koroChecked = $(this).find('koroChecked').text();
		var addRow = '<div class="row">'+
						'<div class="col-1">'+
							'<input type="checkbox" class="chbKoro" data-koropkbn="'+koroPKBN+'"'+
							' data-koropid="'+koroPID+'"'+
							' data-koroname="'+koroName+'"'+
							' '+koroChecked+
							'>' +
						'</div>'+
						'<div class="col-11">'+
							koroName +
						'</div>'+
					'</div>';
		$('#divListkoro').append(addRow);
	});
	
	$('#btnKoro').prop('disabled',false);
}

function printChoryuChoseki(printRequestNo){
	newWindowOpen("潮流潮汐計算印刷",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550','A720',nasiappname,$('#ssid').val(),printRequestNo,'','','','','','','');
}

function newWindowOpen(windowNM,windowOption,callPG,opt1,opt2,opt3,opt4,opt5,opt6,opt7,opt8,opt9,opt10){
	window.open("",windowNM,windowOption);
	$('#windowForm').attr('target',windowNM);
	$('#wprgname').val(callPG);
	$('#w_param1').val(opt1);
	$('#w_param2').val(opt2);
	$('#w_param3').val(opt3);
	$('#w_param4').val(opt4);
	$('#w_param5').val(opt5);
	$('#w_param6').val(opt6);
	$('#w_param7').val(opt7);
	$('#w_param8').val(opt8);
	$('#w_param9').val(opt9);
	$('#w_param10').val(opt10);
	$('#windowForm').submit();
	$('#windowForm').attr('target','_self');
}

