// JavaScript Document
var web_doc_alias = '';
var unkoCd = '';
var sodairiCd = '';
var mizusakiCd = '';
var validPtn = '';
$(document).ready(function(){
	setupZoomModal('dairiten');
	web_doc_alias = $('#web_doc_alias').val();

	// ズームのコールバック関数を設定
	// zoomCallBackFncはzoom_agency.js内で宣言
	zoomCallBackFnc['callBackUnko'] = callBackUnko;
	zoomCallBackFnc['callBackSodairi'] = callBackSodairi;
	zoomCallBackFnc['callBackMizusakiryo'] = callBackMizusakiryo;

    $.validator.addMethod(
        'mojichk',
        function(value,element,num){
            count = textbyte(value);
            if (this.optional(element)){
                return true;
            } else if (count > num){
                return false;
            } else {
                return true;
            }
        },       
    );
	//▼禁止文字チェック(& , % # + \)
    $.validator.addMethod(
        'kinshi',
        function(value,element){
            if (this.optional(element)){
                return true;
            } else if (value.match(/&/i) == "&"){
                return false;
            } else if (value.match(/,/i) == ","){
                return false;
            } else if (value.match(/%/i) == "%"){
                return false;
            } else if (value.match(/#/i) == "#"){
                return false;
            } else if (value.match(/\+/i) == "\+"){
                return false;
            } else if (value.match(/\\/i) == "\\"){
                return false;
            } else if (value.match(/</i) == "<"){
                return false;
            } else if (value.match(/>/i) == ">"){
                return false;
            } else {
                return true;
            }
        },'入力できない文字が含まれています。'  
    );

	$('#form_A110').validate({
		ignore: [], //type="hidden"項目のエラーチェックを可能とする
		rules : {
			inpTanto : {
				required: function(){return validPtn == '1';} ,
                mojichk: 20,
				kinshi: true
			},
			inpTan_renraku : {
				required: function(){return validPtn == '1';} ,
				mojichk: 60,
				kinshi: true
			},
			inpUnko : {
				mojichk: 30,
				kinshi: true
			},
			inpSodairi : {
				mojichk: 30,
				kinshi: true
			},
			rdoSeikyu : {
				required:  function(){return validPtn == '1';} 
			},
			rdoMizusaki_ryo : {
				required:  function(){return validPtn == '1';} 
			},
			rdoGainai : {
				required:  function(){return validPtn == '1';} 
			},
			rdoTax : {
				required:  function(){return validPtn == '1';} 
			},
			txtTokki : {
				mojichk: 200,
				kinshi: true
			},
		},
		messages: {
			inpTanto : {
				required: '担当者名を入力して下さい。',
                mojichk: '文字数オーバー(全角10文字,半角20文字)'
			},
			inpTan_renraku : {
				required: '緊急連絡先を入力して下さい。',
                mojichk: '文字数オーバー(全角30文字,半角60文字)'
			},
			inpUnko : {
				mojichk: '文字数オーバー(全角15文字,半角30文字)。'
			},
			inpSodairi : {
				mojichk: '文字数オーバー(全角15文字,半角30文字)。'
			},
			rdoSeikyu : {
				required: '請求書送付先を指定して下さい。'
			},
			rdoMizusaki_ryo : {
				required: '水先料支払者を指定して下さい。'
			},
			rdoGainai : {
				required: '外航/内航税区分を指定して下さい。'
			},
			rdoTax : {
				required: '消費税課税区分を指定して下さい。'
			},
			txtTokki : {
                mojichk: '文字数オーバー(全角100文字,半角200文字)'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parent();
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});

	//諸口欄の追加/削除（運航者）
	var unkoCheck = function() {
		if (unkoCd != $('#hdnUnko_cda').val() + $('#hdnUnko_cdb').val()) {
			if ($('#hdnUnko_cda').val() + $('#hdnUnko_cdb').val() == '000100') {
				$('#hdnUnko').after('<input type="text" id="inpUnko" name="inpUnko" class="inp_20em" maxlength="30"></input>');
				$('#inpUnko').val($('#hdnUnko').val());
				$('#hdnUnko').val();
			}else{
				$('#inpUnko').remove();
			}
			unkoCd = $('#hdnUnko_cda').val() + $('#hdnUnko_cdb').val();
		}
	};
	setInterval(unkoCheck,300);

	//クリア処理（運航者）
	$('#btnClUnko').on('click',function(){
		$('#spnUnko_name').text('');
		$('#hdnUnko_cda').val('0000');
		$('#hdnUnko_cdb').val('00');
		$('#inpUnko').val('');
	});

	//諸口欄の追加/削除（総代理店）
	var sodairiCheck = function() {
		if (sodairiCd != $('#hdnSodairi_cda').val() + $('#hdnSodairi_cdb').val()) {
			if ($('#hdnSodairi_cda').val() + $('#hdnSodairi_cdb').val() == '000100') {
				$('#hdnSodairi').after('<input type="text" id="inpSodairi" name="inpSodairi" class="inp_20em" maxlength="30">');
				$('#inpSodairi').val($('#hdnSodairi').val());
				$('#hdnSodairi').val();
			}else{
				$('#inpSodairi').remove();
			}
			sodairiCd = $('#hdnSodairi_cda').val() + $('#hdnSodairi_cdb').val();
		}
	};
	setInterval(sodairiCheck,300);

	//クリア処理（国内総代理店）
	$('#btnClSodairi').on('click',function(){
		$('#spnSodairi_name').text('');
		$('#hdnSodairi_cda').val('0000');
		$('#hdnSodairi_cdb').val('00');
		$('#inpSodairi').val('');
	});

	var selectVal = $('*[name="rdoMizusaki_ryo"]:checked').val();
	if(selectVal === '9'){
		$('#btnZoomMizusakiryo').prop('disabled',false);
		$('#btnClMizusakiryo').prop('disabled',false);
	}else {
		$('#btnZoomMizusakiryo').prop('disabled',true);
		$('#btnClMizusakiryo').prop('disabled',true);
		$('#spnMizusaki_ryo_name').text('');
		$('#hdnMizusakiryo_cda').val('0000');
		$('#hdnMizusakiryo_cdb').val('00');
		$('#inpMizusaki_ryo').val('');
		$('#inpMizusaki_ryo').remove();
	}
	// 水先料支払い者選択時処理
	$('*[name="rdoMizusaki_ryo"]').on('change',function(){
		var selectVal = $(this).val();
		if(selectVal === '9'){
			$('#btnZoomMizusakiryo').prop('disabled',false);
			$('#btnClMizusakiryo').prop('disabled',false);
		}else {
			$('#btnZoomMizusakiryo').prop('disabled',true);
			$('#btnClMizusakiryo').prop('disabled',true);
			$('#spnMizusaki_ryo_name').text('');
			$('#hdnMizusakiryo_cda').val('0000');
			$('#hdnMizusakiryo_cdb').val('00');
			$('#inpMizusaki_ryo').val('');
			$('#inpMizusaki_ryo').remove();
		}
	});
	//諸口欄の追加/削除（水先料支払者）
	var mizusakiCheck = function() {
		if (mizusakiCd != $('#hdnMizusakiryo_cda').val() + $('#hdnMizusakiryo_cdb').val()) {
			if ($('#hdnMizusakiryo_cda').val() + $('#hdnMizusakiryo_cdb').val() == '000100') {
				$('#hdnMizusaki_ryo').after('<input type="text" id="inpMizusaki_ryo" name="inpMizusaki_ryo" class="inp_20em" maxlength="30">');
				$('#inpMizusaki_ryo').val($('#hdnMizusaki_ryo').val());
				$('#hdnMizusaki_ryo').val();
			}else{
				$('#inpMizusaki_ryo').remove();
			}
			mizusakiCd = $('#hdnMizusakiryo_cda').val() + $('#hdnMizusakiryo_cdb').val();
		}
	};
	setInterval(mizusakiCheck,300);

	//クリア処理（水先料支払者）
	$('#btnClMizusakiryo').on('click',function(){
		$('#spnMizusaki_ryo_name').text('');
		$('#hdnMizusakiryo_cda').val('0000');
		$('#hdnMizusakiryo_cdb').val('00');
		$('#inpMizusaki_ryo').val('');
	});

	//キャンセル
	$('#btnBack').on('click',function(){
		modalAlert('1','確認','入力が取り消されますが、よろしいですか？',callbackCancel);
	});
	
	//一時保存
	$('#btnSave').on('click',function(){
		setValue();
		validPtn = '0';
			if($('#form_A110').valid()){
				updateMizusakiIrai1('1');
			}else {
				modalAlert('0','エラー！','入力内容を確認してください。');
			}
	});

	//本船情報入力へ進む
	$('#btnNext').on('click',function(){
		setValue();
		validPtn = '1';
		var errCount = 0;

		errCount = errCount + callBackUnko();
		errCount = errCount + callBackSodairi();
		errCount = errCount + callBackMizusakiryo();
		
		if($('#form_A110').valid()){
			if(errCount == 0) {
				$('#lblErrUnko').text('');
				$('#lblErrSodairi').text('');
				$('#lblErrMizusaki').text('');
				updateMizusakiIrai1('2');
			} else {
				modalAlert('0','エラー！','入力内容を確認してください。');
				return false;
			}
		}else {
			modalAlert('0','エラー！','入力内容を確認してください。');
		}
	});

});

//▼文字バイト数計算  ※文字数チェックから呼び出し
function textbyte(str) {
        count=0;
        for(i=0;i<str.length;i++)
        (str.charAt(i).match(/[ｱ-ﾝ]/) || encodeURI(str.charAt(i)).length< 4)?count++:count+=2;
        return count;
}

//ラジオボタンの値セット
function setValue(){
	$('#hdnFukiName').val($('input[name=rdoFukiName]:checked').val());
	$('#hdnSeikyu').val($('input[name=rdoSeikyu]:checked').val());
	$('#hdnMizusaki_ryo_k').val($('input[name=rdoMizusaki_ryo]:checked').val());
	$('#hdnGainai').val($('input[name=rdoGainai]:checked').val());
	$('#hdnTax').val($('input[name=rdoTax]:checked').val());
}

//更新処理
function updateMizusakiIrai1(syoriKbn){
	var param = {
		'appname': nasiappname,
		'prgname':'A111',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': $('#kubun').val(),
		'param4': syoriKbn,
		'param5': $('#k_order_no').val(),
		'param6': $('#inpTanto').val(),
		'param7': $('#inpTan_renraku').val(),
		'param8': $('#hdnUnko_cda').val(),
		'param9': $('#hdnUnko_cdb').val(),
		'param10': $('#inpUnko').val(),
		'param11': $('#hdnSodairi_cda').val(),
		'param12': $('#hdnSodairi_cdb').val(),
		'param13': $('#inpSodairi').val(),
		'param14': $('#hdnSeikyu').val(),
		'param15': $('#hdnMizusaki_ryo_k').val(),
		'param16': $('#hdnMizusakiryo_cda').val(),
		'param17': $('#hdnMizusakiryo_cdb').val(),
		'param18': $('#inpMizusaki_ryo').val(),
		'param19': $('#hdnTax').val(),
		'param20': $('#hdnGainai').val(),
		'param21': $('#txtTokki').val(),
		'param22': $('#hdnFukiName').val(),
		'arguments':'param1,param2,param3,param4,param5,param6,param7,param8,param9,param10,param11,param12,param13,param14,param15,param16,param17,param18,param19,param20,param21,param22'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	if(kekka === 'I001'){
		if(syoriKbn === '1'){
			$('#prgname').val('A130');
			$('#menuForm').submit();
		}else {
			$('#arguments').val('paramAppName,ssid,parentPG,param1,param2,param3,param4,param5,param6,param7,param8,param9,param10');
			$('#prgname').val('A112');
			$('#param1').val($('#kubun').val());
			$('#param2').val($('#k_order_no').val());
			$('#menuForm').submit();
		}
	}
}

function callbackCancel(){
	/* 2022/03/18 戻るボタンで遷移する先をトップページに変更
	$('#prgname').val('A130');
	$('#menuForm').submit();
	*/
	$('#prgname').val($('#parentPG').val());
	$('#param1').val('0');
	$('#menuForm').submit();
}

//lblErr処理
function callBackUnko(){
	if($('#hdnUnko_cda').val() + $('#hdnUnko_cdb').val() =='000000'){
		$('#lblErrUnko').text('運航者名を指定して下さい。');
		return 1;
	}else if($('#hdnUnko_cda').val() + $('#hdnUnko_cdb').val() =='000100' && $('#inpUnko').val() == ''){
		$('#lblErrUnko').text('運航者名を指定して下さい。');
		return 1;
	}else {
		$('#lblErrUnko').text('');
		return 0;
	}
}

function callBackSodairi(){
	if($('#hdnSodairi_cda').val() + $('#hdnSodairi_cdb').val() =='000100' && $('#inpSodairi').val() == ''){
		$('#lblErrSodairi').text('国内総代理店を指定して下さい。');
		return 1;
	}else if($('#hdnSeikyu').val() == '3' && $('#hdnSodairi_cda').val() + $('#hdnSodairi_cdb').val() =='000000'){
		$('#lblErrSodairi').text('国内総代理店を指定して下さい。');
		return 1;
	}else if($('#hdnMizusaki_ryo_k').val() == '3' && $('#hdnSodairi_cda').val() + $('#hdnSodairi_cdb').val() =='000000'){
		$('#lblErrSodairi').text('国内総代理店を指定して下さい。');
		return 1;
	}else {
		$('#lblErrSodairi').text('');
		return 0;
	}
}

function callBackMizusakiryo(){
	if($('#hdnMizusaki_ryo_k').val() == '9' && $('#hdnMizusakiryo_cda').val() + $('#hdnMizusakiryo_cdb').val() =='000000'){
		$('#lblErrMizusaki').text('水先料支払者を指定して下さい。');
		return 1;
	}else if($('#hdnMizusaki_ryo_k').val() == '9' && $('#hdnMizusakiryo_cda').val() + $('#hdnMizusakiryo_cdb').val() =='000100' && $('#inpMizusaki_ryo').val() == ''){
		$('#lblErrMizusaki').text('水先料支払者を指定して下さい。');
		return 1;
	}else {
		$('#lblErrMizusaki').text('');
		return 0;
	}
}