// JavaScript Document
var web_doc_alias = '';
$(document).ready(function(){
	// harborのZoomは代理店別の制限版を使用する
	setupZoomModal('harborAgency');
	setupZoomModal('shipName');
	web_doc_alias = $('#web_doc_alias').val();

	$.validator.addMethod('plus', function(value, element) {
		if ( this.optional( element ) ) {
			return true;
		}
		if (Number(value) < 0) {
			return false;
		}
		return true;
	}, '正の値を入力してください。');

	$('#form_A400').validate({
		ignore: [], //type="hidden"項目のエラーチェックを可能とする
		rules : {
			inpTotalTon : {
				required: true,
				plus: true
			},
			inpWeightTon : {
				required: true,
				plus: true
			},
			inpSpeed : {
				required: true,
				plus: true
			},
			inpDF : {
				required: true,
				plus: true
			},
			slctShipType : {
				required: true
			},
			hdnHarvorCdFrom : {
				required: true
			},
			hdnHarvorCdTo : {
				required: true
			},
			rdoTimeKbn : {
				required: true
			},
		},
		messages: {
			inpWeightTon : {
				required: '重量トン数を入力して下さい。'
			},
			inpSpeed : {
				required: '速力を入力して下さい。'
			},
			inpDF : {
				required: 'D/Fを入力して下さい。'
			},
			slctShipType : {
				required: '船種を選択してください。'
			},
			hdnHarvorCdFrom : {
				required: '区間（自）を選択して下さい。'
			},
			hdnHarvorCdTo : {
				required: '区間（至）を選択して下さい。'
			},
			rdoTimeKbn : {
				required: '時間を選択して下さい。'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parent();
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});
	
	// ズームのコールバック関数を設定
	// zoomCallBackFncはzoom_agency.js内で宣言
	zoomCallBackFnc['callBackHarvor'] = callBackHarvor;
	
	//翻訳処理を設定
	$('.shipNameTrans').on('blur',function(){
		var prevVal = $(this).attr('data-prevVal');
		var newVal = $(this).val();
		if(prevVal !== newVal && newVal !== ''){
			getShipName();
		}
		$(this).attr('data-prevVal',newVal);
	});
	
	
	$('#btnCalc').on('click',function(){
		if($('#form_A400').valid()){
			updateMitsumori('1');
		}
	});

	$('#btnPrint').on('click',function(){
		if($('#form_A400').valid()){
			updateMitsumori('2');
		}
	});

	/*
	$('#btnUpdate').on('click',function(){
		if($('#form_A400').valid()){
			updateMitsumori('3');
		}
	});
	*/
	
	$('#btnBack').on('click',function(){
		$('#prgname').val('A020');
		$('#param1').val('0');
		$('#menuForm').submit();
	});
});

function getShipName(){
	var param = {
		'appname': nasiappname,
		'prgname':'A520',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': $('#inpImoNo').val(),
		'param4': '', //$('#inpCallSigne').val(),
		'param5': '', //検索文字列
		'arguments':'param1,param2,param3,param4,param5'
	};
	var zoomXml = ajaxFunction(param);
	var kekka = $(zoomXml).find('ret').text();
	if(kekka === 'I001'){
		var shipName = $(zoomXml).find('shipName').text();
		var IMONo = $(zoomXml).find('IMONo').text();
		var callSigne = $(zoomXml).find('callSigne').text();
		var GT = Number($(zoomXml).find('GT').text());
		var newGT = Number($(zoomXml).find('newGT').text());
		var DW = Number($(zoomXml).find('DW').text());
		var shipType = $(zoomXml).find('shipType').text();
		var DF = Number($(zoomXml).find('DF').text());
		$('#inpImoNo').val(IMONo);
		$('#inpCallSigne').val(callSigne);
		$('#spnShipName').text(shipName);
		if(newGT !== 0){
			$('#inpTotalTon').val(newGT);
		}else {
			$('#inpTotalTon').val(GT);
		}
		$('#inpWeightTon').val(DW);
		$('#slctShipType').val(shipType);
		//$('#inpDF').val(DF);
	}else {
		$('#spnShipName').text('');
		$('#inpTotalTon').val('');
		$('#inpWeightTon').val('');
		$('#slctShipType').val('');
		$('#inpDF').val('');
	}
}

function callBackHarvor(){
	if($('#spnHarvorNameFrom').text() !== '' && $('#spnHarvorNameTo').text() !== ''){
		var param = {
			'appname': nasiappname,
			'prgname':'A410',
			'param1': nasiappname,
			'param2': $('#ssid').val(),
			'param3': $('#hdnHarvorCdFrom').val(),
			'param4': $('#hdnHarvorCdFrom2').val(),
			'param5': $('#hdnHarvorCdTo').val(),
			'param6': $('#hdnHarvorCdTo2').val(),
			'arguments':'param1,param2,param3,param4,param5,param6'
		};
		var retXml = ajaxFunction(param);
		var kekka = $(retXml).find('ret').text();
		if(kekka === 'I001'){
			$('#spnHarvorDistance').text($(retXml).find('distance').text());
		}else {
			$('#spnHarvorDistance').text('');
		}
	}
}

function updateMitsumori(syoriKbn){
	var param = {
		'appname': nasiappname,
		'prgname':'A420',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': syoriKbn,
		'param4': $('#inpImoNo').val(),
		'param5': $('#inpCallSigne').val(),
		'param6': $('#inpDate').val(),
		'param7': $('#inpTotalTon').val(),
		'param8': $('#inpWeightTon').val(),
		'param9': $('#slctShipType').val(),
		'param10': $('#inpDF').val(),
		'param11': $('#hdnHarvorCdFrom').val(),
		'param12': $('#hdnHarvorCdFrom2').val(),
		'param13': $('#hdnHarvorCdTo').val(),
		'param14': $('#hdnHarvorCdTo2').val(),
		'param15': $('*[name="rdoTimeKbn"]:checked').val(),
		'param16': $('#inpSpeed').val(),
		'param17': $('#chbTenbyo').prop('checked'),
		'param18': $('*[name="rdoTimeKbnOut"]:checked').val(),
		'param19': $('*[name="rdoTimeKbnIn"]:checked').val(),
		'param20': $('#chbLoa300').prop('checked'),
		'arguments':'param1,param2,param3,param4,param5,param6,param7,param8,param9,param10,param11,param12,param13,param14,param15,param16,param17,param18,param19,param20'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	$('#spnCalcMitsumori').html('&nbsp;');
	$('#divMsg').empty();
	$('#divDetail').empty();
	if(kekka === 'I001'){
		$('#spnCalcMitsumori').text($(retXml).find('retCalc').text());
		$('#quoteOrderno').val($(retXml).find('retQuoteOrderno').text());

		var dispMessageHtml = '';
		$(retXml).find('msgLine').each(function(){
			var msg = $(this).find('msg').text(); 
			dispMessageHtml = dispMessageHtml + 
				'<div class="row">' +
					'<div class="col-12 fw-bold text-danger"><span>' + msg + '</span></div>' + 
				'</div>';
		});
		$('#divMsg').append(dispMessageHtml);

		var dispDetailHtml = '';
		$(retXml).find('line').each(function(){
			var lineKbn = $(this).find('lineKbn').text(); 
			var lineNo = $(this).find('lineNo').text(); 
			var title = $(this).find('title').text();
			var amount = $(this).find('amount').text();
			var align = ''
			if (lineKbn==='1'){
				align = 'text-end mb-2';
			}
			dispDetailHtml = dispDetailHtml + 
				'<div class="row mt-1">' +
					'<div class="col-1 text-end"><span>' + lineNo + '</span></div>' + 
					'<div class="col-6 ' + align + '"><span>' + title + '</span></div>' + 
					'<div class="col-2 text-end"><span>' + amount + '</span></div>' + 
					'<div class="col-3"><span></span></div>' + 
				'</div>';
		});
		$('#divDetail').append(dispDetailHtml);

		if(syoriKbn === '2'){
			printMitsumori();
		}
	}
}

function printMitsumori(){
	newWindowOpen("水先料見積印刷",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550','A430',nasiappname,$('#ssid').val(),$('#quoteOrderno').val(),'','','','','','','');
}

function newWindowOpen(windowNM,windowOption,callPG,opt1,opt2,opt3,opt4,opt5,opt6,opt7,opt8,opt9,opt10){
	window.open("",windowNM,windowOption);
	$('#windowForm').attr('target',windowNM);
	$('#wprgname').val(callPG);
	$('#w_param1').val(opt1);
	$('#w_param2').val(opt2);
	$('#w_param3').val(opt3);
	$('#w_param4').val(opt4);
	$('#w_param5').val(opt5);
	$('#w_param6').val(opt6);
	$('#w_param7').val(opt7);
	$('#w_param8').val(opt8);
	$('#w_param9').val(opt9);
	$('#w_param10').val(opt10);
	$('#windowForm').submit();
	$('#windowForm').attr('target','_self');
}

